/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.sdk.endpoint;

import com.cyberark.conjur.sdk.ApiCallback;
import com.cyberark.conjur.sdk.ApiClient;
import com.cyberark.conjur.sdk.ApiException;
import com.cyberark.conjur.sdk.ApiResponse;
import com.cyberark.conjur.sdk.Configuration;
import com.cyberark.conjur.sdk.Pair;
import com.cyberark.conjur.sdk.model.AuthenticatorStatus;
import com.cyberark.conjur.sdk.model.AuthenticatorsResponse;
import com.cyberark.conjur.sdk.model.WhoAmI;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class StatusApi {
    private ApiClient localVarApiClient;

    public StatusApi() {
        this(Configuration.getDefaultApiClient());
    }

    public StatusApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getAuthenticatorsCall(String xRequestId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/authenticators";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth", "conjurAuth", "conjurKubernetesMutualTls"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAuthenticatorsValidateBeforeCall(String xRequestId, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAuthenticatorsCall(xRequestId, _callback);
        return localVarCall;
    }

    public AuthenticatorsResponse getAuthenticators(String xRequestId) throws ApiException {
        ApiResponse<AuthenticatorsResponse> localVarResp = this.getAuthenticatorsWithHttpInfo(xRequestId);
        return localVarResp.getData();
    }

    public AuthenticatorsResponse getAuthenticators() throws ApiException {
        ApiResponse<AuthenticatorsResponse> localVarResp = this.getAuthenticatorsWithHttpInfo(null);
        return localVarResp.getData();
    }

    public ApiResponse<AuthenticatorsResponse> getAuthenticatorsWithHttpInfo(String xRequestId) throws ApiException {
        Call localVarCall = this.getAuthenticatorsValidateBeforeCall(xRequestId, null);
        Type localVarReturnType = new TypeToken<AuthenticatorsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<AuthenticatorsResponse> getAuthenticatorsWithHttpInfo() throws ApiException {
        Call localVarCall = this.getAuthenticatorsValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<AuthenticatorsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAuthenticatorsAsync(String xRequestId, ApiCallback<AuthenticatorsResponse> _callback) throws ApiException {
        Call localVarCall = this.getAuthenticatorsValidateBeforeCall(xRequestId, _callback);
        Type localVarReturnType = new TypeToken<AuthenticatorsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getGCPAuthenticatorStatusCall(String account, String xRequestId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/authn-gcp/{account}/status".replaceAll("\\{account\\}", this.localVarApiClient.escapeString(account.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"conjurAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getGCPAuthenticatorStatusValidateBeforeCall(String account, String xRequestId, ApiCallback _callback) throws ApiException {
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling getGCPAuthenticatorStatus(Async)");
        }
        Call localVarCall = this.getGCPAuthenticatorStatusCall(account, xRequestId, _callback);
        return localVarCall;
    }

    public AuthenticatorStatus getGCPAuthenticatorStatus(String account, String xRequestId) throws ApiException {
        ApiResponse<AuthenticatorStatus> localVarResp = this.getGCPAuthenticatorStatusWithHttpInfo(account, xRequestId);
        return localVarResp.getData();
    }

    public AuthenticatorStatus getGCPAuthenticatorStatus(String account) throws ApiException {
        ApiResponse<AuthenticatorStatus> localVarResp = this.getGCPAuthenticatorStatusWithHttpInfo(account, null);
        return localVarResp.getData();
    }

    public ApiResponse<AuthenticatorStatus> getGCPAuthenticatorStatusWithHttpInfo(String account, String xRequestId) throws ApiException {
        Call localVarCall = this.getGCPAuthenticatorStatusValidateBeforeCall(account, xRequestId, null);
        Type localVarReturnType = new TypeToken<AuthenticatorStatus>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<AuthenticatorStatus> getGCPAuthenticatorStatusWithHttpInfo(String account) throws ApiException {
        Call localVarCall = this.getGCPAuthenticatorStatusValidateBeforeCall(account, null, null);
        Type localVarReturnType = new TypeToken<AuthenticatorStatus>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getGCPAuthenticatorStatusAsync(String account, String xRequestId, ApiCallback<AuthenticatorStatus> _callback) throws ApiException {
        Call localVarCall = this.getGCPAuthenticatorStatusValidateBeforeCall(account, xRequestId, _callback);
        Type localVarReturnType = new TypeToken<AuthenticatorStatus>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getServiceAuthenticatorStatusCall(String authenticator, String serviceId, String account, String xRequestId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/{authenticator}/{service_id}/{account}/status".replaceAll("\\{authenticator\\}", this.localVarApiClient.escapeString(authenticator.toString())).replaceAll("\\{service_id\\}", this.localVarApiClient.escapeString(serviceId.toString())).replaceAll("\\{account\\}", this.localVarApiClient.escapeString(account.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"conjurAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getServiceAuthenticatorStatusValidateBeforeCall(String authenticator, String serviceId, String account, String xRequestId, ApiCallback _callback) throws ApiException {
        if (authenticator == null) {
            throw new ApiException("Missing the required parameter 'authenticator' when calling getServiceAuthenticatorStatus(Async)");
        }
        if (serviceId == null) {
            throw new ApiException("Missing the required parameter 'serviceId' when calling getServiceAuthenticatorStatus(Async)");
        }
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling getServiceAuthenticatorStatus(Async)");
        }
        Call localVarCall = this.getServiceAuthenticatorStatusCall(authenticator, serviceId, account, xRequestId, _callback);
        return localVarCall;
    }

    public AuthenticatorStatus getServiceAuthenticatorStatus(String authenticator, String serviceId, String account, String xRequestId) throws ApiException {
        ApiResponse<AuthenticatorStatus> localVarResp = this.getServiceAuthenticatorStatusWithHttpInfo(authenticator, serviceId, account, xRequestId);
        return localVarResp.getData();
    }

    public AuthenticatorStatus getServiceAuthenticatorStatus(String authenticator, String serviceId, String account) throws ApiException {
        ApiResponse<AuthenticatorStatus> localVarResp = this.getServiceAuthenticatorStatusWithHttpInfo(authenticator, serviceId, account, null);
        return localVarResp.getData();
    }

    public ApiResponse<AuthenticatorStatus> getServiceAuthenticatorStatusWithHttpInfo(String authenticator, String serviceId, String account, String xRequestId) throws ApiException {
        Call localVarCall = this.getServiceAuthenticatorStatusValidateBeforeCall(authenticator, serviceId, account, xRequestId, null);
        Type localVarReturnType = new TypeToken<AuthenticatorStatus>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<AuthenticatorStatus> getServiceAuthenticatorStatusWithHttpInfo(String authenticator, String serviceId, String account) throws ApiException {
        Call localVarCall = this.getServiceAuthenticatorStatusValidateBeforeCall(authenticator, serviceId, account, null, null);
        Type localVarReturnType = new TypeToken<AuthenticatorStatus>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getServiceAuthenticatorStatusAsync(String authenticator, String serviceId, String account, String xRequestId, ApiCallback<AuthenticatorStatus> _callback) throws ApiException {
        Call localVarCall = this.getServiceAuthenticatorStatusValidateBeforeCall(authenticator, serviceId, account, xRequestId, _callback);
        Type localVarReturnType = new TypeToken<AuthenticatorStatus>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call whoAmICall(String xRequestId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/whoami";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"conjurAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call whoAmIValidateBeforeCall(String xRequestId, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.whoAmICall(xRequestId, _callback);
        return localVarCall;
    }

    public WhoAmI whoAmI(String xRequestId) throws ApiException {
        ApiResponse<WhoAmI> localVarResp = this.whoAmIWithHttpInfo(xRequestId);
        return localVarResp.getData();
    }

    public WhoAmI whoAmI() throws ApiException {
        ApiResponse<WhoAmI> localVarResp = this.whoAmIWithHttpInfo(null);
        return localVarResp.getData();
    }

    public ApiResponse<WhoAmI> whoAmIWithHttpInfo(String xRequestId) throws ApiException {
        Call localVarCall = this.whoAmIValidateBeforeCall(xRequestId, null);
        Type localVarReturnType = new TypeToken<WhoAmI>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<WhoAmI> whoAmIWithHttpInfo() throws ApiException {
        Call localVarCall = this.whoAmIValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<WhoAmI>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call whoAmIAsync(String xRequestId, ApiCallback<WhoAmI> _callback) throws ApiException {
        Call localVarCall = this.whoAmIValidateBeforeCall(xRequestId, _callback);
        Type localVarReturnType = new TypeToken<WhoAmI>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

