/*
 * Conjur
 * This is an API definition for CyberArk Conjur Open Source. You can find out more at [Conjur.org](https://www.conjur.org/).
 *
 * The version of the OpenAPI document: 5.3.1
 * Contact: conj_maintainers@cyberark.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cyberark.conjur.sdk.endpoint;

import com.cyberark.conjur.sdk.ApiCallback;
import com.cyberark.conjur.sdk.ApiClient;
import com.cyberark.conjur.sdk.ApiException;
import com.cyberark.conjur.sdk.ApiResponse;
import com.cyberark.conjur.sdk.Configuration;
import com.cyberark.conjur.sdk.Pair;
import com.cyberark.conjur.sdk.ProgressRequestBody;
import com.cyberark.conjur.sdk.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.cyberark.conjur.sdk.model.Resource;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourcesApi {
    private ApiClient localVarApiClient;

    public ResourcesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ResourcesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for showResource
     * @param account Organization account name (required)
     * @param kind Type of resource (required)
     * @param identifier ID of the resource for which to get the information about (required)
     * @param permittedRoles Lists the roles which have the named privilege on a resource. (optional)
     * @param privilege Level of privilege to filter on. Can only be used in combination with &#x60;permitted_roles&#x60; or &#x60;check&#x60; parameter. (optional)
     * @param check Check whether a role has a privilege on a resource. (optional)
     * @param role Role to check privilege on. Can only be used in combination with &#x60;check&#x60; parameter. (optional)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains the list of role memberships or permitted roles </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> Permissions check was successful </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist, the authenticated user lacks the required privileges to enumerate this resource, or its value has not been set </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call showResourceCall(String account, String kind, String identifier, Boolean permittedRoles, String privilege, Boolean check, String role, String xRequestId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/resources/{account}/{kind}/{identifier}"
            .replaceAll("\\{" + "account" + "\\}", localVarApiClient.escapeString(account.toString()))
            .replaceAll("\\{" + "kind" + "\\}", localVarApiClient.escapeString(kind.toString()))
            .replaceAll("\\{" + "identifier" + "\\}", localVarApiClient.escapeString(identifier.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (permittedRoles != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("permitted_roles", permittedRoles));
        }

        if (privilege != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("privilege", privilege));
        }

        if (check != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("check", check));
        }

        if (role != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("role", role));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", localVarApiClient.parameterToString(xRequestId));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "conjurAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call showResourceValidateBeforeCall(String account, String kind, String identifier, Boolean permittedRoles, String privilege, Boolean check, String role, String xRequestId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'account' is set
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling showResource(Async)");
        }
        
        // verify the required parameter 'kind' is set
        if (kind == null) {
            throw new ApiException("Missing the required parameter 'kind' when calling showResource(Async)");
        }
        
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new ApiException("Missing the required parameter 'identifier' when calling showResource(Async)");
        }
        

        okhttp3.Call localVarCall = showResourceCall(account, kind, identifier, permittedRoles, privilege, check, role, xRequestId, _callback);
        return localVarCall;

    }

    /**
     * Shows a description of a single resource.
     * Details about a single resource.  If &#x60;permitted_roles&#x60; and &#x60;privilege&#x60; are given, Conjur lists the roles with the specified privilege on the resource.  If &#x60;check&#x60;, &#x60;privilege&#x60; and &#x60;role&#x60; are given, Conjur checks if the specified role has the privilege on the resource.  If &#x60;permitted_roles&#x60; and &#x60;check&#x60; are both given, Conjur responds to the &#x60;check&#x60; call ONLY.  ##### Permissions Required 
     * @param account Organization account name (required)
     * @param kind Type of resource (required)
     * @param identifier ID of the resource for which to get the information about (required)
     * @param permittedRoles Lists the roles which have the named privilege on a resource. (optional)
     * @param privilege Level of privilege to filter on. Can only be used in combination with &#x60;permitted_roles&#x60; or &#x60;check&#x60; parameter. (optional)
     * @param check Check whether a role has a privilege on a resource. (optional)
     * @param role Role to check privilege on. Can only be used in combination with &#x60;check&#x60; parameter. (optional)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @return Resource
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains the list of role memberships or permitted roles </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> Permissions check was successful </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist, the authenticated user lacks the required privileges to enumerate this resource, or its value has not been set </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public Resource showResource(String account, String kind, String identifier, Boolean permittedRoles, String privilege, Boolean check, String role, String xRequestId) throws ApiException {
        ApiResponse<Resource> localVarResp = showResourceWithHttpInfo(account, kind, identifier, permittedRoles, privilege, check, role, xRequestId);
        return localVarResp.getData();
    }


    /**
     * Shows a description of a single resource.
     * Details about a single resource.  If &#x60;permitted_roles&#x60; and &#x60;privilege&#x60; are given, Conjur lists the roles with the specified privilege on the resource.  If &#x60;check&#x60;, &#x60;privilege&#x60; and &#x60;role&#x60; are given, Conjur checks if the specified role has the privilege on the resource.  If &#x60;permitted_roles&#x60; and &#x60;check&#x60; are both given, Conjur responds to the &#x60;check&#x60; call ONLY.  ##### Permissions Required 
     * @param account Organization account name
     * @param kind Type of resource
     * @param identifier ID of the resource for which to get the information about
     * @return Resource
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains the list of role memberships or permitted roles </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> Permissions check was successful </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist, the authenticated user lacks the required privileges to enumerate this resource, or its value has not been set </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
    */
    public Resource showResource(String account, String kind, String identifier) throws ApiException {
        ApiResponse<Resource> localVarResp = showResourceWithHttpInfo(account, kind, identifier, null, null, null, null, null);
        return localVarResp.getData();
    }

    /**
     * Shows a description of a single resource.
     * Details about a single resource.  If &#x60;permitted_roles&#x60; and &#x60;privilege&#x60; are given, Conjur lists the roles with the specified privilege on the resource.  If &#x60;check&#x60;, &#x60;privilege&#x60; and &#x60;role&#x60; are given, Conjur checks if the specified role has the privilege on the resource.  If &#x60;permitted_roles&#x60; and &#x60;check&#x60; are both given, Conjur responds to the &#x60;check&#x60; call ONLY.  ##### Permissions Required 
     * @param account Organization account name (required)
     * @param kind Type of resource (required)
     * @param identifier ID of the resource for which to get the information about (required)
     * @param permittedRoles Lists the roles which have the named privilege on a resource. (optional)
     * @param privilege Level of privilege to filter on. Can only be used in combination with &#x60;permitted_roles&#x60; or &#x60;check&#x60; parameter. (optional)
     * @param check Check whether a role has a privilege on a resource. (optional)
     * @param role Role to check privilege on. Can only be used in combination with &#x60;check&#x60; parameter. (optional)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @return ApiResponse&lt;Resource&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains the list of role memberships or permitted roles </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> Permissions check was successful </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist, the authenticated user lacks the required privileges to enumerate this resource, or its value has not been set </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Resource> showResourceWithHttpInfo(String account, String kind, String identifier, Boolean permittedRoles, String privilege, Boolean check, String role, String xRequestId) throws ApiException {
        okhttp3.Call localVarCall = showResourceValidateBeforeCall(account, kind, identifier, permittedRoles, privilege, check, role, xRequestId, null);
        Type localVarReturnType = new TypeToken<Resource>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Shows a description of a single resource.
     * Details about a single resource.  If &#x60;permitted_roles&#x60; and &#x60;privilege&#x60; are given, Conjur lists the roles with the specified privilege on the resource.  If &#x60;check&#x60;, &#x60;privilege&#x60; and &#x60;role&#x60; are given, Conjur checks if the specified role has the privilege on the resource.  If &#x60;permitted_roles&#x60; and &#x60;check&#x60; are both given, Conjur responds to the &#x60;check&#x60; call ONLY.  ##### Permissions Required 
     * @param account Organization account name 
     * @param kind Type of resource 
     * @param identifier ID of the resource for which to get the information about 
     * @return ApiResponse&lt;Resource&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains the list of role memberships or permitted roles </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> Permissions check was successful </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist, the authenticated user lacks the required privileges to enumerate this resource, or its value has not been set </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Resource> showResourceWithHttpInfo(String account, String kind, String identifier) throws ApiException {
        okhttp3.Call localVarCall = showResourceValidateBeforeCall(account, kind, identifier, null, null, null, null, null, null);
        Type localVarReturnType = new TypeToken<Resource>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Shows a description of a single resource. (asynchronously)
     * Details about a single resource.  If &#x60;permitted_roles&#x60; and &#x60;privilege&#x60; are given, Conjur lists the roles with the specified privilege on the resource.  If &#x60;check&#x60;, &#x60;privilege&#x60; and &#x60;role&#x60; are given, Conjur checks if the specified role has the privilege on the resource.  If &#x60;permitted_roles&#x60; and &#x60;check&#x60; are both given, Conjur responds to the &#x60;check&#x60; call ONLY.  ##### Permissions Required 
     * @param account Organization account name (required)
     * @param kind Type of resource (required)
     * @param identifier ID of the resource for which to get the information about (required)
     * @param permittedRoles Lists the roles which have the named privilege on a resource. (optional)
     * @param privilege Level of privilege to filter on. Can only be used in combination with &#x60;permitted_roles&#x60; or &#x60;check&#x60; parameter. (optional)
     * @param check Check whether a role has a privilege on a resource. (optional)
     * @param role Role to check privilege on. Can only be used in combination with &#x60;check&#x60; parameter. (optional)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains the list of role memberships or permitted roles </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> Permissions check was successful </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist, the authenticated user lacks the required privileges to enumerate this resource, or its value has not been set </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call showResourceAsync(String account, String kind, String identifier, Boolean permittedRoles, String privilege, Boolean check, String role, String xRequestId, final ApiCallback<Resource> _callback) throws ApiException {

        okhttp3.Call localVarCall = showResourceValidateBeforeCall(account, kind, identifier, permittedRoles, privilege, check, role, xRequestId, _callback);
        Type localVarReturnType = new TypeToken<Resource>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for showResourcesForAccount
     * @param account Organization account name (required)
     * @param kind Type of resource (optional)
     * @param search Filter resources based on this value by name (optional)
     * @param offset When listing resources, start at this item number. (optional)
     * @param limit When listing resources, return up to this many results. (optional)
     * @param count When listing resources, if &#x60;true&#x60;, return only the count of the results. (optional)
     * @param role Retrieves the resources list for a different role if the authenticated role has access (optional)
     * @param actingAs Retrieves the resources list for a different role if the authenticated role has access (optional)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains a list of resources </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call showResourcesForAccountCall(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/resources/{account}"
            .replaceAll("\\{" + "account" + "\\}", localVarApiClient.escapeString(account.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (kind != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("kind", kind));
        }

        if (search != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("search", search));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (count != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("count", count));
        }

        if (role != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("role", role));
        }

        if (actingAs != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("acting_as", actingAs));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", localVarApiClient.parameterToString(xRequestId));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "conjurAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call showResourcesForAccountValidateBeforeCall(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'account' is set
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling showResourcesForAccount(Async)");
        }
        

        okhttp3.Call localVarCall = showResourcesForAccountCall(account, kind, search, offset, limit, count, role, actingAs, xRequestId, _callback);
        return localVarCall;

    }

    /**
     * Lists resources within an organization account.
     * Lists resources within an organization account.  If a &#x60;kind&#x60; query parameter is given, narrows results to only resources of that kind.  If a &#x60;limit&#x60; is given, returns no more than that number of results. Providing an &#x60;offset&#x60; skips a number of resources before returning the rest. In addition, providing an &#x60;offset&#x60; will give &#x60;limit&#x60; a default value of 10 if none other is provided. These two parameters can be combined to page through results.  If the parameter &#x60;count&#x60; is &#x60;true&#x60;, returns only the number of items in the list.  ##### Text search  If the &#x60;search&#x60; parameter is provided, narrows results to those pertaining to the search query. Search works across resource IDs and the values of annotations. It weighs results so that those with matching id or a matching value of an annotation called &#x60;name&#x60; appear first, then those with another matching annotation value, and finally those with a matching  &#x60;kind&#x60;. 
     * @param account Organization account name (required)
     * @param kind Type of resource (optional)
     * @param search Filter resources based on this value by name (optional)
     * @param offset When listing resources, start at this item number. (optional)
     * @param limit When listing resources, return up to this many results. (optional)
     * @param count When listing resources, if &#x60;true&#x60;, return only the count of the results. (optional)
     * @param role Retrieves the resources list for a different role if the authenticated role has access (optional)
     * @param actingAs Retrieves the resources list for a different role if the authenticated role has access (optional)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @return List&lt;Resource&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains a list of resources </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public List<Resource> showResourcesForAccount(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId) throws ApiException {
        ApiResponse<List<Resource>> localVarResp = showResourcesForAccountWithHttpInfo(account, kind, search, offset, limit, count, role, actingAs, xRequestId);
        return localVarResp.getData();
    }


    /**
     * Lists resources within an organization account.
     * Lists resources within an organization account.  If a &#x60;kind&#x60; query parameter is given, narrows results to only resources of that kind.  If a &#x60;limit&#x60; is given, returns no more than that number of results. Providing an &#x60;offset&#x60; skips a number of resources before returning the rest. In addition, providing an &#x60;offset&#x60; will give &#x60;limit&#x60; a default value of 10 if none other is provided. These two parameters can be combined to page through results.  If the parameter &#x60;count&#x60; is &#x60;true&#x60;, returns only the number of items in the list.  ##### Text search  If the &#x60;search&#x60; parameter is provided, narrows results to those pertaining to the search query. Search works across resource IDs and the values of annotations. It weighs results so that those with matching id or a matching value of an annotation called &#x60;name&#x60; appear first, then those with another matching annotation value, and finally those with a matching  &#x60;kind&#x60;. 
     * @param account Organization account name
     * @return List&lt;Resource&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains a list of resources </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
    */
    public List<Resource> showResourcesForAccount(String account) throws ApiException {
        ApiResponse<List<Resource>> localVarResp = showResourcesForAccountWithHttpInfo(account, null, null, null, null, null, null, null, null);
        return localVarResp.getData();
    }

    /**
     * Lists resources within an organization account.
     * Lists resources within an organization account.  If a &#x60;kind&#x60; query parameter is given, narrows results to only resources of that kind.  If a &#x60;limit&#x60; is given, returns no more than that number of results. Providing an &#x60;offset&#x60; skips a number of resources before returning the rest. In addition, providing an &#x60;offset&#x60; will give &#x60;limit&#x60; a default value of 10 if none other is provided. These two parameters can be combined to page through results.  If the parameter &#x60;count&#x60; is &#x60;true&#x60;, returns only the number of items in the list.  ##### Text search  If the &#x60;search&#x60; parameter is provided, narrows results to those pertaining to the search query. Search works across resource IDs and the values of annotations. It weighs results so that those with matching id or a matching value of an annotation called &#x60;name&#x60; appear first, then those with another matching annotation value, and finally those with a matching  &#x60;kind&#x60;. 
     * @param account Organization account name (required)
     * @param kind Type of resource (optional)
     * @param search Filter resources based on this value by name (optional)
     * @param offset When listing resources, start at this item number. (optional)
     * @param limit When listing resources, return up to this many results. (optional)
     * @param count When listing resources, if &#x60;true&#x60;, return only the count of the results. (optional)
     * @param role Retrieves the resources list for a different role if the authenticated role has access (optional)
     * @param actingAs Retrieves the resources list for a different role if the authenticated role has access (optional)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @return ApiResponse&lt;List&lt;Resource&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains a list of resources </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Resource>> showResourcesForAccountWithHttpInfo(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId) throws ApiException {
        okhttp3.Call localVarCall = showResourcesForAccountValidateBeforeCall(account, kind, search, offset, limit, count, role, actingAs, xRequestId, null);
        Type localVarReturnType = new TypeToken<List<Resource>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Lists resources within an organization account.
     * Lists resources within an organization account.  If a &#x60;kind&#x60; query parameter is given, narrows results to only resources of that kind.  If a &#x60;limit&#x60; is given, returns no more than that number of results. Providing an &#x60;offset&#x60; skips a number of resources before returning the rest. In addition, providing an &#x60;offset&#x60; will give &#x60;limit&#x60; a default value of 10 if none other is provided. These two parameters can be combined to page through results.  If the parameter &#x60;count&#x60; is &#x60;true&#x60;, returns only the number of items in the list.  ##### Text search  If the &#x60;search&#x60; parameter is provided, narrows results to those pertaining to the search query. Search works across resource IDs and the values of annotations. It weighs results so that those with matching id or a matching value of an annotation called &#x60;name&#x60; appear first, then those with another matching annotation value, and finally those with a matching  &#x60;kind&#x60;. 
     * @param account Organization account name 
     * @return ApiResponse&lt;List&lt;Resource&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains a list of resources </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Resource>> showResourcesForAccountWithHttpInfo(String account) throws ApiException {
        okhttp3.Call localVarCall = showResourcesForAccountValidateBeforeCall(account, null, null, null, null, null, null, null, null, null);
        Type localVarReturnType = new TypeToken<List<Resource>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Lists resources within an organization account. (asynchronously)
     * Lists resources within an organization account.  If a &#x60;kind&#x60; query parameter is given, narrows results to only resources of that kind.  If a &#x60;limit&#x60; is given, returns no more than that number of results. Providing an &#x60;offset&#x60; skips a number of resources before returning the rest. In addition, providing an &#x60;offset&#x60; will give &#x60;limit&#x60; a default value of 10 if none other is provided. These two parameters can be combined to page through results.  If the parameter &#x60;count&#x60; is &#x60;true&#x60;, returns only the number of items in the list.  ##### Text search  If the &#x60;search&#x60; parameter is provided, narrows results to those pertaining to the search query. Search works across resource IDs and the values of annotations. It weighs results so that those with matching id or a matching value of an annotation called &#x60;name&#x60; appear first, then those with another matching annotation value, and finally those with a matching  &#x60;kind&#x60;. 
     * @param account Organization account name (required)
     * @param kind Type of resource (optional)
     * @param search Filter resources based on this value by name (optional)
     * @param offset When listing resources, start at this item number. (optional)
     * @param limit When listing resources, return up to this many results. (optional)
     * @param count When listing resources, if &#x60;true&#x60;, return only the count of the results. (optional)
     * @param role Retrieves the resources list for a different role if the authenticated role has access (optional)
     * @param actingAs Retrieves the resources list for a different role if the authenticated role has access (optional)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains a list of resources </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call showResourcesForAccountAsync(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId, final ApiCallback<List<Resource>> _callback) throws ApiException {

        okhttp3.Call localVarCall = showResourcesForAccountValidateBeforeCall(account, kind, search, offset, limit, count, role, actingAs, xRequestId, _callback);
        Type localVarReturnType = new TypeToken<List<Resource>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for showResourcesForAllAccounts
     * @param account Organization account name (optional)
     * @param kind Type of resource (optional)
     * @param search Filter resources based on this value by name (optional)
     * @param offset When listing resources, start at this item number. (optional)
     * @param limit When listing resources, return up to this many results. (optional)
     * @param count When listing resources, if &#x60;true&#x60;, return only the count of the results. (optional)
     * @param role Retrieves the resources list for a different role if the authenticated role has access (optional)
     * @param actingAs Retrieves the resources list for a different role if the authenticated role has access (optional)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains a list of resources </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call showResourcesForAllAccountsCall(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/resources";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (account != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("account", account));
        }

        if (kind != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("kind", kind));
        }

        if (search != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("search", search));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (count != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("count", count));
        }

        if (role != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("role", role));
        }

        if (actingAs != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("acting_as", actingAs));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", localVarApiClient.parameterToString(xRequestId));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "conjurAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call showResourcesForAllAccountsValidateBeforeCall(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = showResourcesForAllAccountsCall(account, kind, search, offset, limit, count, role, actingAs, xRequestId, _callback);
        return localVarCall;

    }

    /**
     * Lists resources within an organization account.
     * Lists resources within an organization account.  In the absence of an &#x60;account&#x60; query parameter, shows results for the account of the authorization token user.  If an &#x60;account&#x60; query parameter is given, shows results for the specified account.  If a &#x60;kind&#x60; query parameter is given, narrows results to only resources of that kind.  If a &#x60;limit&#x60; is given, returns no more than that number of results. Providing an &#x60;offset&#x60; skips a number of resources before returning the rest. In addition, providing an &#x60;offset&#x60; will give &#x60;limit&#x60; a default value of 10 if none other is provided. These two parameters can be combined to page through results.  If the parameter &#x60;count&#x60; is &#x60;true&#x60;, returns only the number of items in the list.  ##### Text search  If the &#x60;search&#x60; parameter is provided, narrows results to those pertaining to the search query. Search works across resource IDs and the values of annotations. It weighs results so that those with matching id or a matching value of an annotation called &#x60;name&#x60; appear first, then those with another matching annotation value, and finally those with a matching  &#x60;kind&#x60;.\&quot; 
     * @param account Organization account name (optional)
     * @param kind Type of resource (optional)
     * @param search Filter resources based on this value by name (optional)
     * @param offset When listing resources, start at this item number. (optional)
     * @param limit When listing resources, return up to this many results. (optional)
     * @param count When listing resources, if &#x60;true&#x60;, return only the count of the results. (optional)
     * @param role Retrieves the resources list for a different role if the authenticated role has access (optional)
     * @param actingAs Retrieves the resources list for a different role if the authenticated role has access (optional)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @return List&lt;Resource&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains a list of resources </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public List<Resource> showResourcesForAllAccounts(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId) throws ApiException {
        ApiResponse<List<Resource>> localVarResp = showResourcesForAllAccountsWithHttpInfo(account, kind, search, offset, limit, count, role, actingAs, xRequestId);
        return localVarResp.getData();
    }


    /**
     * Lists resources within an organization account.
     * Lists resources within an organization account.  In the absence of an &#x60;account&#x60; query parameter, shows results for the account of the authorization token user.  If an &#x60;account&#x60; query parameter is given, shows results for the specified account.  If a &#x60;kind&#x60; query parameter is given, narrows results to only resources of that kind.  If a &#x60;limit&#x60; is given, returns no more than that number of results. Providing an &#x60;offset&#x60; skips a number of resources before returning the rest. In addition, providing an &#x60;offset&#x60; will give &#x60;limit&#x60; a default value of 10 if none other is provided. These two parameters can be combined to page through results.  If the parameter &#x60;count&#x60; is &#x60;true&#x60;, returns only the number of items in the list.  ##### Text search  If the &#x60;search&#x60; parameter is provided, narrows results to those pertaining to the search query. Search works across resource IDs and the values of annotations. It weighs results so that those with matching id or a matching value of an annotation called &#x60;name&#x60; appear first, then those with another matching annotation value, and finally those with a matching  &#x60;kind&#x60;.\&quot; 
     * @return List&lt;Resource&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains a list of resources </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
    */
    public List<Resource> showResourcesForAllAccounts() throws ApiException {
        ApiResponse<List<Resource>> localVarResp = showResourcesForAllAccountsWithHttpInfo(null, null, null, null, null, null, null, null, null);
        return localVarResp.getData();
    }

    /**
     * Lists resources within an organization account.
     * Lists resources within an organization account.  In the absence of an &#x60;account&#x60; query parameter, shows results for the account of the authorization token user.  If an &#x60;account&#x60; query parameter is given, shows results for the specified account.  If a &#x60;kind&#x60; query parameter is given, narrows results to only resources of that kind.  If a &#x60;limit&#x60; is given, returns no more than that number of results. Providing an &#x60;offset&#x60; skips a number of resources before returning the rest. In addition, providing an &#x60;offset&#x60; will give &#x60;limit&#x60; a default value of 10 if none other is provided. These two parameters can be combined to page through results.  If the parameter &#x60;count&#x60; is &#x60;true&#x60;, returns only the number of items in the list.  ##### Text search  If the &#x60;search&#x60; parameter is provided, narrows results to those pertaining to the search query. Search works across resource IDs and the values of annotations. It weighs results so that those with matching id or a matching value of an annotation called &#x60;name&#x60; appear first, then those with another matching annotation value, and finally those with a matching  &#x60;kind&#x60;.\&quot; 
     * @param account Organization account name (optional)
     * @param kind Type of resource (optional)
     * @param search Filter resources based on this value by name (optional)
     * @param offset When listing resources, start at this item number. (optional)
     * @param limit When listing resources, return up to this many results. (optional)
     * @param count When listing resources, if &#x60;true&#x60;, return only the count of the results. (optional)
     * @param role Retrieves the resources list for a different role if the authenticated role has access (optional)
     * @param actingAs Retrieves the resources list for a different role if the authenticated role has access (optional)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @return ApiResponse&lt;List&lt;Resource&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains a list of resources </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Resource>> showResourcesForAllAccountsWithHttpInfo(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId) throws ApiException {
        okhttp3.Call localVarCall = showResourcesForAllAccountsValidateBeforeCall(account, kind, search, offset, limit, count, role, actingAs, xRequestId, null);
        Type localVarReturnType = new TypeToken<List<Resource>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Lists resources within an organization account.
     * Lists resources within an organization account.  In the absence of an &#x60;account&#x60; query parameter, shows results for the account of the authorization token user.  If an &#x60;account&#x60; query parameter is given, shows results for the specified account.  If a &#x60;kind&#x60; query parameter is given, narrows results to only resources of that kind.  If a &#x60;limit&#x60; is given, returns no more than that number of results. Providing an &#x60;offset&#x60; skips a number of resources before returning the rest. In addition, providing an &#x60;offset&#x60; will give &#x60;limit&#x60; a default value of 10 if none other is provided. These two parameters can be combined to page through results.  If the parameter &#x60;count&#x60; is &#x60;true&#x60;, returns only the number of items in the list.  ##### Text search  If the &#x60;search&#x60; parameter is provided, narrows results to those pertaining to the search query. Search works across resource IDs and the values of annotations. It weighs results so that those with matching id or a matching value of an annotation called &#x60;name&#x60; appear first, then those with another matching annotation value, and finally those with a matching  &#x60;kind&#x60;.\&quot; 
     * @return ApiResponse&lt;List&lt;Resource&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains a list of resources </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Resource>> showResourcesForAllAccountsWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = showResourcesForAllAccountsValidateBeforeCall(null, null, null, null, null, null, null, null, null, null);
        Type localVarReturnType = new TypeToken<List<Resource>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Lists resources within an organization account. (asynchronously)
     * Lists resources within an organization account.  In the absence of an &#x60;account&#x60; query parameter, shows results for the account of the authorization token user.  If an &#x60;account&#x60; query parameter is given, shows results for the specified account.  If a &#x60;kind&#x60; query parameter is given, narrows results to only resources of that kind.  If a &#x60;limit&#x60; is given, returns no more than that number of results. Providing an &#x60;offset&#x60; skips a number of resources before returning the rest. In addition, providing an &#x60;offset&#x60; will give &#x60;limit&#x60; a default value of 10 if none other is provided. These two parameters can be combined to page through results.  If the parameter &#x60;count&#x60; is &#x60;true&#x60;, returns only the number of items in the list.  ##### Text search  If the &#x60;search&#x60; parameter is provided, narrows results to those pertaining to the search query. Search works across resource IDs and the values of annotations. It weighs results so that those with matching id or a matching value of an annotation called &#x60;name&#x60; appear first, then those with another matching annotation value, and finally those with a matching  &#x60;kind&#x60;.\&quot; 
     * @param account Organization account name (optional)
     * @param kind Type of resource (optional)
     * @param search Filter resources based on this value by name (optional)
     * @param offset When listing resources, start at this item number. (optional)
     * @param limit When listing resources, return up to this many results. (optional)
     * @param count When listing resources, if &#x60;true&#x60;, return only the count of the results. (optional)
     * @param role Retrieves the resources list for a different role if the authenticated role has access (optional)
     * @param actingAs Retrieves the resources list for a different role if the authenticated role has access (optional)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains a list of resources </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call showResourcesForAllAccountsAsync(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId, final ApiCallback<List<Resource>> _callback) throws ApiException {

        okhttp3.Call localVarCall = showResourcesForAllAccountsValidateBeforeCall(account, kind, search, offset, limit, count, role, actingAs, xRequestId, _callback);
        Type localVarReturnType = new TypeToken<List<Resource>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for showResourcesForKind
     * @param account Organization account name (required)
     * @param kind Type of resource (required)
     * @param search Filter resources based on this value by name (optional)
     * @param offset When listing resources, start at this item number. (optional)
     * @param limit When listing resources, return up to this many results. (optional)
     * @param count When listing resources, if &#x60;true&#x60;, return only the count of the results. (optional)
     * @param role Retrieves the resources list for a different role if the authenticated role has access (optional)
     * @param actingAs Retrieves the resources list for a different role if the authenticated role has access (optional)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains a list of resources </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call showResourcesForKindCall(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/resources/{account}/{kind}"
            .replaceAll("\\{" + "account" + "\\}", localVarApiClient.escapeString(account.toString()))
            .replaceAll("\\{" + "kind" + "\\}", localVarApiClient.escapeString(kind.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (search != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("search", search));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (count != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("count", count));
        }

        if (role != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("role", role));
        }

        if (actingAs != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("acting_as", actingAs));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", localVarApiClient.parameterToString(xRequestId));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "conjurAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call showResourcesForKindValidateBeforeCall(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'account' is set
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling showResourcesForKind(Async)");
        }
        
        // verify the required parameter 'kind' is set
        if (kind == null) {
            throw new ApiException("Missing the required parameter 'kind' when calling showResourcesForKind(Async)");
        }
        

        okhttp3.Call localVarCall = showResourcesForKindCall(account, kind, search, offset, limit, count, role, actingAs, xRequestId, _callback);
        return localVarCall;

    }

    /**
     * Lists resources of the same kind within an organization account.
     * Lists resources of the same kind within an organization account.  Kinds of resources include: policy, user, host, group, layer, or variable  If a &#x60;limit&#x60; is given, returns no more than that number of results. Providing an &#x60;offset&#x60; skips a number of resources before returning the rest. In addition, providing an &#x60;offset&#x60; will give &#x60;limit&#x60; a default value of 10 if none other is provided. These two parameters can be combined to page through results.  If the parameter &#x60;count&#x60; is &#x60;true&#x60;, returns only the number of items in the list.  ##### Text search  If the &#x60;search&#x60; parameter is provided, narrows results to those pertaining to the search query. Search works across resource IDs and the values of annotations. It weighs results so that those with matching id or a matching value of an annotation called &#x60;name&#x60; appear first, then those with another matching annotation value, and finally those with a matching  &#x60;kind&#x60;. 
     * @param account Organization account name (required)
     * @param kind Type of resource (required)
     * @param search Filter resources based on this value by name (optional)
     * @param offset When listing resources, start at this item number. (optional)
     * @param limit When listing resources, return up to this many results. (optional)
     * @param count When listing resources, if &#x60;true&#x60;, return only the count of the results. (optional)
     * @param role Retrieves the resources list for a different role if the authenticated role has access (optional)
     * @param actingAs Retrieves the resources list for a different role if the authenticated role has access (optional)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @return List&lt;Resource&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains a list of resources </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public List<Resource> showResourcesForKind(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId) throws ApiException {
        ApiResponse<List<Resource>> localVarResp = showResourcesForKindWithHttpInfo(account, kind, search, offset, limit, count, role, actingAs, xRequestId);
        return localVarResp.getData();
    }


    /**
     * Lists resources of the same kind within an organization account.
     * Lists resources of the same kind within an organization account.  Kinds of resources include: policy, user, host, group, layer, or variable  If a &#x60;limit&#x60; is given, returns no more than that number of results. Providing an &#x60;offset&#x60; skips a number of resources before returning the rest. In addition, providing an &#x60;offset&#x60; will give &#x60;limit&#x60; a default value of 10 if none other is provided. These two parameters can be combined to page through results.  If the parameter &#x60;count&#x60; is &#x60;true&#x60;, returns only the number of items in the list.  ##### Text search  If the &#x60;search&#x60; parameter is provided, narrows results to those pertaining to the search query. Search works across resource IDs and the values of annotations. It weighs results so that those with matching id or a matching value of an annotation called &#x60;name&#x60; appear first, then those with another matching annotation value, and finally those with a matching  &#x60;kind&#x60;. 
     * @param account Organization account name
     * @param kind Type of resource
     * @return List&lt;Resource&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains a list of resources </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
    */
    public List<Resource> showResourcesForKind(String account, String kind) throws ApiException {
        ApiResponse<List<Resource>> localVarResp = showResourcesForKindWithHttpInfo(account, kind, null, null, null, null, null, null, null);
        return localVarResp.getData();
    }

    /**
     * Lists resources of the same kind within an organization account.
     * Lists resources of the same kind within an organization account.  Kinds of resources include: policy, user, host, group, layer, or variable  If a &#x60;limit&#x60; is given, returns no more than that number of results. Providing an &#x60;offset&#x60; skips a number of resources before returning the rest. In addition, providing an &#x60;offset&#x60; will give &#x60;limit&#x60; a default value of 10 if none other is provided. These two parameters can be combined to page through results.  If the parameter &#x60;count&#x60; is &#x60;true&#x60;, returns only the number of items in the list.  ##### Text search  If the &#x60;search&#x60; parameter is provided, narrows results to those pertaining to the search query. Search works across resource IDs and the values of annotations. It weighs results so that those with matching id or a matching value of an annotation called &#x60;name&#x60; appear first, then those with another matching annotation value, and finally those with a matching  &#x60;kind&#x60;. 
     * @param account Organization account name (required)
     * @param kind Type of resource (required)
     * @param search Filter resources based on this value by name (optional)
     * @param offset When listing resources, start at this item number. (optional)
     * @param limit When listing resources, return up to this many results. (optional)
     * @param count When listing resources, if &#x60;true&#x60;, return only the count of the results. (optional)
     * @param role Retrieves the resources list for a different role if the authenticated role has access (optional)
     * @param actingAs Retrieves the resources list for a different role if the authenticated role has access (optional)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @return ApiResponse&lt;List&lt;Resource&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains a list of resources </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Resource>> showResourcesForKindWithHttpInfo(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId) throws ApiException {
        okhttp3.Call localVarCall = showResourcesForKindValidateBeforeCall(account, kind, search, offset, limit, count, role, actingAs, xRequestId, null);
        Type localVarReturnType = new TypeToken<List<Resource>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Lists resources of the same kind within an organization account.
     * Lists resources of the same kind within an organization account.  Kinds of resources include: policy, user, host, group, layer, or variable  If a &#x60;limit&#x60; is given, returns no more than that number of results. Providing an &#x60;offset&#x60; skips a number of resources before returning the rest. In addition, providing an &#x60;offset&#x60; will give &#x60;limit&#x60; a default value of 10 if none other is provided. These two parameters can be combined to page through results.  If the parameter &#x60;count&#x60; is &#x60;true&#x60;, returns only the number of items in the list.  ##### Text search  If the &#x60;search&#x60; parameter is provided, narrows results to those pertaining to the search query. Search works across resource IDs and the values of annotations. It weighs results so that those with matching id or a matching value of an annotation called &#x60;name&#x60; appear first, then those with another matching annotation value, and finally those with a matching  &#x60;kind&#x60;. 
     * @param account Organization account name 
     * @param kind Type of resource 
     * @return ApiResponse&lt;List&lt;Resource&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains a list of resources </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Resource>> showResourcesForKindWithHttpInfo(String account, String kind) throws ApiException {
        okhttp3.Call localVarCall = showResourcesForKindValidateBeforeCall(account, kind, null, null, null, null, null, null, null, null);
        Type localVarReturnType = new TypeToken<List<Resource>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Lists resources of the same kind within an organization account. (asynchronously)
     * Lists resources of the same kind within an organization account.  Kinds of resources include: policy, user, host, group, layer, or variable  If a &#x60;limit&#x60; is given, returns no more than that number of results. Providing an &#x60;offset&#x60; skips a number of resources before returning the rest. In addition, providing an &#x60;offset&#x60; will give &#x60;limit&#x60; a default value of 10 if none other is provided. These two parameters can be combined to page through results.  If the parameter &#x60;count&#x60; is &#x60;true&#x60;, returns only the number of items in the list.  ##### Text search  If the &#x60;search&#x60; parameter is provided, narrows results to those pertaining to the search query. Search works across resource IDs and the values of annotations. It weighs results so that those with matching id or a matching value of an annotation called &#x60;name&#x60; appear first, then those with another matching annotation value, and finally those with a matching  &#x60;kind&#x60;. 
     * @param account Organization account name (required)
     * @param kind Type of resource (required)
     * @param search Filter resources based on this value by name (optional)
     * @param offset When listing resources, start at this item number. (optional)
     * @param limit When listing resources, return up to this many results. (optional)
     * @param count When listing resources, if &#x60;true&#x60;, return only the count of the results. (optional)
     * @param role Retrieves the resources list for a different role if the authenticated role has access (optional)
     * @param actingAs Retrieves the resources list for a different role if the authenticated role has access (optional)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains a list of resources </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call showResourcesForKindAsync(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId, final ApiCallback<List<Resource>> _callback) throws ApiException {

        okhttp3.Call localVarCall = showResourcesForKindValidateBeforeCall(account, kind, search, offset, limit, count, role, actingAs, xRequestId, _callback);
        Type localVarReturnType = new TypeToken<List<Resource>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
