/*
 * Conjur
 * This is an API definition for CyberArk Conjur Open Source. You can find out more at [Conjur.org](https://www.conjur.org/).
 *
 * The version of the OpenAPI document: 5.3.1
 * Contact: conj_maintainers@cyberark.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cyberark.conjur.sdk.endpoint;

import com.cyberark.conjur.sdk.ApiCallback;
import com.cyberark.conjur.sdk.ApiClient;
import com.cyberark.conjur.sdk.ApiException;
import com.cyberark.conjur.sdk.ApiResponse;
import com.cyberark.conjur.sdk.Configuration;
import com.cyberark.conjur.sdk.Pair;
import com.cyberark.conjur.sdk.ProgressRequestBody;
import com.cyberark.conjur.sdk.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;



import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RolesApi {
    private ApiClient localVarApiClient;

    public RolesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RolesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for addMemberToRole
     * @param account Organization account name (required)
     * @param kind Type of resource (required)
     * @param identifier ID of the role for which to get the information about (required)
     * @param members Returns a list of the Role&#39;s members. (required)
     * @param member The identifier of the Role to be added as a member. (required)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Member was added to role successfully </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist, the authenticated user lacks the required privileges to enumerate this resource, or its value has not been set </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call addMemberToRoleCall(String account, String kind, String identifier, String members, String member, String xRequestId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/roles/{account}/{kind}/{identifier}"
            .replaceAll("\\{" + "account" + "\\}", localVarApiClient.escapeString(account.toString()))
            .replaceAll("\\{" + "kind" + "\\}", localVarApiClient.escapeString(kind.toString()))
            .replaceAll("\\{" + "identifier" + "\\}", localVarApiClient.escapeString(identifier.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (members != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("members", members));
        }

        if (member != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("member", member));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", localVarApiClient.parameterToString(xRequestId));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "conjurAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call addMemberToRoleValidateBeforeCall(String account, String kind, String identifier, String members, String member, String xRequestId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'account' is set
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling addMemberToRole(Async)");
        }
        
        // verify the required parameter 'kind' is set
        if (kind == null) {
            throw new ApiException("Missing the required parameter 'kind' when calling addMemberToRole(Async)");
        }
        
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new ApiException("Missing the required parameter 'identifier' when calling addMemberToRole(Async)");
        }
        
        // verify the required parameter 'members' is set
        if (members == null) {
            throw new ApiException("Missing the required parameter 'members' when calling addMemberToRole(Async)");
        }
        
        // verify the required parameter 'member' is set
        if (member == null) {
            throw new ApiException("Missing the required parameter 'member' when calling addMemberToRole(Async)");
        }
        

        okhttp3.Call localVarCall = addMemberToRoleCall(account, kind, identifier, members, member, xRequestId, _callback);
        return localVarCall;

    }

    /**
     * Update or modify an existing role membership
     * Updates or modifies an existing role membership.  If a role A is granted to a role B, then role A is said to have role B as a member. These relationships are described in the “members” portion of the returned JSON.  When the &#x60;members&#x60; query parameter is provided, you will get the members of a role.  When the &#x60;members&#x60; and &#x60;member&#x60; query parameters are provided, the role specfified by &#x60;member&#x60; will be added as a member of the role specified in the endpoint URI. 
     * @param account Organization account name (required)
     * @param kind Type of resource (required)
     * @param identifier ID of the role for which to get the information about (required)
     * @param members Returns a list of the Role&#39;s members. (required)
     * @param member The identifier of the Role to be added as a member. (required)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Member was added to role successfully </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist, the authenticated user lacks the required privileges to enumerate this resource, or its value has not been set </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public void addMemberToRole(String account, String kind, String identifier, String members, String member, String xRequestId) throws ApiException {
        addMemberToRoleWithHttpInfo(account, kind, identifier, members, member, xRequestId);
    }


    /**
     * Update or modify an existing role membership
     * Updates or modifies an existing role membership.  If a role A is granted to a role B, then role A is said to have role B as a member. These relationships are described in the “members” portion of the returned JSON.  When the &#x60;members&#x60; query parameter is provided, you will get the members of a role.  When the &#x60;members&#x60; and &#x60;member&#x60; query parameters are provided, the role specfified by &#x60;member&#x60; will be added as a member of the role specified in the endpoint URI. 
     * @param account Organization account name
     * @param kind Type of resource
     * @param identifier ID of the role for which to get the information about
     * @param members Returns a list of the Role&#39;s members.
     * @param member The identifier of the Role to be added as a member.
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Member was added to role successfully </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist, the authenticated user lacks the required privileges to enumerate this resource, or its value has not been set </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
    */
    public void addMemberToRole(String account, String kind, String identifier, String members, String member) throws ApiException {
        addMemberToRoleWithHttpInfo(account, kind, identifier, members, member, null);
    }

    /**
     * Update or modify an existing role membership
     * Updates or modifies an existing role membership.  If a role A is granted to a role B, then role A is said to have role B as a member. These relationships are described in the “members” portion of the returned JSON.  When the &#x60;members&#x60; query parameter is provided, you will get the members of a role.  When the &#x60;members&#x60; and &#x60;member&#x60; query parameters are provided, the role specfified by &#x60;member&#x60; will be added as a member of the role specified in the endpoint URI. 
     * @param account Organization account name (required)
     * @param kind Type of resource (required)
     * @param identifier ID of the role for which to get the information about (required)
     * @param members Returns a list of the Role&#39;s members. (required)
     * @param member The identifier of the Role to be added as a member. (required)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Member was added to role successfully </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist, the authenticated user lacks the required privileges to enumerate this resource, or its value has not been set </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> addMemberToRoleWithHttpInfo(String account, String kind, String identifier, String members, String member, String xRequestId) throws ApiException {
        okhttp3.Call localVarCall = addMemberToRoleValidateBeforeCall(account, kind, identifier, members, member, xRequestId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Update or modify an existing role membership
     * Updates or modifies an existing role membership.  If a role A is granted to a role B, then role A is said to have role B as a member. These relationships are described in the “members” portion of the returned JSON.  When the &#x60;members&#x60; query parameter is provided, you will get the members of a role.  When the &#x60;members&#x60; and &#x60;member&#x60; query parameters are provided, the role specfified by &#x60;member&#x60; will be added as a member of the role specified in the endpoint URI. 
     * @param account Organization account name 
     * @param kind Type of resource 
     * @param identifier ID of the role for which to get the information about 
     * @param members Returns a list of the Role&#39;s members. 
     * @param member The identifier of the Role to be added as a member. 
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Member was added to role successfully </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist, the authenticated user lacks the required privileges to enumerate this resource, or its value has not been set </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> addMemberToRoleWithHttpInfo(String account, String kind, String identifier, String members, String member) throws ApiException {
        okhttp3.Call localVarCall = addMemberToRoleValidateBeforeCall(account, kind, identifier, members, member, null, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Update or modify an existing role membership (asynchronously)
     * Updates or modifies an existing role membership.  If a role A is granted to a role B, then role A is said to have role B as a member. These relationships are described in the “members” portion of the returned JSON.  When the &#x60;members&#x60; query parameter is provided, you will get the members of a role.  When the &#x60;members&#x60; and &#x60;member&#x60; query parameters are provided, the role specfified by &#x60;member&#x60; will be added as a member of the role specified in the endpoint URI. 
     * @param account Organization account name (required)
     * @param kind Type of resource (required)
     * @param identifier ID of the role for which to get the information about (required)
     * @param members Returns a list of the Role&#39;s members. (required)
     * @param member The identifier of the Role to be added as a member. (required)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Member was added to role successfully </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist, the authenticated user lacks the required privileges to enumerate this resource, or its value has not been set </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call addMemberToRoleAsync(String account, String kind, String identifier, String members, String member, String xRequestId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = addMemberToRoleValidateBeforeCall(account, kind, identifier, members, member, xRequestId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for removeMemberFromRole
     * @param account Organization account name (required)
     * @param kind Type of resource (required)
     * @param identifier ID of the role for which to get the information about (required)
     * @param members Returns a list of the Role&#39;s members. (required)
     * @param member The identifier of the Role to be added as a member. (required)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Member was deleted from role successfully </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist, the authenticated user lacks the required privileges to enumerate this resource, or its value has not been set </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call removeMemberFromRoleCall(String account, String kind, String identifier, String members, String member, String xRequestId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/roles/{account}/{kind}/{identifier}"
            .replaceAll("\\{" + "account" + "\\}", localVarApiClient.escapeString(account.toString()))
            .replaceAll("\\{" + "kind" + "\\}", localVarApiClient.escapeString(kind.toString()))
            .replaceAll("\\{" + "identifier" + "\\}", localVarApiClient.escapeString(identifier.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (members != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("members", members));
        }

        if (member != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("member", member));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", localVarApiClient.parameterToString(xRequestId));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "conjurAuth" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call removeMemberFromRoleValidateBeforeCall(String account, String kind, String identifier, String members, String member, String xRequestId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'account' is set
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling removeMemberFromRole(Async)");
        }
        
        // verify the required parameter 'kind' is set
        if (kind == null) {
            throw new ApiException("Missing the required parameter 'kind' when calling removeMemberFromRole(Async)");
        }
        
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new ApiException("Missing the required parameter 'identifier' when calling removeMemberFromRole(Async)");
        }
        
        // verify the required parameter 'members' is set
        if (members == null) {
            throw new ApiException("Missing the required parameter 'members' when calling removeMemberFromRole(Async)");
        }
        
        // verify the required parameter 'member' is set
        if (member == null) {
            throw new ApiException("Missing the required parameter 'member' when calling removeMemberFromRole(Async)");
        }
        

        okhttp3.Call localVarCall = removeMemberFromRoleCall(account, kind, identifier, members, member, xRequestId, _callback);
        return localVarCall;

    }

    /**
     * Deletes an existing role membership
     * Deletes an existing role membership.  If a role A is granted to a role B, then role A is said to have role B as a member. These relationships are described in the “members” portion of the returned JSON.  When the &#x60;members&#x60; query parameter is provided, you will get the members of a role.  When the &#x60;members&#x60; and &#x60;member&#x60; query parameters are provided, the role specfified by &#x60;member&#x60; will be removed as a member of the role specified in the endpoint URI. 
     * @param account Organization account name (required)
     * @param kind Type of resource (required)
     * @param identifier ID of the role for which to get the information about (required)
     * @param members Returns a list of the Role&#39;s members. (required)
     * @param member The identifier of the Role to be added as a member. (required)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Member was deleted from role successfully </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist, the authenticated user lacks the required privileges to enumerate this resource, or its value has not been set </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public void removeMemberFromRole(String account, String kind, String identifier, String members, String member, String xRequestId) throws ApiException {
        removeMemberFromRoleWithHttpInfo(account, kind, identifier, members, member, xRequestId);
    }


    /**
     * Deletes an existing role membership
     * Deletes an existing role membership.  If a role A is granted to a role B, then role A is said to have role B as a member. These relationships are described in the “members” portion of the returned JSON.  When the &#x60;members&#x60; query parameter is provided, you will get the members of a role.  When the &#x60;members&#x60; and &#x60;member&#x60; query parameters are provided, the role specfified by &#x60;member&#x60; will be removed as a member of the role specified in the endpoint URI. 
     * @param account Organization account name
     * @param kind Type of resource
     * @param identifier ID of the role for which to get the information about
     * @param members Returns a list of the Role&#39;s members.
     * @param member The identifier of the Role to be added as a member.
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Member was deleted from role successfully </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist, the authenticated user lacks the required privileges to enumerate this resource, or its value has not been set </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
    */
    public void removeMemberFromRole(String account, String kind, String identifier, String members, String member) throws ApiException {
        removeMemberFromRoleWithHttpInfo(account, kind, identifier, members, member, null);
    }

    /**
     * Deletes an existing role membership
     * Deletes an existing role membership.  If a role A is granted to a role B, then role A is said to have role B as a member. These relationships are described in the “members” portion of the returned JSON.  When the &#x60;members&#x60; query parameter is provided, you will get the members of a role.  When the &#x60;members&#x60; and &#x60;member&#x60; query parameters are provided, the role specfified by &#x60;member&#x60; will be removed as a member of the role specified in the endpoint URI. 
     * @param account Organization account name (required)
     * @param kind Type of resource (required)
     * @param identifier ID of the role for which to get the information about (required)
     * @param members Returns a list of the Role&#39;s members. (required)
     * @param member The identifier of the Role to be added as a member. (required)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Member was deleted from role successfully </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist, the authenticated user lacks the required privileges to enumerate this resource, or its value has not been set </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> removeMemberFromRoleWithHttpInfo(String account, String kind, String identifier, String members, String member, String xRequestId) throws ApiException {
        okhttp3.Call localVarCall = removeMemberFromRoleValidateBeforeCall(account, kind, identifier, members, member, xRequestId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Deletes an existing role membership
     * Deletes an existing role membership.  If a role A is granted to a role B, then role A is said to have role B as a member. These relationships are described in the “members” portion of the returned JSON.  When the &#x60;members&#x60; query parameter is provided, you will get the members of a role.  When the &#x60;members&#x60; and &#x60;member&#x60; query parameters are provided, the role specfified by &#x60;member&#x60; will be removed as a member of the role specified in the endpoint URI. 
     * @param account Organization account name 
     * @param kind Type of resource 
     * @param identifier ID of the role for which to get the information about 
     * @param members Returns a list of the Role&#39;s members. 
     * @param member The identifier of the Role to be added as a member. 
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Member was deleted from role successfully </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist, the authenticated user lacks the required privileges to enumerate this resource, or its value has not been set </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> removeMemberFromRoleWithHttpInfo(String account, String kind, String identifier, String members, String member) throws ApiException {
        okhttp3.Call localVarCall = removeMemberFromRoleValidateBeforeCall(account, kind, identifier, members, member, null, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Deletes an existing role membership (asynchronously)
     * Deletes an existing role membership.  If a role A is granted to a role B, then role A is said to have role B as a member. These relationships are described in the “members” portion of the returned JSON.  When the &#x60;members&#x60; query parameter is provided, you will get the members of a role.  When the &#x60;members&#x60; and &#x60;member&#x60; query parameters are provided, the role specfified by &#x60;member&#x60; will be removed as a member of the role specified in the endpoint URI. 
     * @param account Organization account name (required)
     * @param kind Type of resource (required)
     * @param identifier ID of the role for which to get the information about (required)
     * @param members Returns a list of the Role&#39;s members. (required)
     * @param member The identifier of the Role to be added as a member. (required)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Member was deleted from role successfully </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist, the authenticated user lacks the required privileges to enumerate this resource, or its value has not been set </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call removeMemberFromRoleAsync(String account, String kind, String identifier, String members, String member, String xRequestId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = removeMemberFromRoleValidateBeforeCall(account, kind, identifier, members, member, xRequestId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for showRole
     * @param account Organization account name (required)
     * @param kind Type of resource (required)
     * @param identifier ID of the role for which to get the information about (required)
     * @param all Returns an array of Role IDs representing all role memberships, expanded recursively. (optional)
     * @param memberships Returns all direct role memberships (members not expanded recursively). (optional)
     * @param members Returns a list of the Role&#39;s members. (optional)
     * @param offset When listing members, start at this item number. (optional)
     * @param limit When listing members, return up to this many results. (optional)
     * @param count When listing members, if &#x60;true&#x60;, return only the count of members. (optional)
     * @param search When listing members, the results will be narrowed to only those matching the provided string (optional)
     * @param graph If included in the query returns a graph view of the role (optional)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains the requested role(s)/member(s) </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist, the authenticated user lacks the required privileges to enumerate this resource, or its value has not been set </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call showRoleCall(String account, String kind, String identifier, String all, String memberships, String members, Integer offset, Integer limit, Boolean count, String search, String graph, String xRequestId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/roles/{account}/{kind}/{identifier}"
            .replaceAll("\\{" + "account" + "\\}", localVarApiClient.escapeString(account.toString()))
            .replaceAll("\\{" + "kind" + "\\}", localVarApiClient.escapeString(kind.toString()))
            .replaceAll("\\{" + "identifier" + "\\}", localVarApiClient.escapeString(identifier.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (all != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("all", all));
        }

        if (memberships != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("memberships", memberships));
        }

        if (members != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("members", members));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (count != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("count", count));
        }

        if (search != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("search", search));
        }

        if (graph != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("graph", graph));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", localVarApiClient.parameterToString(xRequestId));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "conjurAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call showRoleValidateBeforeCall(String account, String kind, String identifier, String all, String memberships, String members, Integer offset, Integer limit, Boolean count, String search, String graph, String xRequestId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'account' is set
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling showRole(Async)");
        }
        
        // verify the required parameter 'kind' is set
        if (kind == null) {
            throw new ApiException("Missing the required parameter 'kind' when calling showRole(Async)");
        }
        
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new ApiException("Missing the required parameter 'identifier' when calling showRole(Async)");
        }
        

        okhttp3.Call localVarCall = showRoleCall(account, kind, identifier, all, memberships, members, offset, limit, count, search, graph, xRequestId, _callback);
        return localVarCall;

    }

    /**
     * Get role information
     * Gets detailed information about a specific role, including the role members.  If a role A is granted to a role B, then role A is said to have role B as a member. These relationships are described in the “members” portion of the returned JSON.  ##### Listing members  If &#x60;members&#x60; is provided, you will get the members of a role.  If a &#x60;kind&#x60; query parameter is given, narrows results to only resources of that kind.  If a &#x60;limit&#x60; is given, returns no more than that number of results. Providing an &#x60;offset&#x60; skips a number of resources before returning the rest. In addition, providing an &#x60;offset&#x60; will give limit a default value of 10 if none other is provided. These two parameters can be combined to page through results.  If the parameter &#x60;count&#x60; is true, returns only the number of items in the list.  ##### Text search  If the search parameter is provided, narrows results to those pertaining to the search query. Search works across resource IDs and the values of annotations. It weights results so that those with matching id or a matching value of an annotation called name appear first, then those with another matching annotation value, and finally those with a matching kind.  ##### Parameter Priority  If Conjur is given any combination of optional parameters, it responds with ONLY results for the parameter of the highest priority.  1. &#x60;graph&#x60; 2. &#x60;all&#x60; 3. &#x60;memberships&#x60; 4. &#x60;members&#x60; 
     * @param account Organization account name (required)
     * @param kind Type of resource (required)
     * @param identifier ID of the role for which to get the information about (required)
     * @param all Returns an array of Role IDs representing all role memberships, expanded recursively. (optional)
     * @param memberships Returns all direct role memberships (members not expanded recursively). (optional)
     * @param members Returns a list of the Role&#39;s members. (optional)
     * @param offset When listing members, start at this item number. (optional)
     * @param limit When listing members, return up to this many results. (optional)
     * @param count When listing members, if &#x60;true&#x60;, return only the count of members. (optional)
     * @param search When listing members, the results will be narrowed to only those matching the provided string (optional)
     * @param graph If included in the query returns a graph view of the role (optional)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains the requested role(s)/member(s) </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist, the authenticated user lacks the required privileges to enumerate this resource, or its value has not been set </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public Object showRole(String account, String kind, String identifier, String all, String memberships, String members, Integer offset, Integer limit, Boolean count, String search, String graph, String xRequestId) throws ApiException {
        ApiResponse<Object> localVarResp = showRoleWithHttpInfo(account, kind, identifier, all, memberships, members, offset, limit, count, search, graph, xRequestId);
        return localVarResp.getData();
    }


    /**
     * Get role information
     * Gets detailed information about a specific role, including the role members.  If a role A is granted to a role B, then role A is said to have role B as a member. These relationships are described in the “members” portion of the returned JSON.  ##### Listing members  If &#x60;members&#x60; is provided, you will get the members of a role.  If a &#x60;kind&#x60; query parameter is given, narrows results to only resources of that kind.  If a &#x60;limit&#x60; is given, returns no more than that number of results. Providing an &#x60;offset&#x60; skips a number of resources before returning the rest. In addition, providing an &#x60;offset&#x60; will give limit a default value of 10 if none other is provided. These two parameters can be combined to page through results.  If the parameter &#x60;count&#x60; is true, returns only the number of items in the list.  ##### Text search  If the search parameter is provided, narrows results to those pertaining to the search query. Search works across resource IDs and the values of annotations. It weights results so that those with matching id or a matching value of an annotation called name appear first, then those with another matching annotation value, and finally those with a matching kind.  ##### Parameter Priority  If Conjur is given any combination of optional parameters, it responds with ONLY results for the parameter of the highest priority.  1. &#x60;graph&#x60; 2. &#x60;all&#x60; 3. &#x60;memberships&#x60; 4. &#x60;members&#x60; 
     * @param account Organization account name
     * @param kind Type of resource
     * @param identifier ID of the role for which to get the information about
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains the requested role(s)/member(s) </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist, the authenticated user lacks the required privileges to enumerate this resource, or its value has not been set </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
    */
    public Object showRole(String account, String kind, String identifier) throws ApiException {
        ApiResponse<Object> localVarResp = showRoleWithHttpInfo(account, kind, identifier, null, null, null, null, null, null, null, null, null);
        return localVarResp.getData();
    }

    /**
     * Get role information
     * Gets detailed information about a specific role, including the role members.  If a role A is granted to a role B, then role A is said to have role B as a member. These relationships are described in the “members” portion of the returned JSON.  ##### Listing members  If &#x60;members&#x60; is provided, you will get the members of a role.  If a &#x60;kind&#x60; query parameter is given, narrows results to only resources of that kind.  If a &#x60;limit&#x60; is given, returns no more than that number of results. Providing an &#x60;offset&#x60; skips a number of resources before returning the rest. In addition, providing an &#x60;offset&#x60; will give limit a default value of 10 if none other is provided. These two parameters can be combined to page through results.  If the parameter &#x60;count&#x60; is true, returns only the number of items in the list.  ##### Text search  If the search parameter is provided, narrows results to those pertaining to the search query. Search works across resource IDs and the values of annotations. It weights results so that those with matching id or a matching value of an annotation called name appear first, then those with another matching annotation value, and finally those with a matching kind.  ##### Parameter Priority  If Conjur is given any combination of optional parameters, it responds with ONLY results for the parameter of the highest priority.  1. &#x60;graph&#x60; 2. &#x60;all&#x60; 3. &#x60;memberships&#x60; 4. &#x60;members&#x60; 
     * @param account Organization account name (required)
     * @param kind Type of resource (required)
     * @param identifier ID of the role for which to get the information about (required)
     * @param all Returns an array of Role IDs representing all role memberships, expanded recursively. (optional)
     * @param memberships Returns all direct role memberships (members not expanded recursively). (optional)
     * @param members Returns a list of the Role&#39;s members. (optional)
     * @param offset When listing members, start at this item number. (optional)
     * @param limit When listing members, return up to this many results. (optional)
     * @param count When listing members, if &#x60;true&#x60;, return only the count of members. (optional)
     * @param search When listing members, the results will be narrowed to only those matching the provided string (optional)
     * @param graph If included in the query returns a graph view of the role (optional)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains the requested role(s)/member(s) </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist, the authenticated user lacks the required privileges to enumerate this resource, or its value has not been set </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> showRoleWithHttpInfo(String account, String kind, String identifier, String all, String memberships, String members, Integer offset, Integer limit, Boolean count, String search, String graph, String xRequestId) throws ApiException {
        okhttp3.Call localVarCall = showRoleValidateBeforeCall(account, kind, identifier, all, memberships, members, offset, limit, count, search, graph, xRequestId, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get role information
     * Gets detailed information about a specific role, including the role members.  If a role A is granted to a role B, then role A is said to have role B as a member. These relationships are described in the “members” portion of the returned JSON.  ##### Listing members  If &#x60;members&#x60; is provided, you will get the members of a role.  If a &#x60;kind&#x60; query parameter is given, narrows results to only resources of that kind.  If a &#x60;limit&#x60; is given, returns no more than that number of results. Providing an &#x60;offset&#x60; skips a number of resources before returning the rest. In addition, providing an &#x60;offset&#x60; will give limit a default value of 10 if none other is provided. These two parameters can be combined to page through results.  If the parameter &#x60;count&#x60; is true, returns only the number of items in the list.  ##### Text search  If the search parameter is provided, narrows results to those pertaining to the search query. Search works across resource IDs and the values of annotations. It weights results so that those with matching id or a matching value of an annotation called name appear first, then those with another matching annotation value, and finally those with a matching kind.  ##### Parameter Priority  If Conjur is given any combination of optional parameters, it responds with ONLY results for the parameter of the highest priority.  1. &#x60;graph&#x60; 2. &#x60;all&#x60; 3. &#x60;memberships&#x60; 4. &#x60;members&#x60; 
     * @param account Organization account name 
     * @param kind Type of resource 
     * @param identifier ID of the role for which to get the information about 
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains the requested role(s)/member(s) </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist, the authenticated user lacks the required privileges to enumerate this resource, or its value has not been set </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> showRoleWithHttpInfo(String account, String kind, String identifier) throws ApiException {
        okhttp3.Call localVarCall = showRoleValidateBeforeCall(account, kind, identifier, null, null, null, null, null, null, null, null, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get role information (asynchronously)
     * Gets detailed information about a specific role, including the role members.  If a role A is granted to a role B, then role A is said to have role B as a member. These relationships are described in the “members” portion of the returned JSON.  ##### Listing members  If &#x60;members&#x60; is provided, you will get the members of a role.  If a &#x60;kind&#x60; query parameter is given, narrows results to only resources of that kind.  If a &#x60;limit&#x60; is given, returns no more than that number of results. Providing an &#x60;offset&#x60; skips a number of resources before returning the rest. In addition, providing an &#x60;offset&#x60; will give limit a default value of 10 if none other is provided. These two parameters can be combined to page through results.  If the parameter &#x60;count&#x60; is true, returns only the number of items in the list.  ##### Text search  If the search parameter is provided, narrows results to those pertaining to the search query. Search works across resource IDs and the values of annotations. It weights results so that those with matching id or a matching value of an annotation called name appear first, then those with another matching annotation value, and finally those with a matching kind.  ##### Parameter Priority  If Conjur is given any combination of optional parameters, it responds with ONLY results for the parameter of the highest priority.  1. &#x60;graph&#x60; 2. &#x60;all&#x60; 3. &#x60;memberships&#x60; 4. &#x60;members&#x60; 
     * @param account Organization account name (required)
     * @param kind Type of resource (required)
     * @param identifier ID of the role for which to get the information about (required)
     * @param all Returns an array of Role IDs representing all role memberships, expanded recursively. (optional)
     * @param memberships Returns all direct role memberships (members not expanded recursively). (optional)
     * @param members Returns a list of the Role&#39;s members. (optional)
     * @param offset When listing members, start at this item number. (optional)
     * @param limit When listing members, return up to this many results. (optional)
     * @param count When listing members, if &#x60;true&#x60;, return only the count of members. (optional)
     * @param search When listing members, the results will be narrowed to only those matching the provided string (optional)
     * @param graph If included in the query returns a graph view of the role (optional)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response body contains the requested role(s)/member(s) </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist, the authenticated user lacks the required privileges to enumerate this resource, or its value has not been set </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> A request parameter was either missing or invalid. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call showRoleAsync(String account, String kind, String identifier, String all, String memberships, String members, Integer offset, Integer limit, Boolean count, String search, String graph, String xRequestId, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = showRoleValidateBeforeCall(account, kind, identifier, all, memberships, members, offset, limit, count, search, graph, xRequestId, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
