/*
 * Conjur
 * This is an API definition for CyberArk Conjur Open Source. You can find out more at [Conjur.org](https://www.conjur.org/).
 *
 * The version of the OpenAPI document: 5.3.1
 * Contact: conj_maintainers@cyberark.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cyberark.conjur.sdk.endpoint;

import com.cyberark.conjur.sdk.ApiCallback;
import com.cyberark.conjur.sdk.ApiClient;
import com.cyberark.conjur.sdk.ApiException;
import com.cyberark.conjur.sdk.ApiResponse;
import com.cyberark.conjur.sdk.Configuration;
import com.cyberark.conjur.sdk.Pair;
import com.cyberark.conjur.sdk.ProgressRequestBody;
import com.cyberark.conjur.sdk.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.cyberark.conjur.sdk.model.AuthenticatorStatus;
import com.cyberark.conjur.sdk.model.AuthenticatorsResponse;
import com.cyberark.conjur.sdk.model.WhoAmI;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StatusApi {
    private ApiClient localVarApiClient;

    public StatusApi() {
        this(Configuration.getDefaultApiClient());
    }

    public StatusApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getAuthenticators
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Details about authenticators for this Conjur server </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAuthenticatorsCall(String xRequestId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/authenticators";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", localVarApiClient.parameterToString(xRequestId));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth", "conjurAuth", "conjurKubernetesMutualTls" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAuthenticatorsValidateBeforeCall(String xRequestId, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getAuthenticatorsCall(xRequestId, _callback);
        return localVarCall;

    }

    /**
     * Details about which authenticators are on the Conjur Server
     * Response contains three members: installed, configured, and enabled.  installed: The authenticator is implemented in Conjur and is available for configuration configured: The authenticator has a webservice in the DB that was loaded by policy enabled: The authenticator is enabled (in the DB or in the ENV) and is ready for authentication 
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @return AuthenticatorsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Details about authenticators for this Conjur server </td><td>  -  </td></tr>
     </table>
     */
    public AuthenticatorsResponse getAuthenticators(String xRequestId) throws ApiException {
        ApiResponse<AuthenticatorsResponse> localVarResp = getAuthenticatorsWithHttpInfo(xRequestId);
        return localVarResp.getData();
    }


    /**
     * Details about which authenticators are on the Conjur Server
     * Response contains three members: installed, configured, and enabled.  installed: The authenticator is implemented in Conjur and is available for configuration configured: The authenticator has a webservice in the DB that was loaded by policy enabled: The authenticator is enabled (in the DB or in the ENV) and is ready for authentication 
     * @return AuthenticatorsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Details about authenticators for this Conjur server </td><td>  -  </td></tr>
     </table>
    */
    public AuthenticatorsResponse getAuthenticators() throws ApiException {
        ApiResponse<AuthenticatorsResponse> localVarResp = getAuthenticatorsWithHttpInfo(null);
        return localVarResp.getData();
    }

    /**
     * Details about which authenticators are on the Conjur Server
     * Response contains three members: installed, configured, and enabled.  installed: The authenticator is implemented in Conjur and is available for configuration configured: The authenticator has a webservice in the DB that was loaded by policy enabled: The authenticator is enabled (in the DB or in the ENV) and is ready for authentication 
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @return ApiResponse&lt;AuthenticatorsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Details about authenticators for this Conjur server </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AuthenticatorsResponse> getAuthenticatorsWithHttpInfo(String xRequestId) throws ApiException {
        okhttp3.Call localVarCall = getAuthenticatorsValidateBeforeCall(xRequestId, null);
        Type localVarReturnType = new TypeToken<AuthenticatorsResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Details about which authenticators are on the Conjur Server
     * Response contains three members: installed, configured, and enabled.  installed: The authenticator is implemented in Conjur and is available for configuration configured: The authenticator has a webservice in the DB that was loaded by policy enabled: The authenticator is enabled (in the DB or in the ENV) and is ready for authentication 
     * @return ApiResponse&lt;AuthenticatorsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Details about authenticators for this Conjur server </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AuthenticatorsResponse> getAuthenticatorsWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getAuthenticatorsValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<AuthenticatorsResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Details about which authenticators are on the Conjur Server (asynchronously)
     * Response contains three members: installed, configured, and enabled.  installed: The authenticator is implemented in Conjur and is available for configuration configured: The authenticator has a webservice in the DB that was loaded by policy enabled: The authenticator is enabled (in the DB or in the ENV) and is ready for authentication 
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Details about authenticators for this Conjur server </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAuthenticatorsAsync(String xRequestId, final ApiCallback<AuthenticatorsResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAuthenticatorsValidateBeforeCall(xRequestId, _callback);
        Type localVarReturnType = new TypeToken<AuthenticatorsResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getGCPAuthenticatorStatus
     * @param account The organization account name (required)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response contains info about the result </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The service was not found </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The response contains info about the result </td><td>  -  </td></tr>
        <tr><td> 501 </td><td> The response contains info about the result </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getGCPAuthenticatorStatusCall(String account, String xRequestId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/authn-gcp/{account}/status"
            .replaceAll("\\{" + "account" + "\\}", localVarApiClient.escapeString(account.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", localVarApiClient.parameterToString(xRequestId));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "conjurAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getGCPAuthenticatorStatusValidateBeforeCall(String account, String xRequestId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'account' is set
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling getGCPAuthenticatorStatus(Async)");
        }
        

        okhttp3.Call localVarCall = getGCPAuthenticatorStatusCall(account, xRequestId, _callback);
        return localVarCall;

    }

    /**
     * Details whether an authentication service has been configured properly
     * Once the status webservice has been properly configured and the relevant user groups have been given permissions to access the status webservice, the users in those groups can check the status of the authenticator.  This operation only supports the GCP authenticator  See [Conjur Documentation](https://docs.conjur.org/Latest/en/Content/Integrations/Authn-status.htm) for details on setting up the authenticator status webservice. 
     * @param account The organization account name (required)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @return AuthenticatorStatus
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response contains info about the result </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The service was not found </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The response contains info about the result </td><td>  -  </td></tr>
        <tr><td> 501 </td><td> The response contains info about the result </td><td>  -  </td></tr>
     </table>
     */
    public AuthenticatorStatus getGCPAuthenticatorStatus(String account, String xRequestId) throws ApiException {
        ApiResponse<AuthenticatorStatus> localVarResp = getGCPAuthenticatorStatusWithHttpInfo(account, xRequestId);
        return localVarResp.getData();
    }


    /**
     * Details whether an authentication service has been configured properly
     * Once the status webservice has been properly configured and the relevant user groups have been given permissions to access the status webservice, the users in those groups can check the status of the authenticator.  This operation only supports the GCP authenticator  See [Conjur Documentation](https://docs.conjur.org/Latest/en/Content/Integrations/Authn-status.htm) for details on setting up the authenticator status webservice. 
     * @param account The organization account name
     * @return AuthenticatorStatus
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response contains info about the result </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The service was not found </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The response contains info about the result </td><td>  -  </td></tr>
        <tr><td> 501 </td><td> The response contains info about the result </td><td>  -  </td></tr>
     </table>
    */
    public AuthenticatorStatus getGCPAuthenticatorStatus(String account) throws ApiException {
        ApiResponse<AuthenticatorStatus> localVarResp = getGCPAuthenticatorStatusWithHttpInfo(account, null);
        return localVarResp.getData();
    }

    /**
     * Details whether an authentication service has been configured properly
     * Once the status webservice has been properly configured and the relevant user groups have been given permissions to access the status webservice, the users in those groups can check the status of the authenticator.  This operation only supports the GCP authenticator  See [Conjur Documentation](https://docs.conjur.org/Latest/en/Content/Integrations/Authn-status.htm) for details on setting up the authenticator status webservice. 
     * @param account The organization account name (required)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @return ApiResponse&lt;AuthenticatorStatus&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response contains info about the result </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The service was not found </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The response contains info about the result </td><td>  -  </td></tr>
        <tr><td> 501 </td><td> The response contains info about the result </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AuthenticatorStatus> getGCPAuthenticatorStatusWithHttpInfo(String account, String xRequestId) throws ApiException {
        okhttp3.Call localVarCall = getGCPAuthenticatorStatusValidateBeforeCall(account, xRequestId, null);
        Type localVarReturnType = new TypeToken<AuthenticatorStatus>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Details whether an authentication service has been configured properly
     * Once the status webservice has been properly configured and the relevant user groups have been given permissions to access the status webservice, the users in those groups can check the status of the authenticator.  This operation only supports the GCP authenticator  See [Conjur Documentation](https://docs.conjur.org/Latest/en/Content/Integrations/Authn-status.htm) for details on setting up the authenticator status webservice. 
     * @param account The organization account name 
     * @return ApiResponse&lt;AuthenticatorStatus&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response contains info about the result </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The service was not found </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The response contains info about the result </td><td>  -  </td></tr>
        <tr><td> 501 </td><td> The response contains info about the result </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AuthenticatorStatus> getGCPAuthenticatorStatusWithHttpInfo(String account) throws ApiException {
        okhttp3.Call localVarCall = getGCPAuthenticatorStatusValidateBeforeCall(account, null, null);
        Type localVarReturnType = new TypeToken<AuthenticatorStatus>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Details whether an authentication service has been configured properly (asynchronously)
     * Once the status webservice has been properly configured and the relevant user groups have been given permissions to access the status webservice, the users in those groups can check the status of the authenticator.  This operation only supports the GCP authenticator  See [Conjur Documentation](https://docs.conjur.org/Latest/en/Content/Integrations/Authn-status.htm) for details on setting up the authenticator status webservice. 
     * @param account The organization account name (required)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response contains info about the result </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The service was not found </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The response contains info about the result </td><td>  -  </td></tr>
        <tr><td> 501 </td><td> The response contains info about the result </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getGCPAuthenticatorStatusAsync(String account, String xRequestId, final ApiCallback<AuthenticatorStatus> _callback) throws ApiException {

        okhttp3.Call localVarCall = getGCPAuthenticatorStatusValidateBeforeCall(account, xRequestId, _callback);
        Type localVarReturnType = new TypeToken<AuthenticatorStatus>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getServiceAuthenticatorStatus
     * @param authenticator The type of authenticator (required)
     * @param serviceId URL-Encoded authenticator service ID (required)
     * @param account The organization account name (required)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response contains info about the result </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The service was not found </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The response contains info about the result </td><td>  -  </td></tr>
        <tr><td> 501 </td><td> The response contains info about the result </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getServiceAuthenticatorStatusCall(String authenticator, String serviceId, String account, String xRequestId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/{authenticator}/{service_id}/{account}/status"
            .replaceAll("\\{" + "authenticator" + "\\}", localVarApiClient.escapeString(authenticator.toString()))
            .replaceAll("\\{" + "service_id" + "\\}", localVarApiClient.escapeString(serviceId.toString()))
            .replaceAll("\\{" + "account" + "\\}", localVarApiClient.escapeString(account.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", localVarApiClient.parameterToString(xRequestId));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "conjurAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getServiceAuthenticatorStatusValidateBeforeCall(String authenticator, String serviceId, String account, String xRequestId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'authenticator' is set
        if (authenticator == null) {
            throw new ApiException("Missing the required parameter 'authenticator' when calling getServiceAuthenticatorStatus(Async)");
        }
        
        // verify the required parameter 'serviceId' is set
        if (serviceId == null) {
            throw new ApiException("Missing the required parameter 'serviceId' when calling getServiceAuthenticatorStatus(Async)");
        }
        
        // verify the required parameter 'account' is set
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling getServiceAuthenticatorStatus(Async)");
        }
        

        okhttp3.Call localVarCall = getServiceAuthenticatorStatusCall(authenticator, serviceId, account, xRequestId, _callback);
        return localVarCall;

    }

    /**
     * Details whether an authentication service has been configured properly
     * Once the status webservice has been properly configured and the relevant user groups have been given permissions to access the status webservice, the users in those groups can check the status of the authenticator.  Supported Authenticators:   - Azure   - OIDC  Not Supported:   - AWS IAM   - Kubernetes   - LDAP  See [Conjur Documentation](https://docs.conjur.org/Latest/en/Content/Integrations/Authn-status.htm) for details on setting up the authenticator status webservice. 
     * @param authenticator The type of authenticator (required)
     * @param serviceId URL-Encoded authenticator service ID (required)
     * @param account The organization account name (required)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @return AuthenticatorStatus
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response contains info about the result </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The service was not found </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The response contains info about the result </td><td>  -  </td></tr>
        <tr><td> 501 </td><td> The response contains info about the result </td><td>  -  </td></tr>
     </table>
     */
    public AuthenticatorStatus getServiceAuthenticatorStatus(String authenticator, String serviceId, String account, String xRequestId) throws ApiException {
        ApiResponse<AuthenticatorStatus> localVarResp = getServiceAuthenticatorStatusWithHttpInfo(authenticator, serviceId, account, xRequestId);
        return localVarResp.getData();
    }


    /**
     * Details whether an authentication service has been configured properly
     * Once the status webservice has been properly configured and the relevant user groups have been given permissions to access the status webservice, the users in those groups can check the status of the authenticator.  Supported Authenticators:   - Azure   - OIDC  Not Supported:   - AWS IAM   - Kubernetes   - LDAP  See [Conjur Documentation](https://docs.conjur.org/Latest/en/Content/Integrations/Authn-status.htm) for details on setting up the authenticator status webservice. 
     * @param authenticator The type of authenticator
     * @param serviceId URL-Encoded authenticator service ID
     * @param account The organization account name
     * @return AuthenticatorStatus
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response contains info about the result </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The service was not found </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The response contains info about the result </td><td>  -  </td></tr>
        <tr><td> 501 </td><td> The response contains info about the result </td><td>  -  </td></tr>
     </table>
    */
    public AuthenticatorStatus getServiceAuthenticatorStatus(String authenticator, String serviceId, String account) throws ApiException {
        ApiResponse<AuthenticatorStatus> localVarResp = getServiceAuthenticatorStatusWithHttpInfo(authenticator, serviceId, account, null);
        return localVarResp.getData();
    }

    /**
     * Details whether an authentication service has been configured properly
     * Once the status webservice has been properly configured and the relevant user groups have been given permissions to access the status webservice, the users in those groups can check the status of the authenticator.  Supported Authenticators:   - Azure   - OIDC  Not Supported:   - AWS IAM   - Kubernetes   - LDAP  See [Conjur Documentation](https://docs.conjur.org/Latest/en/Content/Integrations/Authn-status.htm) for details on setting up the authenticator status webservice. 
     * @param authenticator The type of authenticator (required)
     * @param serviceId URL-Encoded authenticator service ID (required)
     * @param account The organization account name (required)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @return ApiResponse&lt;AuthenticatorStatus&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response contains info about the result </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The service was not found </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The response contains info about the result </td><td>  -  </td></tr>
        <tr><td> 501 </td><td> The response contains info about the result </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AuthenticatorStatus> getServiceAuthenticatorStatusWithHttpInfo(String authenticator, String serviceId, String account, String xRequestId) throws ApiException {
        okhttp3.Call localVarCall = getServiceAuthenticatorStatusValidateBeforeCall(authenticator, serviceId, account, xRequestId, null);
        Type localVarReturnType = new TypeToken<AuthenticatorStatus>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Details whether an authentication service has been configured properly
     * Once the status webservice has been properly configured and the relevant user groups have been given permissions to access the status webservice, the users in those groups can check the status of the authenticator.  Supported Authenticators:   - Azure   - OIDC  Not Supported:   - AWS IAM   - Kubernetes   - LDAP  See [Conjur Documentation](https://docs.conjur.org/Latest/en/Content/Integrations/Authn-status.htm) for details on setting up the authenticator status webservice. 
     * @param authenticator The type of authenticator 
     * @param serviceId URL-Encoded authenticator service ID 
     * @param account The organization account name 
     * @return ApiResponse&lt;AuthenticatorStatus&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response contains info about the result </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The service was not found </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The response contains info about the result </td><td>  -  </td></tr>
        <tr><td> 501 </td><td> The response contains info about the result </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AuthenticatorStatus> getServiceAuthenticatorStatusWithHttpInfo(String authenticator, String serviceId, String account) throws ApiException {
        okhttp3.Call localVarCall = getServiceAuthenticatorStatusValidateBeforeCall(authenticator, serviceId, account, null, null);
        Type localVarReturnType = new TypeToken<AuthenticatorStatus>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Details whether an authentication service has been configured properly (asynchronously)
     * Once the status webservice has been properly configured and the relevant user groups have been given permissions to access the status webservice, the users in those groups can check the status of the authenticator.  Supported Authenticators:   - Azure   - OIDC  Not Supported:   - AWS IAM   - Kubernetes   - LDAP  See [Conjur Documentation](https://docs.conjur.org/Latest/en/Content/Integrations/Authn-status.htm) for details on setting up the authenticator status webservice. 
     * @param authenticator The type of authenticator (required)
     * @param serviceId URL-Encoded authenticator service ID (required)
     * @param account The organization account name (required)
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response contains info about the result </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> The server cannot process the request due to malformed request syntax </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> The authenticated user lacks the necessary privileges </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The service was not found </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The response contains info about the result </td><td>  -  </td></tr>
        <tr><td> 501 </td><td> The response contains info about the result </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getServiceAuthenticatorStatusAsync(String authenticator, String serviceId, String account, String xRequestId, final ApiCallback<AuthenticatorStatus> _callback) throws ApiException {

        okhttp3.Call localVarCall = getServiceAuthenticatorStatusValidateBeforeCall(authenticator, serviceId, account, xRequestId, _callback);
        Type localVarReturnType = new TypeToken<AuthenticatorStatus>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for whoAmI
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Details about the client making the request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call whoAmICall(String xRequestId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/whoami";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", localVarApiClient.parameterToString(xRequestId));
        }

        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "conjurAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call whoAmIValidateBeforeCall(String xRequestId, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = whoAmICall(xRequestId, _callback);
        return localVarCall;

    }

    /**
     * Provides information about the client making an API request.
     * WhoAmI provides information about the client making an API request. It can be used to help troubleshoot configuration by verifying authentication and the client IP address for audit and network access restrictions. For more information, see Host Attributes. 
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @return WhoAmI
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Details about the client making the request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
     </table>
     */
    public WhoAmI whoAmI(String xRequestId) throws ApiException {
        ApiResponse<WhoAmI> localVarResp = whoAmIWithHttpInfo(xRequestId);
        return localVarResp.getData();
    }


    /**
     * Provides information about the client making an API request.
     * WhoAmI provides information about the client making an API request. It can be used to help troubleshoot configuration by verifying authentication and the client IP address for audit and network access restrictions. For more information, see Host Attributes. 
     * @return WhoAmI
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Details about the client making the request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
     </table>
    */
    public WhoAmI whoAmI() throws ApiException {
        ApiResponse<WhoAmI> localVarResp = whoAmIWithHttpInfo(null);
        return localVarResp.getData();
    }

    /**
     * Provides information about the client making an API request.
     * WhoAmI provides information about the client making an API request. It can be used to help troubleshoot configuration by verifying authentication and the client IP address for audit and network access restrictions. For more information, see Host Attributes. 
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @return ApiResponse&lt;WhoAmI&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Details about the client making the request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WhoAmI> whoAmIWithHttpInfo(String xRequestId) throws ApiException {
        okhttp3.Call localVarCall = whoAmIValidateBeforeCall(xRequestId, null);
        Type localVarReturnType = new TypeToken<WhoAmI>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Provides information about the client making an API request.
     * WhoAmI provides information about the client making an API request. It can be used to help troubleshoot configuration by verifying authentication and the client IP address for audit and network access restrictions. For more information, see Host Attributes. 
     * @return ApiResponse&lt;WhoAmI&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Details about the client making the request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WhoAmI> whoAmIWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = whoAmIValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<WhoAmI>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Provides information about the client making an API request. (asynchronously)
     * WhoAmI provides information about the client making an API request. It can be used to help troubleshoot configuration by verifying authentication and the client IP address for audit and network access restrictions. For more information, see Host Attributes. 
     * @param xRequestId Add an ID to the request being made so it can be tracked in Conjur. If not provided the server will automatically generate one.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Details about the client making the request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Authentication information is missing or invalid </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call whoAmIAsync(String xRequestId, final ApiCallback<WhoAmI> _callback) throws ApiException {

        okhttp3.Call localVarCall = whoAmIValidateBeforeCall(xRequestId, _callback);
        Type localVarReturnType = new TypeToken<WhoAmI>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
