/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.sdk;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.util.Base64;
import java.util.Date;

public class AccessToken {
    @SerializedName(value="protected")
    private String protect = null;
    private String payload = null;
    private String signature = null;
    private static Base64.Decoder decoder = Base64.getDecoder();
    private static Gson gson = new Gson();
    private String encodedToken;

    public static AccessToken fromEncodedToken(String encodedToken) {
        String decodedToken = new String(decoder.decode(encodedToken));
        AccessToken token = (AccessToken)gson.fromJson(decodedToken, AccessToken.class);
        token.encodedToken = encodedToken;
        return token;
    }

    public String getHeaderValue() {
        if (this.encodedToken == null) {
            throw new NullPointerException("AccessToken must be initialized properly before use.");
        }
        return String.format("token=\"%s\"", this.encodedToken);
    }

    public long getExpiry() {
        String payloadJSON = new String(decoder.decode(this.getPayload()));
        Payload payload = (Payload)gson.fromJson(payloadJSON, Payload.class);
        return payload.getExpiry();
    }

    public boolean needsRefresh() {
        return this.getPayload() == null || this.getExpiry() - 10L <= new Date().getTime() / 1000L;
    }

    public String toString() {
        return String.format("{\n\tprotected: %s\n\tpayload: %s\n\tsignature: %s\n}", this.protect, this.payload, this.signature);
    }

    public String getProtected() {
        return this.protect;
    }

    public String getPayload() {
        return this.payload;
    }

    public String getSignature() {
        return this.signature;
    }

    private class Payload {
        private final int TOKEN_LIFETIME_MINUTES = 8;
        private Long iat = null;
        private Long exp = null;
        private String sub = null;
        private String[] cidr = null;

        private Payload() {
        }

        public long getExpiry() {
            if (this.exp != null) {
                return this.exp;
            }
            return this.iat + 480L;
        }
    }
}

