/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.sdk.auth;

import com.cyberark.conjur.sdk.AccessToken;
import com.cyberark.conjur.sdk.Pair;
import com.cyberark.conjur.sdk.auth.Authentication;
import java.util.List;
import java.util.Map;

public class ApiKeyAuth
implements Authentication {
    private final String location;
    private final String paramName;
    private String apiKey;
    private String apiKeyPrefix;
    private AccessToken token;

    public ApiKeyAuth(String location, String paramName, AccessToken token) {
        this.location = location;
        this.paramName = paramName;
        this.token = token;
    }

    public String getLocation() {
        return this.location;
    }

    public String getParamName() {
        return this.paramName;
    }

    public String getApiKey() {
        if (this.apiKey == null) {
            return this.token.getHeaderValue();
        }
        return this.apiKey;
    }

    public AccessToken getAccessToken() {
        return this.token;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApiKeyPrefix() {
        return this.apiKeyPrefix;
    }

    public void setApiKeyPrefix(String apiKeyPrefix) {
        this.apiKeyPrefix = apiKeyPrefix;
    }

    public void setAccessToken(AccessToken token) {
        this.token = token;
    }

    @Override
    public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams, Map<String, String> cookieParams) {
        if (this.apiKey == null && this.token == null) {
            return;
        }
        String value = this.apiKeyPrefix != null ? this.apiKeyPrefix + " " + this.getApiKey() : this.getApiKey();
        if ("query".equals(this.location)) {
            queryParams.add(new Pair(this.paramName, value));
        } else if ("header".equals(this.location)) {
            headerParams.put(this.paramName, value);
        } else if ("cookie".equals(this.location)) {
            cookieParams.put(this.paramName, value);
        }
    }
}

