/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.sdk.endpoint;

import com.cyberark.conjur.sdk.ApiCallback;
import com.cyberark.conjur.sdk.ApiClient;
import com.cyberark.conjur.sdk.ApiException;
import com.cyberark.conjur.sdk.ApiResponse;
import com.cyberark.conjur.sdk.Configuration;
import com.cyberark.conjur.sdk.Pair;
import com.cyberark.conjur.sdk.model.CreateHost;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class HostFactoryApi {
    private ApiClient localVarApiClient;

    public HostFactoryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HostFactoryApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createHostCall(String id, String xRequestId, Object annotations, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/host_factories/hosts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (annotations != null) {
            localVarFormParams.put("annotations", annotations);
        }
        if (id != null) {
            localVarFormParams.put("id", id);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"conjurAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createHostValidateBeforeCall(String id, String xRequestId, Object annotations, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling createHost(Async)");
        }
        Call localVarCall = this.createHostCall(id, xRequestId, annotations, _callback);
        return localVarCall;
    }

    public CreateHost createHost(String id, String xRequestId, Object annotations) throws ApiException {
        ApiResponse<CreateHost> localVarResp = this.createHostWithHttpInfo(id, xRequestId, annotations);
        return localVarResp.getData();
    }

    public CreateHost createHost(String id) throws ApiException {
        ApiResponse<CreateHost> localVarResp = this.createHostWithHttpInfo(id, null, null);
        return localVarResp.getData();
    }

    public ApiResponse<CreateHost> createHostWithHttpInfo(String id, String xRequestId, Object annotations) throws ApiException {
        Call localVarCall = this.createHostValidateBeforeCall(id, xRequestId, annotations, null);
        Type localVarReturnType = new TypeToken<CreateHost>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<CreateHost> createHostWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.createHostValidateBeforeCall(id, null, null, null);
        Type localVarReturnType = new TypeToken<CreateHost>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createHostAsync(String id, String xRequestId, Object annotations, ApiCallback<CreateHost> _callback) throws ApiException {
        Call localVarCall = this.createHostValidateBeforeCall(id, xRequestId, annotations, _callback);
        Type localVarReturnType = new TypeToken<CreateHost>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createTokenCall(String expiration, String hostFactory, String xRequestId, List<String> cidr, Integer count, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/host_factory_tokens";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cidr != null) {
            localVarFormParams.put("cidr", cidr);
        }
        if (count != null) {
            localVarFormParams.put("count", count);
        }
        if (expiration != null) {
            localVarFormParams.put("expiration", expiration);
        }
        if (hostFactory != null) {
            localVarFormParams.put("host_factory", hostFactory);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"conjurAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createTokenValidateBeforeCall(String expiration, String hostFactory, String xRequestId, List<String> cidr, Integer count, ApiCallback _callback) throws ApiException {
        if (expiration == null) {
            throw new ApiException("Missing the required parameter 'expiration' when calling createToken(Async)");
        }
        if (hostFactory == null) {
            throw new ApiException("Missing the required parameter 'hostFactory' when calling createToken(Async)");
        }
        Call localVarCall = this.createTokenCall(expiration, hostFactory, xRequestId, cidr, count, _callback);
        return localVarCall;
    }

    public List<Object> createToken(String expiration, String hostFactory, String xRequestId, List<String> cidr, Integer count) throws ApiException {
        ApiResponse<List<Object>> localVarResp = this.createTokenWithHttpInfo(expiration, hostFactory, xRequestId, cidr, count);
        return localVarResp.getData();
    }

    public List<Object> createToken(String expiration, String hostFactory) throws ApiException {
        ApiResponse<List<Object>> localVarResp = this.createTokenWithHttpInfo(expiration, hostFactory, null, null, null);
        return localVarResp.getData();
    }

    public ApiResponse<List<Object>> createTokenWithHttpInfo(String expiration, String hostFactory, String xRequestId, List<String> cidr, Integer count) throws ApiException {
        Call localVarCall = this.createTokenValidateBeforeCall(expiration, hostFactory, xRequestId, cidr, count, null);
        Type localVarReturnType = new TypeToken<List<Object>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<List<Object>> createTokenWithHttpInfo(String expiration, String hostFactory) throws ApiException {
        Call localVarCall = this.createTokenValidateBeforeCall(expiration, hostFactory, null, null, null, null);
        Type localVarReturnType = new TypeToken<List<Object>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createTokenAsync(String expiration, String hostFactory, String xRequestId, List<String> cidr, Integer count, ApiCallback<List<Object>> _callback) throws ApiException {
        Call localVarCall = this.createTokenValidateBeforeCall(expiration, hostFactory, xRequestId, cidr, count, _callback);
        Type localVarReturnType = new TypeToken<List<Object>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call revokeTokenCall(String token, String xRequestId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/host_factory_tokens/{token}".replaceAll("\\{token\\}", this.localVarApiClient.escapeString(token.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"conjurAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call revokeTokenValidateBeforeCall(String token, String xRequestId, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling revokeToken(Async)");
        }
        Call localVarCall = this.revokeTokenCall(token, xRequestId, _callback);
        return localVarCall;
    }

    public void revokeToken(String token, String xRequestId) throws ApiException {
        this.revokeTokenWithHttpInfo(token, xRequestId);
    }

    public void revokeToken(String token) throws ApiException {
        this.revokeTokenWithHttpInfo(token, null);
    }

    public ApiResponse<Void> revokeTokenWithHttpInfo(String token, String xRequestId) throws ApiException {
        Call localVarCall = this.revokeTokenValidateBeforeCall(token, xRequestId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public ApiResponse<Void> revokeTokenWithHttpInfo(String token) throws ApiException {
        Call localVarCall = this.revokeTokenValidateBeforeCall(token, null, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call revokeTokenAsync(String token, String xRequestId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.revokeTokenValidateBeforeCall(token, xRequestId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

