/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.sdk.endpoint;

import com.cyberark.conjur.sdk.ApiCallback;
import com.cyberark.conjur.sdk.ApiClient;
import com.cyberark.conjur.sdk.ApiException;
import com.cyberark.conjur.sdk.ApiResponse;
import com.cyberark.conjur.sdk.Configuration;
import com.cyberark.conjur.sdk.Pair;
import com.cyberark.conjur.sdk.model.Resource;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class ResourcesApi {
    private ApiClient localVarApiClient;

    public ResourcesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ResourcesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call showResourceCall(String account, String kind, String identifier, Boolean permittedRoles, String privilege, Boolean check, String role, String xRequestId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/resources/{account}/{kind}/{identifier}".replaceAll("\\{account\\}", this.localVarApiClient.escapeString(account.toString())).replaceAll("\\{kind\\}", this.localVarApiClient.escapeString(kind.toString())).replaceAll("\\{identifier\\}", this.localVarApiClient.escapeString(identifier.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (permittedRoles != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("permitted_roles", permittedRoles));
        }
        if (privilege != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("privilege", privilege));
        }
        if (check != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("check", check));
        }
        if (role != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("role", role));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"conjurAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call showResourceValidateBeforeCall(String account, String kind, String identifier, Boolean permittedRoles, String privilege, Boolean check, String role, String xRequestId, ApiCallback _callback) throws ApiException {
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling showResource(Async)");
        }
        if (kind == null) {
            throw new ApiException("Missing the required parameter 'kind' when calling showResource(Async)");
        }
        if (identifier == null) {
            throw new ApiException("Missing the required parameter 'identifier' when calling showResource(Async)");
        }
        Call localVarCall = this.showResourceCall(account, kind, identifier, permittedRoles, privilege, check, role, xRequestId, _callback);
        return localVarCall;
    }

    public Resource showResource(String account, String kind, String identifier, Boolean permittedRoles, String privilege, Boolean check, String role, String xRequestId) throws ApiException {
        ApiResponse<Resource> localVarResp = this.showResourceWithHttpInfo(account, kind, identifier, permittedRoles, privilege, check, role, xRequestId);
        return localVarResp.getData();
    }

    public Resource showResource(String account, String kind, String identifier) throws ApiException {
        ApiResponse<Resource> localVarResp = this.showResourceWithHttpInfo(account, kind, identifier, null, null, null, null, null);
        return localVarResp.getData();
    }

    public ApiResponse<Resource> showResourceWithHttpInfo(String account, String kind, String identifier, Boolean permittedRoles, String privilege, Boolean check, String role, String xRequestId) throws ApiException {
        Call localVarCall = this.showResourceValidateBeforeCall(account, kind, identifier, permittedRoles, privilege, check, role, xRequestId, null);
        Type localVarReturnType = new TypeToken<Resource>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<Resource> showResourceWithHttpInfo(String account, String kind, String identifier) throws ApiException {
        Call localVarCall = this.showResourceValidateBeforeCall(account, kind, identifier, null, null, null, null, null, null);
        Type localVarReturnType = new TypeToken<Resource>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call showResourceAsync(String account, String kind, String identifier, Boolean permittedRoles, String privilege, Boolean check, String role, String xRequestId, ApiCallback<Resource> _callback) throws ApiException {
        Call localVarCall = this.showResourceValidateBeforeCall(account, kind, identifier, permittedRoles, privilege, check, role, xRequestId, _callback);
        Type localVarReturnType = new TypeToken<Resource>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call showResourcesForAccountCall(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/resources/{account}".replaceAll("\\{account\\}", this.localVarApiClient.escapeString(account.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (kind != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("kind", kind));
        }
        if (search != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("search", search));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (count != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("count", count));
        }
        if (role != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("role", role));
        }
        if (actingAs != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("acting_as", actingAs));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"conjurAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call showResourcesForAccountValidateBeforeCall(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId, ApiCallback _callback) throws ApiException {
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling showResourcesForAccount(Async)");
        }
        Call localVarCall = this.showResourcesForAccountCall(account, kind, search, offset, limit, count, role, actingAs, xRequestId, _callback);
        return localVarCall;
    }

    public List<Resource> showResourcesForAccount(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId) throws ApiException {
        ApiResponse<List<Resource>> localVarResp = this.showResourcesForAccountWithHttpInfo(account, kind, search, offset, limit, count, role, actingAs, xRequestId);
        return localVarResp.getData();
    }

    public List<Resource> showResourcesForAccount(String account) throws ApiException {
        ApiResponse<List<Resource>> localVarResp = this.showResourcesForAccountWithHttpInfo(account, null, null, null, null, null, null, null, null);
        return localVarResp.getData();
    }

    public ApiResponse<List<Resource>> showResourcesForAccountWithHttpInfo(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId) throws ApiException {
        Call localVarCall = this.showResourcesForAccountValidateBeforeCall(account, kind, search, offset, limit, count, role, actingAs, xRequestId, null);
        Type localVarReturnType = new TypeToken<List<Resource>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<List<Resource>> showResourcesForAccountWithHttpInfo(String account) throws ApiException {
        Call localVarCall = this.showResourcesForAccountValidateBeforeCall(account, null, null, null, null, null, null, null, null, null);
        Type localVarReturnType = new TypeToken<List<Resource>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call showResourcesForAccountAsync(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId, ApiCallback<List<Resource>> _callback) throws ApiException {
        Call localVarCall = this.showResourcesForAccountValidateBeforeCall(account, kind, search, offset, limit, count, role, actingAs, xRequestId, _callback);
        Type localVarReturnType = new TypeToken<List<Resource>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call showResourcesForAllAccountsCall(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/resources";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (account != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("account", account));
        }
        if (kind != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("kind", kind));
        }
        if (search != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("search", search));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (count != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("count", count));
        }
        if (role != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("role", role));
        }
        if (actingAs != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("acting_as", actingAs));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"conjurAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call showResourcesForAllAccountsValidateBeforeCall(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.showResourcesForAllAccountsCall(account, kind, search, offset, limit, count, role, actingAs, xRequestId, _callback);
        return localVarCall;
    }

    public List<Resource> showResourcesForAllAccounts(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId) throws ApiException {
        ApiResponse<List<Resource>> localVarResp = this.showResourcesForAllAccountsWithHttpInfo(account, kind, search, offset, limit, count, role, actingAs, xRequestId);
        return localVarResp.getData();
    }

    public List<Resource> showResourcesForAllAccounts() throws ApiException {
        ApiResponse<List<Resource>> localVarResp = this.showResourcesForAllAccountsWithHttpInfo(null, null, null, null, null, null, null, null, null);
        return localVarResp.getData();
    }

    public ApiResponse<List<Resource>> showResourcesForAllAccountsWithHttpInfo(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId) throws ApiException {
        Call localVarCall = this.showResourcesForAllAccountsValidateBeforeCall(account, kind, search, offset, limit, count, role, actingAs, xRequestId, null);
        Type localVarReturnType = new TypeToken<List<Resource>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<List<Resource>> showResourcesForAllAccountsWithHttpInfo() throws ApiException {
        Call localVarCall = this.showResourcesForAllAccountsValidateBeforeCall(null, null, null, null, null, null, null, null, null, null);
        Type localVarReturnType = new TypeToken<List<Resource>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call showResourcesForAllAccountsAsync(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId, ApiCallback<List<Resource>> _callback) throws ApiException {
        Call localVarCall = this.showResourcesForAllAccountsValidateBeforeCall(account, kind, search, offset, limit, count, role, actingAs, xRequestId, _callback);
        Type localVarReturnType = new TypeToken<List<Resource>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call showResourcesForKindCall(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/resources/{account}/{kind}".replaceAll("\\{account\\}", this.localVarApiClient.escapeString(account.toString())).replaceAll("\\{kind\\}", this.localVarApiClient.escapeString(kind.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (search != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("search", search));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (count != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("count", count));
        }
        if (role != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("role", role));
        }
        if (actingAs != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("acting_as", actingAs));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"conjurAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call showResourcesForKindValidateBeforeCall(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId, ApiCallback _callback) throws ApiException {
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling showResourcesForKind(Async)");
        }
        if (kind == null) {
            throw new ApiException("Missing the required parameter 'kind' when calling showResourcesForKind(Async)");
        }
        Call localVarCall = this.showResourcesForKindCall(account, kind, search, offset, limit, count, role, actingAs, xRequestId, _callback);
        return localVarCall;
    }

    public List<Resource> showResourcesForKind(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId) throws ApiException {
        ApiResponse<List<Resource>> localVarResp = this.showResourcesForKindWithHttpInfo(account, kind, search, offset, limit, count, role, actingAs, xRequestId);
        return localVarResp.getData();
    }

    public List<Resource> showResourcesForKind(String account, String kind) throws ApiException {
        ApiResponse<List<Resource>> localVarResp = this.showResourcesForKindWithHttpInfo(account, kind, null, null, null, null, null, null, null);
        return localVarResp.getData();
    }

    public ApiResponse<List<Resource>> showResourcesForKindWithHttpInfo(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId) throws ApiException {
        Call localVarCall = this.showResourcesForKindValidateBeforeCall(account, kind, search, offset, limit, count, role, actingAs, xRequestId, null);
        Type localVarReturnType = new TypeToken<List<Resource>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<List<Resource>> showResourcesForKindWithHttpInfo(String account, String kind) throws ApiException {
        Call localVarCall = this.showResourcesForKindValidateBeforeCall(account, kind, null, null, null, null, null, null, null, null);
        Type localVarReturnType = new TypeToken<List<Resource>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call showResourcesForKindAsync(String account, String kind, String search, Integer offset, Integer limit, Boolean count, String role, String actingAs, String xRequestId, ApiCallback<List<Resource>> _callback) throws ApiException {
        Call localVarCall = this.showResourcesForKindValidateBeforeCall(account, kind, search, offset, limit, count, role, actingAs, xRequestId, _callback);
        Type localVarReturnType = new TypeToken<List<Resource>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

