/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.sdk.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Information about the client making a request")
public class WhoAmI {
    public static final String SERIALIZED_NAME_ACCOUNT = "account";
    @SerializedName(value="account")
    private String account;
    public static final String SERIALIZED_NAME_CLIENT_IP = "client_ip";
    @SerializedName(value="client_ip")
    private String clientIp;
    public static final String SERIALIZED_NAME_TOKEN_ISSUED_AT = "token_issued_at";
    @SerializedName(value="token_issued_at")
    private String tokenIssuedAt;
    public static final String SERIALIZED_NAME_USER_AGENT = "user_agent";
    @SerializedName(value="user_agent")
    private String userAgent;
    public static final String SERIALIZED_NAME_USERNAME = "username";
    @SerializedName(value="username")
    private String username;

    public WhoAmI account(String account) {
        this.account = account;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="dev", value="The account attribute of the client provided access token.")
    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public WhoAmI clientIp(String clientIp) {
        this.clientIp = clientIp;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="127.0.0.1", value="The request client IP address as determined by Conjur. This same IP address appears in application logs and audit logs.")
    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public WhoAmI tokenIssuedAt(String tokenIssuedAt) {
        this.tokenIssuedAt = tokenIssuedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2017-08-04T22:27:20+00:00", value="The issued timestamp, that is, when the provided access token was created (iat field in the JWT)")
    public String getTokenIssuedAt() {
        return this.tokenIssuedAt;
    }

    public void setTokenIssuedAt(String tokenIssuedAt) {
        this.tokenIssuedAt = tokenIssuedAt;
    }

    public WhoAmI userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36", value="The incoming request HTTP user agent header.")
    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public WhoAmI username(String username) {
        this.username = username;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="admin", value="The username attribute of the provided access token.")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhoAmI whoAmI = (WhoAmI)o;
        return Objects.equals(this.account, whoAmI.account) && Objects.equals(this.clientIp, whoAmI.clientIp) && Objects.equals(this.tokenIssuedAt, whoAmI.tokenIssuedAt) && Objects.equals(this.userAgent, whoAmI.userAgent) && Objects.equals(this.username, whoAmI.username);
    }

    public int hashCode() {
        return Objects.hash(this.account, this.clientIp, this.tokenIssuedAt, this.userAgent, this.username);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhoAmI {\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    clientIp: ").append(this.toIndentedString(this.clientIp)).append("\n");
        sb.append("    tokenIssuedAt: ").append(this.toIndentedString(this.tokenIssuedAt)).append("\n");
        sb.append("    userAgent: ").append(this.toIndentedString(this.userAgent)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

