/*
 * Conjur
 * This is an API definition for CyberArk Conjur Open Source. You can find out more at [Conjur.org](https://www.conjur.org/).
 *
 * The version of the OpenAPI document: 5.3.1
 * Contact: conj_maintainers@cyberark.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.cyberark.conjur.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * CreateHostTokenForm
 */

public class CreateHostTokenForm {
  public static final String SERIALIZED_NAME_CIDR = "cidr";
  @SerializedName(SERIALIZED_NAME_CIDR)
  private List<String> cidr = null;

  public static final String SERIALIZED_NAME_COUNT = "count";
  @SerializedName(SERIALIZED_NAME_COUNT)
  private Integer count;

  public static final String SERIALIZED_NAME_EXPIRATION = "expiration";
  @SerializedName(SERIALIZED_NAME_EXPIRATION)
  private String expiration;

  public static final String SERIALIZED_NAME_HOST_FACTORY = "host_factory";
  @SerializedName(SERIALIZED_NAME_HOST_FACTORY)
  private String hostFactory;


  public CreateHostTokenForm cidr(List<String> cidr) {
    
    this.cidr = cidr;
    return this;
  }

  public CreateHostTokenForm addCidrItem(String cidrItem) {
    if (this.cidr == null) {
      this.cidr = new ArrayList<String>();
    }
    this.cidr.add(cidrItem);
    return this;
  }

   /**
   * Number of host tokens to create
   * @return cidr
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"127.0.0.1/32\"]", value = "Number of host tokens to create")

  public List<String> getCidr() {
    return cidr;
  }


  public void setCidr(List<String> cidr) {
    this.cidr = cidr;
  }


  public CreateHostTokenForm count(Integer count) {
    
    this.count = count;
    return this;
  }

   /**
   * Number of host tokens to create
   * @return count
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2", value = "Number of host tokens to create")

  public Integer getCount() {
    return count;
  }


  public void setCount(Integer count) {
    this.count = count;
  }


  public CreateHostTokenForm expiration(String expiration) {
    
    this.expiration = expiration;
    return this;
  }

   /**
   * &#x60;ISO 8601 datetime&#x60; denoting a requested expiration time.
   * @return expiration
  **/
  @ApiModelProperty(example = "2017-08-04T22:27:20+00:00", required = true, value = "`ISO 8601 datetime` denoting a requested expiration time.")

  public String getExpiration() {
    return expiration;
  }


  public void setExpiration(String expiration) {
    this.expiration = expiration;
  }


  public CreateHostTokenForm hostFactory(String hostFactory) {
    
    this.hostFactory = hostFactory;
    return this;
  }

   /**
   * Fully qualified host factory ID
   * @return hostFactory
  **/
  @ApiModelProperty(example = "myorg:host_factory:hf-db", required = true, value = "Fully qualified host factory ID")

  public String getHostFactory() {
    return hostFactory;
  }


  public void setHostFactory(String hostFactory) {
    this.hostFactory = hostFactory;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateHostTokenForm createHostTokenForm = (CreateHostTokenForm) o;
    return Objects.equals(this.cidr, createHostTokenForm.cidr) &&
        Objects.equals(this.count, createHostTokenForm.count) &&
        Objects.equals(this.expiration, createHostTokenForm.expiration) &&
        Objects.equals(this.hostFactory, createHostTokenForm.hostFactory);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cidr, count, expiration, hostFactory);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateHostTokenForm {\n");
    sb.append("    cidr: ").append(toIndentedString(cidr)).append("\n");
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    expiration: ").append(toIndentedString(expiration)).append("\n");
    sb.append("    hostFactory: ").append(toIndentedString(hostFactory)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

