/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.sdk.endpoint;

import com.cyberark.conjur.sdk.ApiCallback;
import com.cyberark.conjur.sdk.ApiClient;
import com.cyberark.conjur.sdk.ApiException;
import com.cyberark.conjur.sdk.ApiResponse;
import com.cyberark.conjur.sdk.Configuration;
import com.cyberark.conjur.sdk.Pair;
import com.cyberark.conjur.sdk.model.CertificateJson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class CertificateAuthorityApi {
    private ApiClient localVarApiClient;

    public CertificateAuthorityApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CertificateAuthorityApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call signCall(String account, String serviceId, String csr, String ttl, String accept, String xRequestId, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/ca/{account}/{service_id}/sign".replaceAll("\\{account\\}", this.localVarApiClient.escapeString(account.toString())).replaceAll("\\{service_id\\}", this.localVarApiClient.escapeString(serviceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.localVarApiClient.parameterToString(accept));
        }
        if (xRequestId != null) {
            localVarHeaderParams.put("X-Request-Id", this.localVarApiClient.parameterToString(xRequestId));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (csr != null) {
            localVarFormParams.put("csr", csr);
        }
        if (ttl != null) {
            localVarFormParams.put("ttl", ttl);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/x-pem-file"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"conjurAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call signValidateBeforeCall(String account, String serviceId, String csr, String ttl, String accept, String xRequestId, ApiCallback _callback) throws ApiException {
        if (account == null) {
            throw new ApiException("Missing the required parameter 'account' when calling sign(Async)");
        }
        if (serviceId == null) {
            throw new ApiException("Missing the required parameter 'serviceId' when calling sign(Async)");
        }
        if (csr == null) {
            throw new ApiException("Missing the required parameter 'csr' when calling sign(Async)");
        }
        if (ttl == null) {
            throw new ApiException("Missing the required parameter 'ttl' when calling sign(Async)");
        }
        Call localVarCall = this.signCall(account, serviceId, csr, ttl, accept, xRequestId, _callback);
        return localVarCall;
    }

    public CertificateJson sign(String account, String serviceId, String csr, String ttl, String accept, String xRequestId) throws ApiException {
        ApiResponse<CertificateJson> localVarResp = this.signWithHttpInfo(account, serviceId, csr, ttl, accept, xRequestId);
        return localVarResp.getData();
    }

    public CertificateJson sign(String account, String serviceId, String csr, String ttl) throws ApiException {
        ApiResponse<CertificateJson> localVarResp = this.signWithHttpInfo(account, serviceId, csr, ttl, null, null);
        return localVarResp.getData();
    }

    public ApiResponse<CertificateJson> signWithHttpInfo(String account, String serviceId, String csr, String ttl, String accept, String xRequestId) throws ApiException {
        Call localVarCall = this.signValidateBeforeCall(account, serviceId, csr, ttl, accept, xRequestId, null);
        Type localVarReturnType = new TypeToken<CertificateJson>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public ApiResponse<CertificateJson> signWithHttpInfo(String account, String serviceId, String csr, String ttl) throws ApiException {
        Call localVarCall = this.signValidateBeforeCall(account, serviceId, csr, ttl, null, null, null);
        Type localVarReturnType = new TypeToken<CertificateJson>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call signAsync(String account, String serviceId, String csr, String ttl, String accept, String xRequestId, ApiCallback<CertificateJson> _callback) throws ApiException {
        Call localVarCall = this.signValidateBeforeCall(account, serviceId, csr, ttl, accept, xRequestId, _callback);
        Type localVarReturnType = new TypeToken<CertificateJson>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

