/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.springboot.core.env;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConjurConfig {
    private static final Properties PROPS = new Properties();
    private static final ConjurConfig UNIQUE_INSTANCE = new ConjurConfig();
    private static final Logger LOGGER = LoggerFactory.getLogger(ConjurConfig.class);

    private ConjurConfig() {
        InputStream propsFile = ConjurConfig.class.getResourceAsStream("/conjur.properties");
        if (propsFile != null) {
            try {
                PROPS.load(propsFile);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    propsFile.close();
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static ConjurConfig getInstance() {
        return UNIQUE_INSTANCE;
    }

    public String mapProperty(String name) {
        String mapped = PROPS.getProperty("conjur.mapping." + name);
        return mapped != null ? mapped : name;
    }
}

