/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.springboot.core.env;

import com.cyberark.conjur.sdk.AccessToken;
import com.cyberark.conjur.sdk.ApiClient;
import com.cyberark.conjur.sdk.Configuration;
import com.cyberark.conjur.sdk.endpoint.SecretsApi;
import com.cyberark.conjur.springboot.constant.ConjurConstant;
import com.cyberark.conjur.springboot.core.env.AccessTokenProvider;
import com.cyberark.conjur.springboot.domain.ConjurProperties;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class ConjurConnectionManager
implements EnvironmentAware,
BeanFactoryPostProcessor {
    private final AccessTokenProvider accessTokenProvider;
    private Environment environment;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConjurConnectionManager.class);

    public ConjurConnectionManager(AccessTokenProvider accessTokenProvider) {
        this.accessTokenProvider = accessTokenProvider;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        BindResult result = Binder.get((Environment)this.environment).bind("conjur", ConjurProperties.class);
        if (result.isBound()) {
            this.getConnection((ConjurProperties)result.get());
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    private void getConnection(ConjurProperties conjurProperties) {
        try {
            AccessToken accessToken;
            String authTokenFile;
            ApiClient client = Configuration.getDefaultApiClient();
            client.setAccount(conjurProperties.getAccount());
            client.setBasePath(conjurProperties.getApplianceUrl());
            InputStream sslInputStream = null;
            String sslCertificate = conjurProperties.getSslCertificate();
            String certFile = conjurProperties.getCertFile();
            if (StringUtils.isNotEmpty((CharSequence)sslCertificate)) {
                sslInputStream = new ByteArrayInputStream(sslCertificate.getBytes(StandardCharsets.UTF_8));
            } else if (StringUtils.isNotEmpty((CharSequence)certFile)) {
                sslInputStream = new FileInputStream(certFile);
            }
            if (sslInputStream != null) {
                client.setSslCaCert(sslInputStream);
                sslInputStream.close();
            }
            if (StringUtils.isNotEmpty((CharSequence)(authTokenFile = conjurProperties.getAuthTokenFile()))) {
                String apiKey = new String(Files.readAllBytes(Paths.get(authTokenFile, new String[0])));
                client.setApiKey(apiKey);
            }
            String jwtTokenPath = conjurProperties.getJwtTokenPath();
            String authenticatorId = conjurProperties.getAuthenticatorId();
            String authnLogin = conjurProperties.getAuthnLogin();
            String authApiKey = conjurProperties.getAuthnApiKey();
            if (StringUtils.isNotEmpty((CharSequence)jwtTokenPath) && StringUtils.isNotEmpty((CharSequence)authenticatorId)) {
                LOGGER.debug("Using JWT Authentication");
                accessToken = this.accessTokenProvider.getJwtAccessToken(client, jwtTokenPath, authenticatorId);
            } else {
                if (StringUtils.isNotEmpty((CharSequence)authnLogin)) {
                    client.setUsername(authnLogin);
                }
                if (StringUtils.isNotEmpty((CharSequence)authApiKey)) {
                    client.setApiKey(authApiKey);
                }
                LOGGER.debug("Using API KEY Authentication");
                accessToken = this.accessTokenProvider.getNewAccessToken(client);
            }
            if (accessToken == null) {
                LOGGER.debug("Using Account: " + this.obfuscateString(client.getAccount()));
                LOGGER.debug("Using ApplianceUrl: " + this.obfuscateString(client.getBasePath()));
                if (StringUtils.isNotEmpty((CharSequence)authnLogin)) {
                    LOGGER.debug("Using AuthnLogin: " + this.obfuscateString(authnLogin));
                }
                if (StringUtils.isNotEmpty((CharSequence)authApiKey)) {
                    LOGGER.debug("Using Authn API Key: " + this.obfuscateString(authApiKey));
                }
                if (StringUtils.isNotEmpty((CharSequence)sslCertificate)) {
                    LOGGER.debug("Using SSL Cert: " + this.obfuscateString(sslCertificate));
                } else if (StringUtils.isNotEmpty((CharSequence)certFile)) {
                    LOGGER.debug("Using SSL Cert File: " + this.obfuscateString(certFile));
                }
                if (StringUtils.isNotEmpty((CharSequence)jwtTokenPath)) {
                    LOGGER.debug("Using JWT Token Path: " + this.obfuscateString(jwtTokenPath));
                }
                if (StringUtils.isNotEmpty((CharSequence)authenticatorId)) {
                    LOGGER.debug("Using Authenticator ID: " + this.obfuscateString(authenticatorId));
                }
                LOGGER.error("Access token is null, Please enter proper environment variables.");
            } else {
                String token = accessToken.getHeaderValue();
                client.setAccessToken(token);
                Configuration.setDefaultApiClient((ApiClient)client);
                LOGGER.debug("Connection with conjur is successful");
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception encountered {} : {}", e.getClass(), (Object)e.getMessage());
        }
    }

    private String obfuscateString(String str) {
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{str}) && str.length() > 2) {
            int len = str.length();
            char first = str.charAt(0);
            char last = str.charAt(len - 1);
            String middle = "*******";
            return first + middle + last;
        }
        return str;
    }

    public static String getAccount(SecretsApi secretsApi) {
        ApiClient apiClient = secretsApi.getApiClient();
        return apiClient != null ? apiClient.getAccount() : ConjurConstant.CONJUR_ACCOUNT;
    }
}

