/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.springboot.processor;

import com.cyberark.conjur.sdk.ApiException;
import com.cyberark.conjur.sdk.endpoint.SecretsApi;
import com.cyberark.conjur.springboot.constant.ConjurConstant;
import com.cyberark.conjur.springboot.core.env.ConjurConnectionManager;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConjurRetrieveSecretService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConjurRetrieveSecretService.class);
    private final SecretsApi secretsApi;

    public ConjurRetrieveSecretService(SecretsApi secretsApi) {
        this.secretsApi = secretsApi;
    }

    public byte[] retriveMultipleSecretsForCustomAnnotation(String[] keys) {
        Object result = null;
        StringBuilder kind = new StringBuilder();
        for (int i = 0; i <= keys.length; ++i) {
            if (i < keys.length - 1) {
                kind.append("" + ConjurConstant.CONJUR_ACCOUNT + ":variable:" + keys[i] + ",");
                continue;
            }
            if (i != keys.length - 1) continue;
            kind.append("" + ConjurConstant.CONJUR_ACCOUNT + ":variable:" + keys[i] + "");
        }
        try {
            result = this.secretsApi.getSecrets(new String(kind));
        }
        catch (ApiException e) {
            LOGGER.error("Status code: " + e.getCode());
            LOGGER.error("Reason: " + e.getResponseBody());
            LOGGER.error(e.getMessage());
        }
        return this.processMultipleSecretResult(result);
    }

    public byte[] retriveSingleSecretForCustomAnnotation(String key) {
        byte[] result = null;
        try {
            String account = ConjurConnectionManager.getAccount(this.secretsApi);
            String secret = this.secretsApi.getSecret(account, "variable", key);
            result = secret != null ? secret.getBytes() : null;
        }
        catch (ApiException e) {
            LOGGER.error("Status code: " + e.getCode());
            LOGGER.error("Reason: " + e.getResponseBody());
            LOGGER.error(e.getMessage());
        }
        return result;
    }

    private byte[] processMultipleSecretResult(Object result) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] parts = result.toString().split(",");
        for (int j = 0; j < parts.length; ++j) {
            String[] splitted = parts[j].split("[:/=]");
            for (int i = 0; i < splitted.length; ++i) {
                map.put(splitted[3], splitted[4]);
            }
        }
        return ((Object)map).toString().getBytes();
    }
}

