/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.springboot.processor;

import com.cyberark.conjur.springboot.annotations.ConjurValue;
import com.cyberark.conjur.springboot.annotations.ConjurValues;
import com.cyberark.conjur.springboot.processor.ConjurRetrieveSecretService;
import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ReflectionUtils;

public class ConjurValueClassProcessor
implements BeanPostProcessor {
    private final ConjurRetrieveSecretService conjurRetrieveSecretService;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConjurValueClassProcessor.class);

    public ConjurValueClassProcessor(ConjurRetrieveSecretService conjurRetrieveSecretService) {
        this.conjurRetrieveSecretService = conjurRetrieveSecretService;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Class<?> managedBeanClass = bean.getClass();
        List fieldList = FieldUtils.getFieldsListWithAnnotation(managedBeanClass, ConjurValue.class);
        for (Field field : fieldList) {
            byte[] result;
            String[] variableId;
            if (field.isAnnotationPresent(ConjurValue.class)) {
                ReflectionUtils.makeAccessible((Field)field);
                variableId = field.getDeclaredAnnotation(ConjurValue.class).key();
                try {
                    result = this.conjurRetrieveSecretService.retriveSingleSecretForCustomAnnotation((String)variableId);
                    field.set(bean, result);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                }
                continue;
            }
            if (!field.isAnnotationPresent(ConjurValues.class)) continue;
            ReflectionUtils.makeAccessible((Field)field);
            variableId = field.getDeclaredAnnotation(ConjurValues.class).keys();
            try {
                result = this.conjurRetrieveSecretService.retriveMultipleSecretsForCustomAnnotation(variableId);
                field.set(bean, result);
            }
            catch (Exception e1) {
                LOGGER.error(e1.getMessage());
            }
        }
        return bean;
    }

    @Nullable
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

