/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.springboot.service;

import com.cyberark.conjur.sdk.ApiException;
import com.cyberark.conjur.sdk.endpoint.SecretsApi;
import com.cyberark.conjur.springboot.core.env.ConjurConfig;
import com.cyberark.conjur.springboot.core.env.ConjurConnectionManager;
import com.cyberark.conjur.springboot.service.PropertyProcessorChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomPropertySourceChain
extends PropertyProcessorChain {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomPropertySourceChain.class);
    private PropertyProcessorChain chain;
    private SecretsApi secretsApi;

    public CustomPropertySourceChain(String name) {
        super("customPropertySource");
        LOGGER.debug("Calling CustomPropertysource Chain ");
    }

    @Override
    public void setNextChain(PropertyProcessorChain nextChain) {
        this.chain = nextChain;
    }

    public void setSecretsApi(SecretsApi secretsApi) {
        this.secretsApi = secretsApi;
    }

    public String[] getPropertyNames() {
        return new String[0];
    }

    @Override
    public Object getProperty(String key) {
        byte[] result = null;
        key = ConjurConfig.getInstance().mapProperty(key);
        if (!(key.startsWith("spring") || key.startsWith("server") || key.startsWith("error") || key.startsWith("SPRING_UTIL") || key.startsWith("conjur") || key.startsWith("management") || key.startsWith("logging") || key.startsWith("kubernetes"))) {
            try {
                String account = ConjurConnectionManager.getAccount(this.secretsApi);
                String secretValue = this.secretsApi.getSecret(account, "variable", key);
                result = secretValue != null ? secretValue.getBytes() : null;
            }
            catch (ApiException ae) {
                this.logger.warn((Object)("Failed to get property from Conjur for: " + key));
                this.logger.warn((Object)("Reason: " + ae.getResponseBody()));
                this.logger.warn((Object)ae.getMessage());
            }
        }
        return result;
    }
}

