/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.springboot.annotations;

import com.cyberark.conjur.sdk.endpoint.SecretsApi;
import com.cyberark.conjur.springboot.annotations.ConjurPropertySource;
import com.cyberark.conjur.springboot.annotations.ConjurPropertySources;
import com.cyberark.conjur.springboot.core.env.ConjurConfig;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.MultiValueMap;

public class Registrar
implements ImportBeanDefinitionRegistrar,
BeanFactoryPostProcessor,
EnvironmentAware {
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        ConfigurableEnvironment env = (ConfigurableEnvironment)beanFactory.getBean(ConfigurableEnvironment.class);
        MutablePropertySources propertySources = env.getPropertySources();
        Collection beans = beanFactory.getBeansOfType(com.cyberark.conjur.springboot.core.env.ConjurPropertySource.class).values();
        for (com.cyberark.conjur.springboot.core.env.ConjurPropertySource ps : beans) {
            if (propertySources.contains(ps.getName())) continue;
            ps.setSecretsApi((SecretsApi)beanFactory.getBean(SecretsApi.class));
            ps.setConjurConfig((ConjurConfig)beanFactory.getBean(ConjurConfig.class));
            propertySources.addLast((PropertySource)ps);
        }
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (!registry.isBeanNameInUse(this.getClass().getName())) {
            registry.registerBeanDefinition(this.getClass().getName(), (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(this.getClass()).setRole(2).getBeanDefinition());
        }
        MultiValueMap attributesCont = importingClassMetadata.getAllAnnotationAttributes(ConjurPropertySources.class.getName(), false);
        MultiValueMap attributes = importingClassMetadata.getAllAnnotationAttributes(ConjurPropertySource.class.getName(), false);
        if (attributesCont != null) {
            for (Object attribs : (List)attributesCont.get((Object)"value")) {
                this.makeAndRegisterBean(registry, (String[])((LinkedHashMap)attribs).get("value"), ((AnnotationAttributes)attribs).getString("name"), importingClassMetadata);
            }
        }
        if (attributes != null) {
            for (Object valuesObj : (List)attributes.get((Object)"value")) {
                this.makeAndRegisterBean(registry, (String[])valuesObj, ((List)attributes.get((Object)"name")).size() != 0 ? (String)((List)attributes.get((Object)"name")).get(0) : "", importingClassMetadata);
            }
        }
    }

    private void makeAndRegisterBean(BeanDefinitionRegistry registry, String[] values, String name, AnnotationMetadata importingClassMetadata) {
        for (String value : values) {
            if (registry.containsBeanDefinition(com.cyberark.conjur.springboot.core.env.ConjurPropertySource.class.getName() + "-" + value + "@" + name)) continue;
            this.registerBeanDefinition(registry, com.cyberark.conjur.springboot.core.env.ConjurPropertySource.class, com.cyberark.conjur.springboot.core.env.ConjurPropertySource.class.getName() + "-" + value + "@" + name, value, name, importingClassMetadata);
        }
    }

    private void registerBeanDefinition(BeanDefinitionRegistry registry, Class<?> type, String name, String value, String vaultInfo, AnnotationMetadata importingClassMetadata) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(type);
        builder.addConstructorArgValue((Object)value);
        builder.addConstructorArgValue((Object)vaultInfo);
        builder.addConstructorArgValue((Object)importingClassMetadata);
        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
        registry.registerBeanDefinition(name, (BeanDefinition)beanDefinition);
    }
}

