/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.springboot.core.env;

import com.cyberark.conjur.springboot.domain.ConjurProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.ResourceUtils;

public class ConjurConfig
implements EnvironmentAware,
BeanFactoryPostProcessor {
    private static final Properties PROPS = new Properties();
    private static final Logger LOGGER = LoggerFactory.getLogger(ConjurConfig.class);
    private Environment environment;

    public String mapProperty(String name) {
        String mapped = PROPS.getProperty("conjur.mapping." + name);
        return mapped != null ? mapped : name;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        BindResult result = Binder.get((Environment)this.environment).bind("conjur", ConjurProperties.class);
        if (result.isBound()) {
            this.loadMappingProps((BindResult<ConjurProperties>)result);
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMappingProps(BindResult<ConjurProperties> result) {
        String mappingPath = ((ConjurProperties)result.get()).getMappingPath();
        InputStream propsFile = null;
        if (mappingPath != null) {
            try {
                File file = ResourceUtils.getFile((String)mappingPath);
                propsFile = Files.newInputStream(file.toPath(), new OpenOption[0]);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        } else {
            propsFile = ConjurConfig.class.getResourceAsStream("/conjur.properties");
        }
        if (propsFile != null) {
            try {
                PROPS.load(propsFile);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    propsFile.close();
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

