/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.springboot.core.env;

import com.cyberark.conjur.sdk.ApiException;
import com.cyberark.conjur.sdk.endpoint.SecretsApi;
import com.cyberark.conjur.springboot.core.env.ConjurConfig;
import com.cyberark.conjur.springboot.core.env.ConjurConnectionManager;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;

public class ConjurPropertySource
extends EnumerablePropertySource<Object> {
    private String vaultInfo = "";
    private String vaultPath = "";
    private SecretsApi secretsApi;
    private List<String> properties;
    private ConjurConfig conjurConfig;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConjurPropertySource.class);

    protected ConjurPropertySource(String vaultPath) {
        super(vaultPath + "@");
        this.vaultPath = vaultPath;
    }

    protected ConjurPropertySource(String vaultPath, String vaultInfo, AnnotationMetadata importingClassMetadata) throws ClassNotFoundException {
        super(vaultPath + "@" + vaultInfo);
        this.vaultPath = vaultPath;
        this.vaultInfo = vaultInfo;
        ArrayList<String> properties = new ArrayList<String>();
        Class annotatedClass = ClassUtils.forName((String)importingClassMetadata.getClassName(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        for (Field field : annotatedClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Value.class)) continue;
            String value = field.getAnnotation(Value.class).value();
            properties.add(value);
        }
        this.properties = properties;
    }

    public String[] getPropertyNames() {
        return new String[0];
    }

    public Object getProperty(String key) {
        byte[] result = null;
        if (!this.vaultPath.endsWith("/")) {
            this.vaultPath = this.vaultPath.concat("/");
        }
        if (this.propertyExists(key)) {
            key = this.conjurConfig.mapProperty(key);
            try {
                String account = ConjurConnectionManager.getAccount(this.secretsApi);
                String secretValue = this.secretsApi.getSecret(account, "variable", this.vaultPath + key);
                result = secretValue != null ? secretValue.getBytes() : null;
            }
            catch (ApiException ae) {
                LOGGER.warn("Failed to get property from Conjur for: " + key);
                LOGGER.warn("Reason: " + ae.getResponseBody());
                LOGGER.warn(ae.getMessage());
            }
        }
        return result;
    }

    public void setSecretsApi(SecretsApi secretsApi) {
        this.secretsApi = secretsApi;
    }

    private boolean propertyExists(String key) {
        return this.properties.stream().anyMatch(property -> property.contains(key));
    }

    public void setConjurConfig(ConjurConfig conjurConfig) {
        this.conjurConfig = conjurConfig;
    }
}

