/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.springboot.processor;

import com.cyberark.conjur.sdk.endpoint.SecretsApi;
import com.cyberark.conjur.springboot.core.env.ConjurConfig;
import com.cyberark.conjur.springboot.service.CustomPropertySourceChain;
import com.cyberark.conjur.springboot.service.DefaultPropertySourceChain;
import com.cyberark.conjur.springboot.service.PropertyProcessorChain;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class ConjurCloudProcessor
implements BeanPostProcessor,
InitializingBean,
EnvironmentAware {
    private ConfigurableEnvironment environment;
    private final SecretsApi secretsApi;
    private PropertyProcessorChain processorChain;
    private ConjurConfig conjurConfig;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public ConjurCloudProcessor(SecretsApi secretsApi, ConjurConfig conjurConfig) {
        this.secretsApi = secretsApi;
        this.conjurConfig = conjurConfig;
    }

    public void afterPropertiesSet() throws Exception {
        this.processorChain = new DefaultPropertySourceChain("DefaultPropertySource");
        CustomPropertySourceChain customPS = new CustomPropertySourceChain("CustomPropertySource");
        this.processorChain.setNextChain(customPS);
        customPS.setSecretsApi(this.secretsApi);
        customPS.setConjurConfig(this.conjurConfig);
        this.environment.getPropertySources().addLast((PropertySource)this.processorChain);
    }

    public void setEnvironment(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            this.environment = (ConfigurableEnvironment)environment;
        }
    }
}

