/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.springboot.processor;

import com.cyberark.conjur.sdk.ApiException;
import com.cyberark.conjur.springboot.annotations.ConjurValue;
import com.cyberark.conjur.springboot.annotations.ConjurValues;
import com.cyberark.conjur.springboot.core.env.ConjurConfig;
import com.cyberark.conjur.springboot.processor.ConjurRetrieveSecretService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ReflectionUtils;

public class ConjurValueClassProcessor
implements BeanPostProcessor {
    private final ConjurRetrieveSecretService conjurRetrieveSecretService;
    private ConjurConfig conjurConfig;
    private ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private static final Logger LOGGER = LoggerFactory.getLogger(ConjurValueClassProcessor.class);

    public ConjurValueClassProcessor(ConjurRetrieveSecretService conjurRetrieveSecretService, ConjurConfig conjurConfig) {
        this.conjurRetrieveSecretService = conjurRetrieveSecretService;
        this.conjurConfig = conjurConfig;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Class<?> managedBeanClass = bean.getClass();
        List fieldList = FieldUtils.getAllFieldsList(managedBeanClass);
        for (Field field : fieldList) {
            String[] credentialsArr;
            String credentialToMap;
            ArrayList<String> credentialsList = new ArrayList<String>();
            if (field.isAnnotationPresent(ConjurValue.class)) {
                ReflectionUtils.makeAccessible((Field)field);
                String credentialId = field.getDeclaredAnnotation(ConjurValue.class).key();
                credentialToMap = this.conjurConfig.mapProperty(credentialId);
                if (StringUtils.isNotBlank((CharSequence)credentialToMap)) {
                    credentialId = credentialToMap;
                }
                try {
                    byte[] result = this.conjurRetrieveSecretService.retriveSingleSecretForCustomAnnotation(credentialId);
                    this.setField(field, bean, result);
                }
                catch (ApiException ex) {
                    LOGGER.warn("Data Not found for Single Retrieval for key : " + ex.getMessage());
                }
                continue;
            }
            if (!field.isAnnotationPresent(ConjurValues.class)) continue;
            ReflectionUtils.makeAccessible((Field)field);
            for (String key : credentialsArr = field.getDeclaredAnnotation(ConjurValues.class).keys()) {
                credentialToMap = this.conjurConfig.mapProperty(key);
                if (!StringUtils.isNotBlank((CharSequence)credentialToMap)) continue;
                credentialsList.add(credentialToMap);
            }
            try {
                if (credentialsList.isEmpty()) continue;
                String[] credentialArr = credentialsList.toArray(new String[0]);
                byte[] result = this.conjurRetrieveSecretService.retriveMultipleSecretsForCustomAnnotation(credentialArr);
                this.setField(field, bean, result);
            }
            catch (ApiException ex) {
                if (ex.getCode() != 404 && !ex.getMessage().equalsIgnoreCase("Not Found")) continue;
                try {
                    byte[] finalResult = this.retrieveSecretsForCredential(credentialsList).toByteArray();
                    if (finalResult.length > 0) {
                        this.setField(field, bean, finalResult);
                    }
                    this.outputStream.close();
                }
                catch (IOException ioe) {
                    LOGGER.error("Error while closing  ConjurValues outputStream " + ioe.getMessage());
                }
            }
        }
        return bean;
    }

    @Nullable
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private void setField(Field field, Object bean, byte[] finalResult) {
        try {
            if (finalResult != null) {
                field.set(bean, finalResult);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOGGER.error("Error setting field value " + e.getMessage());
        }
    }

    private ByteArrayOutputStream retrieveSecretsForCredential(List<String> credentialsList) {
        if (!credentialsList.isEmpty()) {
            String secretVal = "";
            boolean firstValue = false;
            int counter = 0;
            try {
                for (String value : credentialsList) {
                    byte[] result = this.conjurRetrieveSecretService.retriveSingleSecretForCustomAnnotation(value);
                    String[] tmp2 = value.split("/");
                    String key = tmp2[tmp2.length - 1];
                    if (result != null) {
                        if (!firstValue && this.outputStream.size() <= 0) {
                            String keyValuePair = key + "=" + new String(result);
                            this.outputStream.write(keyValuePair.getBytes());
                            firstValue = true;
                        } else {
                            secretVal = "," + key + "=" + new String(result);
                            this.outputStream.write(secretVal.getBytes());
                        }
                    }
                    ++counter;
                }
            }
            catch (ApiException ae) {
                LOGGER.warn("Data Not found for Multiple/Bulk Retrieval for key(s)" + ae.getMessage());
                ArrayList<String> processList = new ArrayList();
                processList = credentialsList.subList(counter + 1, credentialsList.size());
                this.retrieveSecretsForCredential(processList);
            }
            catch (IOException ioe) {
                LOGGER.error("Error while processing ConjurValues outputStream " + ioe.getMessage());
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("Error while closing  ConjurValues outputStream " + e.getMessage());
                }
            }
        }
        return this.outputStream;
    }
}

