/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.springboot.service;

import com.cyberark.conjur.sdk.ApiException;
import com.cyberark.conjur.sdk.endpoint.SecretsApi;
import com.cyberark.conjur.springboot.core.env.ConjurConfig;
import com.cyberark.conjur.springboot.core.env.ConjurConnectionManager;
import com.cyberark.conjur.springboot.service.PropertyProcessorChain;
import com.google.gson.Gson;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomPropertySourceChain
extends PropertyProcessorChain {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomPropertySourceChain.class);
    private PropertyProcessorChain chain;
    private SecretsApi secretsApi;
    private ConjurConfig conjurConfig;

    public CustomPropertySourceChain(String name) {
        super("customPropertySource");
        LOGGER.debug("Calling CustomPropertysource Chain ");
    }

    @Override
    public void setNextChain(PropertyProcessorChain nextChain) {
        this.chain = nextChain;
    }

    public void setSecretsApi(SecretsApi secretsApi) {
        this.secretsApi = secretsApi;
    }

    public String[] getPropertyNames() {
        return new String[0];
    }

    public void setConjurConfig(ConjurConfig conjurConfig) {
        this.conjurConfig = conjurConfig;
    }

    @Override
    public Object getProperty(String key) {
        String secretValue;
        block12: {
            StringBuilder kind = new StringBuilder();
            Gson gson = new Gson();
            secretValue = null;
            ArrayList<String> list = new ArrayList<String>();
            if (!((key = this.conjurConfig.mapProperty(key)).startsWith("spring") || key.startsWith("server") || key.startsWith("error") || key.startsWith("SPRING_UTIL") || key.startsWith("conjur") || key.startsWith("management") || key.startsWith("logging") || key.startsWith("kubernetes"))) {
                String account = ConjurConnectionManager.getAccount(this.secretsApi);
                if (key.contains(",")) {
                    String[] keys = key.split(",");
                    String credentialId = "";
                    if (keys.length > 0) {
                        credentialId = this.conjurConfig.mapProperty(keys[0]);
                        kind.append(account + ":variable:" + credentialId);
                        for (int i = 1; i < keys.length; ++i) {
                            credentialId = this.conjurConfig.mapProperty(keys[i]);
                            kind.append("," + account + ":variable:" + credentialId);
                        }
                    }
                    try {
                        secretValue = gson.toJson(this.secretsApi.getSecrets(new String(kind)), Object.class);
                        secretValue = this.processMultipleSecretResult(secretValue);
                    }
                    catch (ApiException ex) {
                        if (ex.getCode() == 404 || ex.getMessage().equalsIgnoreCase("Not Found")) {
                            for (int i = 0; i < keys.length; ++i) {
                                try {
                                    credentialId = this.conjurConfig.mapProperty(keys[i]);
                                    secretValue = this.secretsApi.getSecret(account, "variable", credentialId);
                                    if (secretValue == null) continue;
                                    list.add(secretValue);
                                    continue;
                                }
                                catch (ApiException e) {
                                    LOGGER.warn("Status code CustomPropery: " + ex.getCode());
                                    LOGGER.warn("Reason: " + ex.getResponseBody());
                                    LOGGER.warn(ex.getMessage());
                                }
                            }
                            secretValue = gson.toJson((Object)list.toArray(new Object[list.size()]), Object.class);
                        }
                        break block12;
                    }
                }
                try {
                    secretValue = this.secretsApi.getSecret(account, "variable", key);
                }
                catch (ApiException ex) {
                    LOGGER.warn("Status code: " + ex.getCode());
                    LOGGER.warn("Reason: " + ex.getResponseBody());
                    LOGGER.warn(ex.getMessage());
                }
            }
        }
        return secretValue;
    }

    private String processMultipleSecretResult(Object result) {
        String resultString = result.toString().replaceAll("^\\{|\\}$", "");
        String[] pairs = resultString.split("\",\"");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pairs.length; ++i) {
            String[] parts = pairs[i].split("\":\"");
            if (parts.length < 2) continue;
            String key = parts[0].replaceAll("^\"|\"$", "");
            String value = parts[1].replaceAll("^\"|\"$", "");
            String[] keyParts = key.split("/");
            String finalKey = keyParts[keyParts.length - 1];
            sb.append(finalKey).append("=").append(value);
            if (i >= pairs.length - 1) continue;
            sb.append(",");
        }
        String finalResult = sb.toString();
        return finalResult;
    }
}

