/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.util.rs;

import com.cyberark.conjur.util.rs.JsonReadable;
import com.google.gson.Gson;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;

@Provider
public class JsonBodyReader
implements MessageBodyReader<Object> {
    private final Set<Class<?>> readableClasses = Collections.synchronizedSet(new HashSet());

    public JsonBodyReader registerClass(Class<?> klass) {
        this.readableClasses.add(klass);
        return this;
    }

    public boolean isReadable(Class<?> klass, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MediaType.APPLICATION_JSON_TYPE.isCompatible(mediaType) && this.isReadable(klass);
    }

    public Object readFrom(Class<Object> klass, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream bodyInputStream) throws IOException, WebApplicationException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(bodyInputStream));
        return new Gson().fromJson((Reader)reader, klass);
    }

    private boolean isReadable(Class<?> klass) {
        if (this.readableClasses.contains(klass)) {
            return true;
        }
        if (klass.getAnnotation(JsonReadable.class) != null) {
            this.readableClasses.add(klass);
            return true;
        }
        return false;
    }
}

