/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.api.clients;

import com.cyberark.conjur.api.AuthnProvider;
import com.cyberark.conjur.api.Credentials;
import com.cyberark.conjur.api.Endpoints;
import com.cyberark.conjur.api.Token;
import com.cyberark.conjur.util.EncodeUriComponent;
import com.cyberark.conjur.util.rs.HttpBasicAuthFilter;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import javax.net.ssl.SSLContext;

public class AuthnClient
implements AuthnProvider {
    private WebTarget login;
    private WebTarget authenticate;
    private final Endpoints endpoints;
    private String apiKey;

    public AuthnClient(Credentials credentials, Endpoints endpoints) {
        this(credentials, endpoints, null);
    }

    public AuthnClient(Credentials credentials, Endpoints endpoints, SSLContext sslContext) {
        this.endpoints = endpoints;
        this.init(credentials.getUsername(), credentials.getPassword(), sslContext);
        this.apiKey = credentials.getPassword();
        if (credentials.getAuthnUrl().endsWith("/authn") && !credentials.getUsername().startsWith("host/")) {
            this.apiKey = this.login();
        }
    }

    @Override
    public Token authenticate() {
        Response res = (Response)this.authenticate.request(new String[]{"application/json"}).post(Entity.text((Object)this.apiKey), Response.class);
        this.validateResponse(res);
        return Token.fromJson((String)res.readEntity(String.class));
    }

    @Override
    public Token authenticate(boolean useCachedToken) {
        return this.authenticate();
    }

    public String login() {
        Response res = (Response)this.login.request(new String[]{"text/plain"}).get(Response.class);
        this.validateResponse(res);
        return (String)res.readEntity(String.class);
    }

    private void init(String username, String password, SSLContext sslContext) {
        ClientBuilder builder = (ClientBuilder)ClientBuilder.newBuilder().register((Object)new HttpBasicAuthFilter(username, password));
        if (sslContext != null) {
            builder.sslContext(sslContext);
        }
        Client client = builder.build();
        WebTarget root = client.target(this.endpoints.getAuthnUri());
        this.login = root.path("login");
        this.authenticate = root.path(EncodeUriComponent.encodeUriComponent(username)).path("authenticate");
    }

    private void validateResponse(Response response) {
        int status = response.getStatus();
        if (status < 200 || status >= 400) {
            String errorMessage = String.format("Error code: %d, Error message: %s", status, response.readEntity(String.class));
            throw new WebApplicationException(errorMessage, status);
        }
    }
}

