/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.api;

import com.cyberark.conjur.util.Properties;

public class Credentials {
    private String username;
    private String password;
    private String authnUrl;

    public Credentials(String username, String password) {
        this(username, password, Properties.getMandatoryProperty("CONJUR_AUTHN_URL", Properties.getMandatoryProperty("CONJUR_APPLIANCE_URL") + "/authn"));
    }

    public Credentials(String username, String password, String authnUrl) {
        this.username = username;
        this.password = password;
        this.authnUrl = authnUrl;
    }

    public static Credentials fromSystemProperties() {
        String login = Properties.getMandatoryProperty("CONJUR_AUTHN_LOGIN");
        String apiKey = Properties.getMandatoryProperty("CONJUR_AUTHN_API_KEY");
        String applianceUrl = Properties.getMandatoryProperty("CONJUR_APPLIANCE_URL");
        String authnUrl = Properties.getMandatoryProperty("CONJUR_AUTHN_URL", applianceUrl + "/authn");
        return new Credentials(login, apiKey, authnUrl);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getAuthnUrl() {
        return this.authnUrl;
    }

    public String toString() {
        return this.username + ":" + this.password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Credentials)) {
            return false;
        }
        Credentials that = (Credentials)o;
        if (!this.password.equals(that.getPassword())) {
            return false;
        }
        return this.username.equals(that.getUsername());
    }

    public int hashCode() {
        int result = this.username.hashCode();
        result = 31 * result + this.password.hashCode();
        return result;
    }
}

