/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.authsdk.cache;

import com.cybersource.authsdk.cache.Identity;
import com.cybersource.authsdk.core.ConfigException;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.log.Log4j;
import com.cybersource.authsdk.util.Utility;
import java.io.File;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Logger;

public class Cache {
    public static boolean isCache = false;
    private boolean isTimeStamp;
    private MerchantConfig merchantConfig;
    public static long lastModifiedTime;
    private Identity identity = new Identity();
    public static ConcurrentHashMap<String, Identity> cacheP12;
    private X509Certificate x509Certificate;
    private RSAPrivateKey rsaPrivateKey;
    private String merchantID;
    private String accessToken;
    private String refreshToken;
    Logger logger;

    public void setX509Certificate(X509Certificate x509Certificate) {
        this.x509Certificate = x509Certificate;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRsaPrivateKey(RSAPrivateKey rsaPrivateKey) {
        this.rsaPrivateKey = rsaPrivateKey;
    }

    public RSAPrivateKey getRsaPrivateKey() {
        return this.rsaPrivateKey;
    }

    public X509Certificate getX509Certificate() {
        return this.x509Certificate;
    }

    public Cache(MerchantConfig merchantConfig) {
        this.merchantConfig = merchantConfig;
        this.logger = Log4j.getInstance(this.merchantConfig);
        this.merchantID = merchantConfig.getMerchantID();
        isCache = cacheP12.isEmpty();
    }

    public void setP12FileDetailsInCache() throws ConfigException {
        if (cacheP12.isEmpty()) {
            this.setUpP12Cache();
        } else {
            this.isTimeStamp = this.isLastModifiedTimeP12();
            if (this.isTimeStamp) {
                this.retriveP12DataFromCache();
            } else {
                this.setUpP12Cache();
            }
        }
    }

    public void setUpP12Cache() throws ConfigException {
        this.identity.setLastModifiedDate(this.getLastModifiedFileP12());
        this.identity.setX509(this.x509Certificate);
        this.identity.setRsaPrivateKey(this.rsaPrivateKey);
        String tempMerchantID = this.merchantConfig.getMerchantID();
        cacheP12.put(tempMerchantID, this.identity);
        lastModifiedTime = this.merchantConfig.getKeyFile().lastModified();
    }

    public void retriveP12DataFromCache() {
        Identity tempIdentity = cacheP12.get(this.merchantID);
        if (tempIdentity != null) {
            this.x509Certificate = tempIdentity.getX509();
            this.rsaPrivateKey = tempIdentity.getRsaPrivateKey();
        }
    }

    public boolean isLastModifiedTimeP12() {
        Identity tempIdentity = cacheP12.get(this.merchantID);
        if (tempIdentity != null) {
            long tempLastModifiedTime = tempIdentity.getLastModifiedDate();
            return lastModifiedTime == tempLastModifiedTime;
        }
        return false;
    }

    public long getLastModifiedFileP12() {
        try {
            File f = new File(this.merchantConfig.getKeyFile().getAbsolutePath());
            return f.lastModified();
        }
        catch (Exception e) {
            Utility.log(this.logger, e);
            return (Long)null;
        }
    }

    static {
        cacheP12 = new ConcurrentHashMap();
    }
}

