/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.authsdk.core;

import com.cybersource.authsdk.core.ConfigException;
import com.cybersource.authsdk.log.Log4j;
import com.cybersource.authsdk.util.GlobalLabelParameters;
import com.cybersource.authsdk.util.PropertiesUtil;
import com.cybersource.authsdk.util.Utility;
import java.io.File;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class MerchantConfig {
    private Properties props;
    private String keysDirectory;
    private String keyAlias;
    private String keyPass;
    private String keyType;
    private String keyFilename;
    private String password;
    private String accessToken;
    private String refreshToken;
    private boolean enableLog;
    private int timeout;
    private boolean useProxy = false;
    private String proxyAddress;
    private int proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private String recipientID;
    private String effectivePassword;
    private String requestData;
    private String runEnvironment;
    private File keyFile;
    private String clientId;
    private String clientSecret;
    private boolean enableClientCert;
    private String clientCertFile;
    private String clientCertDirectory;
    private String clientCertPassword;
    private boolean isRequestType = false;
    public static boolean isSetMerchantDetails = true;
    private String merchantKeyId;
    private String merchantSecretKey;
    private String merchantID;
    private String portfolioID;
    private boolean useMetaKey;
    private String url;
    private String requestTarget;
    private String authenticationType;
    private boolean sendToProduction;
    private String getID;
    private String requestHost;
    private String responseMessage;
    private String responseCode;
    private String vcCorelationID;
    private String requestType;
    private boolean retryEnabled;
    private long retryDelay;
    private boolean isRequestJson = true;
    private Logger log;
    private String solutionId;
    private boolean logSignedData;
    private String logDirectory;
    private String logFilename;
    private String logMaximumSize;
    private String date;
    private String requestJsonPath;
    private String urlRequestHeader;

    public void setRunEnvironment(String runEnvironment) {
        this.runEnvironment = runEnvironment;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public String getProxyAddress() {
        return this.proxyAddress;
    }

    public void setProxyAddress(String proxyAddress) {
        this.proxyAddress = proxyAddress;
    }

    public boolean isRequestJson() {
        return this.isRequestJson;
    }

    public boolean isUseProxyEnabled() {
        return this.useProxy;
    }

    public boolean isUseMetaKeyEnabled() throws ConfigException {
        return this.getBooleanProperty(this.merchantID, "useMetaKey", false);
    }

    public String getRequestData() {
        try {
            if (this.getRequestJsonPath().equalsIgnoreCase("not required")) {
                return this.requestData;
            }
            if (this.getRequestJsonPath() != null && !this.getRequestJsonPath().isEmpty()) {
                this.requestData = PropertiesUtil.getJsonInput(this.getRequestJsonPath());
            }
        }
        catch (Exception e) {
            Utility.log(this.log, "File not found, Entered path/file name :: ", this.getRequestJsonPath(), Level.FATAL);
            Utility.log(this.log, e);
            return null;
        }
        return this.requestData;
    }

    public void setRequestData(String requestData) {
        this.requestData = requestData;
    }

    public String getVcCorelationID() {
        return this.vcCorelationID;
    }

    public void setVcCorelationID(String vcCorelationID) {
        this.vcCorelationID = vcCorelationID;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(String responseMessage) throws NullPointerException {
        this.responseMessage = responseMessage;
    }

    public String getUrlRequestHeader() {
        return this.urlRequestHeader;
    }

    public void setUrlRequestHeader(String urlRequestHeader) {
        this.urlRequestHeader = urlRequestHeader;
    }

    public String getRequestHost() {
        return this.requestHost;
    }

    public String getRequestJsonPath() {
        return this.requestJsonPath;
    }

    public void setRequestJsonPath(String requestJsonPath) {
        this.requestJsonPath = requestJsonPath;
    }

    public String getSolutionId() {
        return this.solutionId;
    }

    public void setSolutionId(String solutionId) {
        this.solutionId = solutionId;
    }

    public String getGetID() {
        return this.getID;
    }

    public String getMerchantSecretKey() {
        return this.merchantSecretKey;
    }

    public String getMerchantKeyId() {
        return this.merchantKeyId;
    }

    public String getDate() {
        return this.date;
    }

    public String getMerchantID() {
        return this.merchantID;
    }

    public String getPortfolioID() {
        return this.portfolioID;
    }

    public void setRecipientID(String recipientID) {
        this.recipientID = recipientID;
    }

    public String getRecipientID() {
        return this.recipientID;
    }

    public String getKeysDirectory() {
        return this.keysDirectory;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyPass(String keyPass) {
        this.keyPass = keyPass;
    }

    public String getKeyPass() {
        return this.keyPass;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setEnableClientCert(boolean enableClientCert) {
        this.enableClientCert = enableClientCert;
    }

    public boolean getEnableClientCert() {
        return this.enableClientCert;
    }

    public void setClientCertFile(String clientCertFile) {
        this.clientCertFile = clientCertFile;
    }

    public String getClientCertFile() {
        return this.clientCertFile;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientCertPassword(String clientCertPassword) {
        this.clientCertPassword = clientCertPassword;
    }

    public String getClientCertPassword() {
        return this.clientCertPassword;
    }

    public void setClientCertDirectory(String clientCertDirectory) {
        this.clientCertDirectory = clientCertDirectory;
    }

    public String getClientCertDirectory() {
        return this.clientCertDirectory;
    }

    public boolean getrequestJson() {
        return false;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public void setMerchantID(String merchantID) {
        this.merchantID = merchantID;
    }

    public void setPortfolioID(String portfolioID) {
        this.portfolioID = portfolioID;
    }

    public String getKey() {
        return this.keyPass;
    }

    public String getKeyType() {
        return this.keyType != null ? this.keyType : "p12";
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public boolean getSendToProduction() {
        return this.sendToProduction;
    }

    public String getKeyFilename() {
        return this.keyFilename;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getRequestTarget() {
        return this.requestTarget;
    }

    public void setRequestTarget(String requestTarget) {
        this.requestTarget = requestTarget;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getEnableLog() {
        return this.enableLog;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setKeysDirectory(String keysDirectory) {
        this.keysDirectory = keysDirectory;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public void setKeyFilename(String keyFilename) {
        this.keyFilename = keyFilename;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void setEffectivePassword(String effectivePassword) {
        this.effectivePassword = effectivePassword;
    }

    public void setSendToProduction(boolean sendToProduction) {
        this.sendToProduction = sendToProduction;
    }

    public void setGetID(String getID) {
        this.getID = getID;
    }

    public void setRequestHost(String requestHost) {
        this.requestHost = requestHost;
    }

    public void setRequestJson(boolean isRequestJson) {
        this.isRequestJson = isRequestJson;
    }

    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    public void setLogSignedData(boolean logSignedData) {
        this.logSignedData = logSignedData;
    }

    public void setLogMaximumSize(String logMaximumSize) {
        this.logMaximumSize = logMaximumSize;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setEnableLog(boolean enableLog) {
        this.enableLog = enableLog;
    }

    public boolean getLogSignedData() {
        return this.logSignedData;
    }

    public String getLogDirectory() {
        return this.logDirectory;
    }

    public String getLogFilename() {
        return this.logFilename;
    }

    public String getLogMaximumSize() {
        return this.logMaximumSize;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword != null ? this.proxyPassword : "";
    }

    public String getEffectivePassword() {
        return this.effectivePassword;
    }

    public void setLogFilename(String logFilename) {
        this.logFilename = logFilename;
    }

    public MerchantConfig() throws ConfigException {
    }

    public void setIsRequestType(boolean b) {
        this.isRequestType = b;
    }

    public boolean isRetryEnabled() {
        return this.retryEnabled;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryEnabled(boolean retryEnabled) {
        this.retryEnabled = retryEnabled;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }

    public MerchantConfig(Properties _props) throws ConfigException {
        if (_props != null) {
            this.props = _props;
            this.merchantID = this.props.getProperty("merchantID");
            this.date = this.date();
            this.setMerchantDetails();
        }
    }

    public boolean validateMerchantDetails(Logger logger) throws ConfigException {
        this.log = logger;
        this.isRequestType = this.checkRequestType();
        boolean isMerchantId = true;
        boolean isCheckMerchantSecertKey = false;
        boolean isCheckMerchantKeyId = false;
        boolean isGetKeyAlias = false;
        boolean isCheckKeyPassword = false;
        boolean isCheckKeyFile = false;
        boolean isCheckLogMaxSize = true;
        boolean isMerchantDetailStatus = false;
        this.checkAuthenticationType();
        if (this.authenticationType.equalsIgnoreCase("HTTP_Signature")) {
            isMerchantId = this.checkMerchantId();
            isCheckMerchantSecertKey = this.checkMerchantSecertKey();
            isCheckMerchantKeyId = this.checkMerchantKeyId();
        } else if (this.authenticationType.equalsIgnoreCase("JWT") || this.authenticationType.equalsIgnoreCase("JWE")) {
            isMerchantId = this.checkMerchantId();
            isGetKeyAlias = this.checkKeyAlias();
            isCheckKeyPassword = this.checkKeyPassword();
            isCheckKeyFile = this.checkKeyFile();
        }
        boolean isCheckJsonPath = this.checkJsonPath(this.getRequestJsonPath());
        isCheckLogMaxSize = this.checkLogMaxSizeAndFolder();
        boolean isCheckRunEnvironment = this.checkRunEvironment();
        if (this.authenticationType.equalsIgnoreCase("HTTP_Signature")) {
            isMerchantDetailStatus = isMerchantId && isCheckMerchantSecertKey && isCheckMerchantKeyId && isCheckJsonPath && isCheckLogMaxSize && isCheckRunEnvironment && this.isRequestType && isSetMerchantDetails;
        } else if (this.authenticationType.equalsIgnoreCase("JWT")) {
            isMerchantDetailStatus = isMerchantId && isGetKeyAlias && isCheckKeyPassword && isCheckKeyFile && isCheckJsonPath && isCheckLogMaxSize && isCheckRunEnvironment && this.isRequestType && isSetMerchantDetails;
        } else if (this.authenticationType.equalsIgnoreCase("OAuth") || this.authenticationType.equalsIgnoreCase("MutualAuth")) {
            isMerchantDetailStatus = isCheckJsonPath && isCheckLogMaxSize && isCheckRunEnvironment && this.isRequestType;
        }
        return isMerchantDetailStatus;
    }

    public boolean checkRequestType() throws ConfigException {
        if (this.requestType.equalsIgnoreCase("PUT") || this.requestType.equalsIgnoreCase("GET") || this.requestType.equalsIgnoreCase("POST") || this.requestType.equalsIgnoreCase("DELETE") || this.requestType.equalsIgnoreCase("PATCH")) {
            return true;
        }
        Utility.log(this.log, "Invalid Request Type :: ", this.requestType, Level.ERROR);
        throw new ConfigException("Invalid Request Type :: ");
    }

    public boolean checkKeyPassword() throws ConfigException {
        if (this.keyPass == null || this.keyPass.isEmpty()) {
            this.keyPass = this.merchantID;
            Utility.log(this.log, "KeyPassword Empty/Null. Assigning merchantID value", "", Level.ERROR);
        }
        return true;
    }

    public boolean checkRunEvironment() throws ConfigException {
        boolean runEnvironment = false;
        if (this.runEnvironment == null || this.runEnvironment.isEmpty()) {
            Utility.log(this.log, "Run Environment value is missing in cybs.properties", "", Level.ERROR);
            throw new ConfigException("Run Environment value is missing in cybs.properties");
        }
        if (GlobalLabelParameters.OLD_RUN_ENVIRONMENT_CONSTANTS.contains(this.runEnvironment.toUpperCase())) {
            throw new ConfigException("The value provided for this field `RunEnvironment` has been deprecated and will not be used anymore.\n\nPlease refer to the README file [ https://github.com/CyberSource/cybersource-rest-samples-java/blob/master/README.md ] for information about the new values that are accepted.");
        }
        runEnvironment = true;
        return runEnvironment;
    }

    public boolean checkMerchantKeyId() throws ConfigException {
        if (this.merchantKeyId == null || this.merchantKeyId.isEmpty()) {
            Utility.log(this.log, "Merchant KeyID missing/null, check cybs.properties", "", Level.ERROR);
            throw new ConfigException("Merchant KeyID missing/null, check cybs.properties");
        }
        return true;
    }

    public void setMerchantKeyId(String merchantKeyId) {
        this.merchantKeyId = merchantKeyId;
    }

    public boolean checkMerchantSecertKey() throws ConfigException {
        if (this.merchantSecretKey == null || this.merchantSecretKey.isEmpty()) {
            Utility.log(this.log, "Merchant Secret Key missing/null, check cybs.properties", "", Level.ERROR);
            throw new ConfigException("Merchant Secret Key missing/null, check cybs.properties");
        }
        return true;
    }

    public void setMerchantSecretKey(String merchantsecretKey) {
        this.merchantSecretKey = merchantsecretKey;
    }

    public boolean checkLogMaxSizeAndFolder() throws ConfigException {
        if (this.logDirectory == null || this.logDirectory.isEmpty()) {
            this.logDirectory = "log";
            Utility.log(this.log, "No log directory, setting default directory path.", "", Level.ERROR);
        }
        return this.getLogFile();
    }

    public boolean checkJsonPath(String jsonPath) throws ConfigException {
        File f = null;
        boolean check = true;
        if (!this.isRequestType) {
            return false;
        }
        if (this.requestType.equalsIgnoreCase("GET") || this.requestType.equalsIgnoreCase("DELETE")) {
            return check;
        }
        if (jsonPath.equalsIgnoreCase("not required")) {
            return check;
        }
        if (jsonPath == null || jsonPath.isEmpty()) {
            Utility.log(this.log, "Request Json File Missing/Null", "", Level.ERROR);
            check = false;
            throw new ConfigException("Request Json File Missing/Null");
        }
        f = new File(jsonPath);
        if (!f.exists()) {
            Utility.log(this.log, "Request Json File missing. File Path :: ", f.getAbsolutePath(), Level.ERROR);
            check = false;
            throw new ConfigException("Request Json File missing. File Path :: ");
        }
        if (!f.canRead()) {
            Utility.log(this.log, "File cannot be read permission denied :: ", f.getAbsolutePath(), Level.ERROR);
            check = false;
            throw new ConfigException("File cannot be read permission denied :: ");
        }
        this.isRequestJson = true;
        return check;
    }

    public boolean checkKeyAlias() throws ConfigException {
        if (this.keyAlias == null || this.keyAlias.isEmpty()) {
            Utility.log(this.log, "KeyAlias Empty/Null. Assigning merchantID value :: ", this.merchantID, Level.ERROR);
            this.keyAlias = this.merchantID;
        } else if (!this.keyAlias.equalsIgnoreCase(this.merchantID)) {
            this.keyAlias = this.merchantID;
            Utility.log(this.log, "KeyAlias Mismatch. Assigning merchantID value ", "", Level.ERROR);
        }
        return true;
    }

    public void setMerchantDetails() throws ConfigException {
        this.authenticationType = this.getProperty(this.merchantID, "authenticationType");
        this.merchantID = this.getProperty(this.merchantID, "merchantID");
        this.useMetaKey = this.getBooleanProperty(this.merchantID, "useMetaKey", false);
        this.enableClientCert = this.getBooleanProperty(this.merchantID, "enableClientCert", false);
        if (this.useMetaKey) {
            this.portfolioID = this.getProperty(this.merchantID, "portfolioID");
            if (StringUtils.isEmpty((String)this.portfolioID)) {
                throw new ConfigException("Portfolio ID is mandatory");
            }
        }
        if (this.enableClientCert) {
            if (this.props.getProperty("clientCertFile") == null) {
                throw new ConfigException("Client Cert is mandatory");
            }
            this.clientCertFile = this.props.getProperty("clientCertFile");
            if (this.props.getProperty("clientCertPassword") == null) {
                throw new ConfigException("Client Cert Password is mandatory");
            }
            this.clientCertPassword = this.props.getProperty("clientCertPassword");
            if (this.props.getProperty("clientCertDirectory") == null) {
                throw new ConfigException("Client Cert Directory is mandatory");
            }
            this.clientCertDirectory = this.props.getProperty("clientCertDirectory");
        }
        this.logDirectory = this.props.getProperty("logDirectory") == null ? "log" : this.getProperty(this.merchantID, "logDirectory").trim();
        this.logFilename = this.props.getProperty("logFilename") == null ? "cybs" : this.getProperty(this.merchantID, "logFilename").trim();
        this.logMaximumSize = this.props.getProperty("logMaximumSize") == null ? "5K" : this.getProperty(this.merchantID, "logMaximumSize").trim();
        if (this.authenticationType != null && this.authenticationType.equalsIgnoreCase("JWT")) {
            this.keysDirectory = this.props.getProperty("keysDirectory") == null ? "src/main/resources" : this.getProperty(this.merchantID, "keysDirectory").trim();
            if (this.props.getProperty("keyAlias") == null) {
                Utility.log(this.log, "KeyAlias Empty/Null. Assigning merchantID value :: ", this.merchantID, Level.ERROR);
                this.keyAlias = this.merchantID;
            } else {
                this.keyAlias = this.getProperty(this.merchantID, "keyAlias").trim();
            }
            this.keyPass = this.props.getProperty("keyPass") == null ? this.merchantID : this.getProperty(this.merchantID, "keyPass");
            this.keyFilename = this.props.getProperty("keyFileName") == null ? this.merchantID : this.getProperty(this.merchantID, "keyFileName").trim();
        }
        this.enableLog = this.checkBooleanLogValue(this.merchantID, "enableLog");
        this.timeout = this.getIntegerProperty(this.merchantID, "timeout", 130);
        this.useProxy = this.getBooleanProperty(this.merchantID, "useProxy", false);
        if (this.useProxy) {
            this.proxyAddress = this.getProperty(this.merchantID, "proxyAddress");
            if (this.getProperty(this.merchantID, "proxyPort") == null) {
                throw new ConfigException("Proxy Port is necessary for using Proxy");
            }
            this.proxyPort = Integer.parseInt(this.getProperty(this.merchantID, "proxyPort"));
            this.proxyUser = this.getProperty(this.merchantID, "proxyUser");
            this.proxyPassword = this.getProperty(this.merchantID, "proxyPassword");
        }
        if (this.authenticationType != null && this.authenticationType.equalsIgnoreCase("HTTP_Signature")) {
            if (this.props.getProperty("merchantKeyId") == null) {
                throw new ConfigException("Merchant KeyId is mandatory");
            }
            this.merchantKeyId = this.getProperty(this.merchantID, "merchantKeyId").trim();
            if (this.props.getProperty("merchantsecretKey") == null) {
                throw new ConfigException("Merchant SecretKey is mandatory");
            }
            this.merchantSecretKey = this.getProperty(this.merchantID, "merchantsecretKey").trim();
        }
        if (this.authenticationType != null && this.authenticationType.equalsIgnoreCase("OAuth")) {
            if (this.props.getProperty("accessToken") == null) {
                throw new ConfigException("Access Token is mandatory for OAuth");
            }
            this.accessToken = this.props.getProperty("accessToken");
            if (this.props.getProperty("refreshToken") == null) {
                throw new ConfigException("Refresh Token is mandatory for OAuth");
            }
            this.refreshToken = this.props.getProperty("refreshToken");
        }
        if (this.authenticationType != null && this.authenticationType.equalsIgnoreCase("MutualAuth")) {
            if (this.props.getProperty("clientId") == null) {
                throw new ConfigException("Client Id is mandatory to generate OAuth");
            }
            this.clientId = this.props.getProperty("clientId");
            if (this.props.getProperty("clientSecret") == null) {
                throw new ConfigException("Client Secret is mandatory to generate OAuth");
            }
            this.clientSecret = this.props.getProperty("clientSecret");
        }
        this.solutionId = this.getProperty(this.merchantID, "solutionId");
        if (this.props.getProperty("runEnvironment") == null) {
            throw new ConfigException("Run Environment is mandatory");
        }
        this.runEnvironment = this.getProperty(this.merchantID, "runEnvironment").trim();
        try {
            if (GlobalLabelParameters.OLD_RUN_ENVIRONMENT_CONSTANTS.contains(this.runEnvironment.toUpperCase())) {
                throw new ConfigException("The value provided for this field `RunEnvironment` has been deprecated and will not be used anymore.\n\nPlease refer to the README file [ https://github.com/CyberSource/cybersource-rest-samples-java/blob/master/README.md ] for information about the new values that are accepted.");
            }
            this.requestHost = this.runEnvironment;
        }
        catch (Exception e) {
            this.log = Log4j.getInstance(this);
            Utility.log(this.log, "********* START *********", "", Level.INFO);
            Utility.log(this.log, "Run Environment mandatory : NO Run Environment entered. ", "", Level.ERROR);
            isSetMerchantDetails = false;
        }
        String retryEnabledValue = this.props.getProperty("retryEnabled");
        this.retryEnabled = retryEnabledValue != null && !retryEnabledValue.isEmpty() ? Boolean.valueOf(retryEnabledValue) : false;
        this.retryDelay = Long.valueOf(this.props.getProperty("retryDelay", "0"));
    }

    private boolean checkAuthenticationType() throws ConfigException {
        boolean check = true;
        if (this.authenticationType == null || this.authenticationType.isEmpty()) {
            this.log = Log4j.getInstance(this);
            Utility.log(this.log, "********* START *********", "", Level.INFO);
            Utility.log(this.log, "Authentication type is mandatory", "", Level.ERROR);
            check = false;
            throw new ConfigException("Authentication type is mandatory");
        }
        if (!(this.authenticationType.equalsIgnoreCase("JWT") || this.authenticationType.equalsIgnoreCase("HTTP_Signature") || this.authenticationType.equalsIgnoreCase("JWE") || this.authenticationType.equalsIgnoreCase("OAuth") || this.authenticationType.equalsIgnoreCase("MutualAuth"))) {
            this.log = Log4j.getInstance(this);
            Utility.log(this.log, "********* START *********", "", Level.INFO);
            Utility.log(this.log, "Invalid Authentication Type in cybs.properties :: ", "", Level.ERROR);
            check = false;
            throw new ConfigException("Invalid Authentication Type in cybs.properties :: ");
        }
        return check;
    }

    public boolean checkMerchantId() throws ConfigException {
        boolean check = true;
        if (this.merchantID == null || this.merchantID.isEmpty()) {
            this.log = Log4j.getInstance(this);
            Utility.log(this.log, "********* START *********", "", Level.INFO);
            Utility.log(this.log, "MerchantID mandatory : NO MerchantID entered. ", "", Level.ERROR);
            check = false;
            throw new ConfigException("MerchantID mandatory : NO MerchantID entered. ");
        }
        return check;
    }

    public void setLogDirectory(String logDirectory) {
        this.logDirectory = logDirectory;
    }

    public File getKeyFile() {
        return this.keyFile;
    }

    public boolean checkKeyFile() throws ConfigException {
        boolean check = true;
        this.keyFile = null;
        if (this.keyFilename == null || this.keyFilename.isEmpty()) {
            Utility.log(this.log, "KeyFileName is empty, assigning merchantID value :: ", this.merchantID, Level.ERROR);
            if (this.merchantID != null) {
                this.keyFilename = this.merchantID;
            }
        }
        if (this.keysDirectory.isEmpty() || this.keysDirectory == null) {
            this.keysDirectory = "src/main/resources";
            Utility.log(this.log, "Key Directory is empty, assigning default path :: src/main/resources", "", Level.ERROR);
        }
        this.keyFile = new File(this.keysDirectory);
        if (!this.keyFile.isDirectory()) {
            Utility.log(this.log, "KeyDirectory not found, Entered directory :: ", this.keysDirectory, Level.ERROR);
            this.keyFile = null;
            check = false;
            return check;
        }
        try {
            this.keyFile = new File(this.keysDirectory, this.keyFilename.concat(".p12"));
            if (!this.keyFile.exists()) {
                Utility.log(this.log, "KeyFile not found, Entered path/file name :: ", this.keysDirectory.concat("/").concat(this.keyFilename) + ".p12", Level.ERROR);
                this.keyFile = null;
                check = false;
                return check;
            }
            Utility.log(this.log, "KeyFile, Entered path/file name :: ", this.keysDirectory.concat("/").concat(this.keyFilename) + ".p12", Level.INFO);
        }
        catch (Exception e) {
            this.keyFile = null;
            check = false;
            return check;
        }
        boolean isRead = this.keyFile.canRead();
        if (isRead) {
            return check;
        }
        Utility.log(this.log, "File cannot be read permission denied :: ", this.keysDirectory.concat(this.keyFilename), Level.ERROR);
        this.keyFile = null;
        check = false;
        return check;
    }

    public boolean getLogFile() throws ConfigException {
        File dir = new File(this.getLogDirectory());
        if (!dir.isDirectory()) {
            Utility.log(this.log, "Invalid log directory, creating default log directory", "", Level.ERROR);
            this.logDirectory = "log";
        }
        return this.getLogFileNameStatus();
    }

    private boolean getLogFileNameStatus() throws ConfigException {
        boolean status = true;
        if (this.logFilename == null || this.logFilename.isEmpty()) {
            Utility.log(this.log, "No log file name, setting default log file name :: cybs.log", "", Level.ERROR);
            this.logFilename = "cybs".concat(".log");
        }
        return status;
    }

    public String getProperty(String merchantID, String prop) {
        return this.getProperty(merchantID, prop, null);
    }

    public String getProperty(String merchantID, String prop, String defaultVal) {
        String merchantSpecificProp;
        String val = null;
        String string = merchantSpecificProp = merchantID != null ? merchantID + "." + prop : null;
        if (this.props != null && merchantSpecificProp != null) {
            val = this.props.getProperty(merchantSpecificProp);
        }
        if (this.props != null && val == null) {
            val = this.props.getProperty(prop);
        }
        if (val == null && merchantSpecificProp != null) {
            val = System.getProperty("cybs." + merchantSpecificProp);
        }
        if (val == null) {
            val = System.getProperty("cybs." + prop);
        }
        if (val == null) {
            val = defaultVal;
        }
        return val;
    }

    public boolean getBooleanProperty(String merchantID, String prop, boolean defaultVal) throws ConfigException {
        String strValue = this.getProperty(merchantID, prop);
        if (strValue == null || strValue == "") {
            return defaultVal;
        }
        if (!"1".equals(strValue) && !"true".equalsIgnoreCase(strValue)) {
            if (!"0".equals(strValue) && !"false".equalsIgnoreCase(strValue)) {
                throw new ConfigException(prop + " has an invalid value.");
            }
            return false;
        }
        return true;
    }

    public int getIntegerProperty(String merchantID, String prop, int defaultVal) {
        String strValue = this.getProperty(merchantID, prop);
        if (strValue == null) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(strValue);
        }
        catch (NumberFormatException var6) {
            Utility.log(this.log, "Prop has an invalid Value", "", Level.ERROR);
            return defaultVal;
        }
    }

    private String date() {
        this.date = DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now(ZoneId.of("GMT")));
        return this.date;
    }

    private boolean checkBooleanLogValue(String merchantID, String prop) {
        String logBoolean = this.getProperty(merchantID, prop);
        try {
            if (logBoolean == null || logBoolean.isEmpty()) {
                return true;
            }
            if (logBoolean.equalsIgnoreCase("1")) {
                return true;
            }
            if (logBoolean.equalsIgnoreCase("0")) {
                return false;
            }
            return logBoolean.equalsIgnoreCase("true");
        }
        catch (Exception e) {
            return true;
        }
    }
}

