/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.authsdk.jwt;

import com.cybersource.authsdk.core.ConfigException;
import com.cybersource.authsdk.core.MerchantConfig;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class KeyCertificateGenerator {
    public static X509Certificate initializeCertificate(MerchantConfig merchantConfig) throws CertificateException, NoSuchAlgorithmException, IOException, KeyStoreException, ConfigException, Exception {
        if (merchantConfig != null && merchantConfig.getKeyAlias() != null && merchantConfig.getKeyFile() != null) {
            KeyStore merchantKeyStore = KeyStore.getInstance("PKCS12", (Provider)new BouncyCastleProvider());
            merchantKeyStore.load(new FileInputStream(merchantConfig.getKeyFile()), merchantConfig.getKey().toCharArray());
            String merchantKeyAlias = null;
            Enumeration<String> enumKeyStore = merchantKeyStore.aliases();
            ArrayList<String> array = new ArrayList<String>();
            while (enumKeyStore.hasMoreElements()) {
                merchantKeyAlias = enumKeyStore.nextElement();
                array.add(merchantKeyAlias);
            }
            merchantKeyAlias = KeyCertificateGenerator.keyAliasValidator(array, merchantConfig.getKeyPass());
            try {
                KeyStore.PrivateKeyEntry e = (KeyStore.PrivateKeyEntry)merchantKeyStore.getEntry(merchantKeyAlias, new KeyStore.PasswordProtection(merchantConfig.getKey().toCharArray()));
                return (X509Certificate)e.getCertificate();
            }
            catch (UnrecoverableEntryException var5) {
                return null;
            }
        }
        return null;
    }

    private static String keyAliasValidator(ArrayList<String> array, String merchantID) {
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            String merchantKeyAlias = array.get(i).toString();
            StringTokenizer str = new StringTokenizer(merchantKeyAlias, ",");
            while (str.hasMoreTokens()) {
                String tempKeyAlias = str.nextToken();
                if (!tempKeyAlias.contains("CN")) continue;
                str = new StringTokenizer(tempKeyAlias, "=");
                while (str.hasMoreElements()) {
                    String result = str.nextToken();
                    if (!result.equalsIgnoreCase(merchantID)) continue;
                    return merchantKeyAlias;
                }
            }
        }
        return null;
    }

    public static X509Certificate initializeRecipientCertificate(MerchantConfig merchantConfig) throws CertificateException, NoSuchAlgorithmException, IOException, KeyStoreException, ConfigException, Exception {
        if (merchantConfig != null && merchantConfig.getRecipientID() != null && merchantConfig.getKeyFile() != null) {
            KeyStore merchantKeyStore = KeyStore.getInstance("PKCS12", (Provider)new BouncyCastleProvider());
            merchantKeyStore.load(new FileInputStream(merchantConfig.getKeyFile()), merchantConfig.getKey().toCharArray());
            String merchantKeyAlias = null;
            Enumeration<String> enumKeyStore = merchantKeyStore.aliases();
            while (enumKeyStore.hasMoreElements() && !(merchantKeyAlias = enumKeyStore.nextElement()).contains(merchantConfig.getRecipientID())) {
                merchantKeyAlias = null;
            }
            Certificate certificate = null;
            if (merchantKeyAlias == null) {
                throw new ConfigException("merchant config error: cannot find recipient certificate in key file, " + merchantConfig.getRecipientID());
            }
            certificate = merchantKeyStore.getCertificate(merchantKeyAlias);
            if (!(certificate instanceof X509Certificate)) {
                throw new ConfigException("specified recipient certificate incorrect type(x509): " + merchantConfig.getRecipientID());
            }
            return (X509Certificate)certificate;
        }
        throw new ConfigException("merchant config fields missing: recipientId, key file");
    }

    public static RSAPrivateKey initializePrivateKey(MerchantConfig merchantConfig) throws CertificateException, NoSuchAlgorithmException, IOException, KeyStoreException, ConfigException, Exception {
        if (merchantConfig != null && merchantConfig.getKeyAlias() != null && merchantConfig.getKeyFile() != null) {
            KeyStore merchantKeyStore = KeyStore.getInstance("PKCS12", (Provider)new BouncyCastleProvider());
            merchantKeyStore.load(new FileInputStream(merchantConfig.getKeyFile()), merchantConfig.getKey().toCharArray());
            String merchantKeyAlias = null;
            Enumeration<String> enumKeyStore = merchantKeyStore.aliases();
            while (enumKeyStore.hasMoreElements() && !(merchantKeyAlias = enumKeyStore.nextElement()).contains(merchantConfig.getKeyAlias())) {
            }
            try {
                KeyStore.PrivateKeyEntry e = (KeyStore.PrivateKeyEntry)merchantKeyStore.getEntry(merchantKeyAlias, new KeyStore.PasswordProtection(merchantConfig.getKey().toCharArray()));
                return (RSAPrivateKey)e.getPrivateKey();
            }
            catch (UnrecoverableEntryException var5) {
                return null;
            }
        }
        return null;
    }
}

