/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.authsdk.oauth;

import com.cybersource.authsdk.cache.Cache;
import com.cybersource.authsdk.core.ConfigException;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.core.TokenGenerator;
import com.cybersource.authsdk.util.Utility;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class OAuthToken
implements TokenGenerator {
    private MerchantConfig merchantConfig;
    private String refreshToken;
    private String accessToken;
    private Logger logger;
    private Cache cache;

    public OAuthToken(MerchantConfig merchantConfig) {
        this.merchantConfig = merchantConfig;
    }

    @Override
    public String getToken() {
        try {
            this.accessToken = this.getAccessToken();
        }
        catch (Exception e) {
            this.accessToken = null;
        }
        return this.accessToken;
    }

    public String getAccessToken() throws Exception {
        try {
            if (this.merchantConfig == null) {
                throw new ConfigException("merchant config is null");
            }
            this.accessToken = this.merchantConfig.getAccessToken();
            this.refreshToken = this.merchantConfig.getRefreshToken();
        }
        catch (Exception e) {
            Utility.log(this.logger, "Retrieve Access Token failed.", "", Level.FATAL);
            Utility.log(this.logger, e);
            this.accessToken = null;
        }
        return this.accessToken;
    }

    private void setUpCache() throws ConfigException {
        this.cache.setAccessToken(this.accessToken);
        this.cache.setRefreshToken(this.refreshToken);
    }
}

