package com.cybersource.authsdk.cache;

import java.io.File;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.concurrent.ConcurrentHashMap;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import com.cybersource.authsdk.core.ConfigException;
import com.cybersource.authsdk.core.MerchantConfig;

public class Cache {
	private static Logger logger = LogManager.getLogger(Cache.class);	
	public static boolean isCache = false;
	public static long lastModifiedTime;
	public static ConcurrentHashMap<String, Identity> cacheP12 = new ConcurrentHashMap<>();
	
	private boolean isTimeStamp;
	private MerchantConfig merchantConfig;
	private Identity identity = new Identity();
	private X509Certificate x509Certificate;
	private RSAPrivateKey rsaPrivateKey;
	private String merchantID;
	private String accessToken;
	private String refreshToken;

	public void setX509Certificate(X509Certificate x509Certificate) {
		this.x509Certificate = x509Certificate;
	}

	public void setAccessToken(String accessToken) {
		this.accessToken = accessToken;
	}

	public String getAccessToken() {
		return accessToken;
	}

	public void setRefreshToken(String refreshToken) {
		this.refreshToken = refreshToken;
	}

	public String getRefreshToken() {
		return refreshToken;
	}

	public void setRsaPrivateKey(RSAPrivateKey rsaPrivateKey) {
		this.rsaPrivateKey = rsaPrivateKey;
	}

	public RSAPrivateKey getRsaPrivateKey() {
		return rsaPrivateKey;
	}

	public X509Certificate getX509Certificate() {
		return x509Certificate;
	}

	/**
	 * @param merchantConfig - contains all information for merchant.
	 */
	public Cache(MerchantConfig merchantConfig) {
		this.merchantConfig = merchantConfig;
		logger = LogManager.getLogger(this.getClass());
		this.merchantID = merchantConfig.getMerchantID();
		if (cacheP12.isEmpty()) {
			Cache.isCache = true;
		} else {
			Cache.isCache = false;
		}
	}

	/**
	 * @throws ConfigException - if some value is missing or wrong for merchant.
	 */
	public void setP12FileDetailsInCache() throws ConfigException {
		if (cacheP12.isEmpty()) {
			setUpP12Cache();
		} else {
			isTimeStamp = isLastModifiedTimeP12();
			if (isTimeStamp) {
				retrieveP12DataFromCache();
			} else {
				setUpP12Cache();
			}
		}
	}

	/**
	 * @throws ConfigException - if some value is missing or wrong for merchant.
	 */
	public void setUpP12Cache() throws ConfigException {
		identity.setLastModifiedDate(getLastModifiedFileP12());
		identity.setX509(x509Certificate);
		identity.setRsaPrivateKey(rsaPrivateKey);
		String tempMerchantID = merchantConfig.getMerchantID();
		cacheP12.put(tempMerchantID, identity);
		lastModifiedTime = merchantConfig.getKeyFile().lastModified();
	}

	public void retrieveP12DataFromCache() {
		Identity tempIdentity = cacheP12.get(merchantID);
		if (tempIdentity != null) {
			x509Certificate = tempIdentity.getX509();
			rsaPrivateKey = tempIdentity.getRsaPrivateKey();
		}
	}

	/**
	 * @return true if file is modified else return false.
	 */
	public boolean isLastModifiedTimeP12() {
		Identity tempIdentity = cacheP12.get(merchantID);
		if (tempIdentity != null) {
			long tempLastModifiedTime = tempIdentity.getLastModifiedDate();
			if (lastModifiedTime == tempLastModifiedTime) {
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	/**
	 * @return value for last modified.
	 */
	@SuppressWarnings("null")
	public long getLastModifiedFileP12() {
		File f;
		try {
			f = new File(merchantConfig.getKeyFile().getAbsolutePath());
			return f.lastModified();
		} catch (Exception e) {
			logger.error(e);
			return (Long) null;
		}
	}
}
