/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.authsdk.oauth;

import com.cybersource.authsdk.core.ConfigException;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.core.TokenGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OAuthToken
implements TokenGenerator {
    private static Logger logger = LogManager.getLogger(OAuthToken.class);
    private MerchantConfig merchantConfig;
    private String refreshToken;
    private String accessToken;

    public OAuthToken(MerchantConfig merchantConfig) {
        this.merchantConfig = merchantConfig;
    }

    @Override
    public String getToken() {
        try {
            this.accessToken = this.getAccessToken();
        }
        catch (Exception e) {
            logger.error("Error retrieving access token\n{}", (Throwable)e);
            this.accessToken = null;
        }
        return this.accessToken;
    }

    public String getAccessToken() throws Exception {
        try {
            if (this.merchantConfig == null) {
                throw new ConfigException("merchant config is null");
            }
            this.accessToken = this.merchantConfig.getAccessToken();
            this.refreshToken = this.merchantConfig.getRefreshToken();
        }
        catch (Exception e) {
            logger.fatal("Retrieve Access Token failed.");
            logger.error("Exception : {}", (Throwable)e);
            this.accessToken = null;
        }
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }
}

