/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.authsdk.core;

import com.cybersource.authsdk.core.ConfigException;
import com.cybersource.authsdk.util.GlobalLabelParameters;
import com.cybersource.authsdk.util.PrettyPrintingMap;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MerchantConfig {
    private static Logger logger = LogManager.getLogger(MerchantConfig.class);
    private Properties props;
    private Map<String, String> defaultHeaders;
    private String requestTarget;
    private String authenticationType;
    private String requestType;
    private String requestHost;
    private String requestData;
    private String merchantID;
    private String runEnvironment;
    private String intermediateHost;
    private String defaultDeveloperId;
    private String solutionId;
    private boolean retryEnabled;
    private long retryDelay;
    private boolean useMetaKey;
    private String portfolioID;
    private String merchantKeyId;
    private String merchantSecretKey;
    private String keysDirectory;
    private String keyAlias;
    private String keyPass;
    private String keyFilename;
    private File keyFile;
    private String accessToken;
    private String refreshToken;
    private String clientId;
    private String clientSecret;
    private boolean enableClientCert;
    private String clientCertFile;
    private String clientCertDirectory;
    private String pemFileDirectory;
    private String clientCertPassword;
    private boolean useProxy = false;
    private String proxyAddress;
    private int proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private int userDefinedConnectionTimeout;
    private int userDefinedReadTimeout;
    private int userDefinedWriteTimeout;
    private int userDefinedKeepAliveDuration;
    public boolean merchantDetailsSet = false;
    private boolean useMLEGlobally;
    private Map<String, Boolean> mapToControlMLEonAPI;
    private String mleKeyAlias;

    public MerchantConfig() throws ConfigException {
    }

    public MerchantConfig(Properties _props) throws ConfigException {
        if (_props != null) {
            this.setProps(_props);
            this.setMerchantDetails();
        }
    }

    public MerchantConfig(Properties _props, Map<String, String> defaultHeaders) throws ConfigException {
        if (_props != null) {
            this.setProps(_props);
            this.setMerchantDetails();
            this.setDefaultHeaders(defaultHeaders);
        }
    }

    public boolean validateMerchantDetails() throws ConfigException {
        boolean isRequestType = this.checkRequestType();
        boolean isMerchantId = true;
        boolean isCheckMerchantSecretKey = false;
        boolean isCheckMerchantKeyId = false;
        boolean isGetKeyAlias = false;
        boolean isCheckKeyPassword = false;
        boolean isCheckKeyFile = false;
        boolean isCheckLogMaxSize = true;
        boolean isMerchantDetailStatus = false;
        this.checkAuthenticationType();
        if (this.getAuthenticationType().equalsIgnoreCase("HTTP_Signature")) {
            isMerchantId = this.checkMerchantId();
            isCheckMerchantSecretKey = this.checkMerchantSecretKey();
            isCheckMerchantKeyId = this.checkMerchantKeyId();
        } else if (this.getAuthenticationType().equalsIgnoreCase("JWT")) {
            isMerchantId = this.checkMerchantId();
            isGetKeyAlias = this.checkKeyAlias();
            isCheckKeyPassword = this.checkKeyPassword();
            isCheckKeyFile = this.checkKeyFile();
        }
        boolean isCheckRunEnvironment = this.checkRunEvironment();
        if (this.getAuthenticationType().equalsIgnoreCase("HTTP_Signature")) {
            isMerchantDetailStatus = isMerchantId && isCheckMerchantSecretKey && isCheckMerchantKeyId && isCheckLogMaxSize && isCheckRunEnvironment && isRequestType && this.isMerchantDetailsSet();
        } else if (this.getAuthenticationType().equalsIgnoreCase("JWT")) {
            isMerchantDetailStatus = isMerchantId && isGetKeyAlias && isCheckKeyPassword && isCheckKeyFile && isCheckLogMaxSize && isCheckRunEnvironment && isRequestType && this.isMerchantDetailsSet();
        } else if (this.getAuthenticationType().equalsIgnoreCase("OAuth") || this.getAuthenticationType().equalsIgnoreCase("MutualAuth")) {
            isMerchantDetailStatus = isCheckLogMaxSize && isCheckRunEnvironment && isRequestType;
        }
        HashMap<String, String> configurationData = new HashMap<String, String>();
        configurationData.put("AuthenticationType", this.getAuthenticationType());
        configurationData.put("RunEnvironment", this.getRunEnvironment());
        logger.info("Configuration :\n{}", new PrettyPrintingMap(configurationData));
        return isMerchantDetailStatus;
    }

    public boolean checkRequestType() throws ConfigException {
        String requestTypeCheck = this.getRequestType();
        if (requestTypeCheck.equalsIgnoreCase("PUT") || requestTypeCheck.equalsIgnoreCase("GET") || requestTypeCheck.equalsIgnoreCase("POST") || requestTypeCheck.equalsIgnoreCase("DELETE") || requestTypeCheck.equalsIgnoreCase("PATCH")) {
            return true;
        }
        logger.error("ConfigException : Invalid Request Type ::  : " + this.requestType);
        throw new ConfigException("Invalid Request Type :: ");
    }

    public boolean checkKeyPassword() throws ConfigException {
        if (this.getKeyPass() == null || this.getKeyPass().isEmpty()) {
            this.setKeyPass(this.getMerchantID());
            logger.error("KeyPassword Empty/Null. Assigning merchantID value");
        }
        return true;
    }

    public boolean checkRunEvironment() throws ConfigException {
        boolean runEnvironment = false;
        if (this.runEnvironment == null || this.runEnvironment.isEmpty()) {
            logger.error("ConfigException : Run Environment value is missing in cybs.properties");
            throw new ConfigException("Run Environment value is missing in cybs.properties");
        }
        if (GlobalLabelParameters.OLD_RUN_ENVIRONMENT_CONSTANTS.contains(this.runEnvironment.toUpperCase())) {
            throw new ConfigException("The value provided for this field `RunEnvironment` has been deprecated and will not be used anymore.\n\nPlease refer to the README file [ https://github.com/CyberSource/cybersource-rest-samples-java/blob/master/README.md ] for information about the new values that are accepted.");
        }
        runEnvironment = true;
        return runEnvironment;
    }

    public boolean checkMerchantKeyId() throws ConfigException {
        if (this.getMerchantKeyId() == null || this.getMerchantKeyId().isEmpty()) {
            logger.error("ConfigException : Merchant KeyID missing/null, check cybs.properties");
            throw new ConfigException("Merchant KeyID missing/null, check cybs.properties");
        }
        return true;
    }

    public boolean checkMerchantSecretKey() throws ConfigException {
        if (this.getMerchantSecretKey() == null || this.getMerchantSecretKey().isEmpty()) {
            logger.error("ConfigException : Merchant Secret Key missing/null, check cybs.properties");
            throw new ConfigException("Merchant Secret Key missing/null, check cybs.properties");
        }
        return true;
    }

    public boolean checkKeyAlias() throws ConfigException {
        if (this.getKeyAlias() == null || this.getKeyAlias().isEmpty()) {
            logger.error("KeyAlias Empty/Null. Assigning merchantID value :: ");
            this.setKeyAlias(this.getMerchantID());
        } else if (!this.useMetaKey && !this.getKeyAlias().equalsIgnoreCase(this.getMerchantID())) {
            this.setKeyAlias(this.getMerchantID());
            logger.error("KeyAlias Mismatch. Assigning merchantID value ");
        }
        return true;
    }

    public void setMerchantDetails() throws ConfigException {
        this.setAuthenticationType(this.getProps().getProperty("authenticationType"));
        this.setUseMetaKey(Boolean.valueOf(this.getProps().getOrDefault((Object)"useMetaKey", (Object)false).toString()));
        this.setEnableClientCert(Boolean.valueOf(this.getProps().getOrDefault((Object)"enableClientCert", (Object)false).toString()));
        if (null != this.getProps().getProperty("jwePEMFileDirectory")) {
            this.setPemFileDirectory(this.getProps().getProperty("jwePEMFileDirectory"));
        }
        if (this.isUseMetaKey()) {
            if (this.getProps().getProperty("portfolioID") == null || StringUtils.isEmpty((CharSequence)this.getProps().getProperty("portfolioID"))) {
                logger.error("ConfigException : Portfolio ID is mandatory");
                throw new ConfigException("Portfolio ID is mandatory");
            }
            this.setPortfolioID(this.getProps().getProperty("portfolioID"));
        }
        if (this.isEnableClientCert()) {
            if (this.getProps().getProperty("clientCertFile") == null || StringUtils.isEmpty((CharSequence)this.getProps().getProperty("clientCertFile"))) {
                logger.error("ConfigException : Client Certificate is mandatory");
                throw new ConfigException("Client Cert is mandatory");
            }
            this.setClientCertFile(this.getProps().getProperty("clientCertFile"));
            if (this.getProps().getProperty("clientCertPassword") == null || StringUtils.isEmpty((CharSequence)this.getProps().getProperty("clientCertPassword"))) {
                logger.error("ConfigException : Client Certificate Password is mandatory");
                throw new ConfigException("Client Cert Password is mandatory");
            }
            this.setClientCertPassword(this.getProps().getProperty("clientCertPassword"));
            if (this.getProps().getProperty("clientCertDirectory") == null || StringUtils.isEmpty((CharSequence)this.getProps().getProperty("clientCertDirectory"))) {
                logger.error("ConfigException : Client Certificate Directory is mandatory");
                throw new ConfigException("Client Cert Directory is mandatory");
            }
            this.setClientCertDirectory(this.getProps().getProperty("clientCertDirectory"));
        }
        if (this.getAuthenticationType() != null && this.getAuthenticationType().equalsIgnoreCase("JWT")) {
            if (this.getProps().getProperty("keysDirectory") == null) {
                this.setKeysDirectory("src/main/resources");
            }
            this.setKeysDirectory(this.getProps().getProperty("keysDirectory").trim());
            if (this.getProps().getProperty("merchantID") == null) {
                logger.error("ConfigException : Merchant ID is mandatory");
                throw new ConfigException("Merchant Id is mandatory");
            }
            this.setMerchantID(this.getProps().getProperty("merchantID").trim());
            if (this.getProps().getProperty("keyAlias") == null) {
                logger.error("KeyAlias Empty/Null. Assigning merchantID value :: ");
                this.setKeyAlias(this.getMerchantID());
            }
            this.setKeyAlias(this.getProps().getProperty("keyAlias").trim());
            if (this.getProps().getProperty("keyPass") == null) {
                this.setKeyPass(this.getMerchantID());
            }
            this.setKeyPass(this.getProps().getProperty("keyPass"));
            if (this.getProps().getProperty("keyFileName") == null) {
                this.setKeyFilename(this.getMerchantID());
            }
            this.setKeyFilename(this.getProps().getProperty("keyFileName").trim());
        } else if (this.getAuthenticationType() != null && this.getAuthenticationType().equalsIgnoreCase("HTTP_Signature")) {
            if (this.getProps().getProperty("merchantID") == null) {
                logger.error("ConfigException : Merchant ID is mandatory");
                throw new ConfigException("Merchant Id is mandatory");
            }
            this.setMerchantID(this.getProps().getProperty("merchantID").trim());
            if (this.getProps().getProperty("merchantKeyId") == null) {
                logger.error("ConfigException : Merchant Key ID is mandatory");
                throw new ConfigException("Merchant KeyId is mandatory");
            }
            this.setMerchantKeyId(this.getProps().getProperty("merchantKeyId").trim());
            if (this.getProps().getProperty("merchantsecretKey") == null) {
                logger.error("ConfigException : Merchant Secret Key is mandatory");
                throw new ConfigException("Merchant SecretKey is mandatory");
            }
            this.setMerchantSecretKey(this.getProps().getProperty("merchantsecretKey").trim());
        } else if (this.getAuthenticationType() != null && this.getAuthenticationType().equalsIgnoreCase("OAuth")) {
            if (this.getProps().getProperty("accessToken") == null || StringUtils.isEmpty((CharSequence)this.getProps().getProperty("accessToken"))) {
                logger.error("ConfigException : Access Token is mandatory for OAuth");
                throw new ConfigException("Access Token is mandatory for OAuth");
            }
            this.setAccessToken(this.getProps().getProperty("accessToken"));
            if (this.getProps().getProperty("refreshToken") == null || StringUtils.isEmpty((CharSequence)this.getProps().getProperty("refreshToken"))) {
                logger.error("ConfigException : Refresh Token is mandatory for OAuth");
                throw new ConfigException("Refresh Token is mandatory for OAuth");
            }
            this.setRefreshToken(this.getProps().getProperty("refreshToken"));
        } else if (this.getAuthenticationType() != null && this.getAuthenticationType().equalsIgnoreCase("MutualAuth")) {
            if (this.getProps().getProperty("clientId") == null || StringUtils.isEmpty((CharSequence)this.getProps().getProperty("clientId"))) {
                logger.error("ConfigException : Client ID is mandatory to generate OAuth");
                throw new ConfigException("Client Id is mandatory to generate OAuth");
            }
            this.setClientId(this.getProps().getProperty("clientId"));
            if (this.getProps().getProperty("clientSecret") == null || StringUtils.isEmpty((CharSequence)this.getProps().getProperty("clientSecret"))) {
                logger.error("ConfigException : Client Secret is mandatory to generate OAuth");
                throw new ConfigException("Client Secret is mandatory to generate OAuth");
            }
            this.setClientSecret(this.getProps().getProperty("clientSecret"));
        }
        this.setUseProxy(Boolean.valueOf(this.getProps().getOrDefault((Object)"useProxy", (Object)false).toString()));
        if (this.isUseProxyEnabled()) {
            this.setProxyAddress(this.getProps().getProperty("proxyAddress"));
            if (this.getProps().getProperty("proxyPort") == null) {
                logger.error("ConfigException : Proxy Port is necessary for using Proxy");
                throw new ConfigException("Proxy Port is necessary for using Proxy");
            }
            this.setProxyPort(Integer.parseInt(this.getProps().getProperty("proxyPort")));
            this.setProxyUser(this.getProps().getProperty("proxyUser"));
            this.setProxyPassword(this.getProps().getProperty("proxyPassword"));
        }
        this.setSolutionId(this.getProps().getProperty("solutionId"));
        if (this.getProps().getProperty("runEnvironment") == null || StringUtils.isEmpty((CharSequence)this.getProps().getProperty("runEnvironment"))) {
            logger.error("ConfigException : Run Environment is mandatory");
            throw new ConfigException("Run Environment is mandatory");
        }
        this.setRunEnvironment(this.getProps().getProperty("runEnvironment").trim());
        if (StringUtils.isNotBlank((CharSequence)this.getProps().getProperty("intermediateHost"))) {
            this.setIntermediateHost(this.getProps().getProperty("intermediateHost").trim());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getProps().getProperty("defaultDeveloperId"))) {
            this.setDefaultDeveloperId(this.getProps().getProperty("defaultDeveloperId").trim());
        }
        this.setUserDefinedConnectionTimeout(Integer.valueOf(this.getProps().getProperty("userDefinedConnectionTimeout", "0")));
        if (this.getUserDefinedConnectionTimeout() <= 0) {
            logger.warn("Provided Connection Timeout Value is Incorrect, Defaulting to 0");
        }
        this.setUserDefinedReadTimeout(Integer.valueOf(this.getProps().getProperty("userDefinedReadTimeout", "0")));
        if (this.getUserDefinedReadTimeout() <= 0) {
            logger.warn("Provided Read Timeout Value is Incorrect, Defaulting to 0");
        }
        this.setUserDefinedWriteTimeout(Integer.valueOf(this.getProps().getProperty("userDefinedWriteTimeout", "0")));
        if (this.getUserDefinedWriteTimeout() <= 0) {
            logger.warn("Provided Write Timeout Value is Incorrect, Defaulting to 0");
        }
        this.setUserDefinedKeepAliveDuration(Integer.valueOf(this.getProps().getProperty("userDefinedKeepAliveDuration", "0")));
        if (this.getUserDefinedKeepAliveDuration() <= 0) {
            logger.warn("Provided Keep Alive Duration Value is Incorrect, Defaulting to 0");
        }
        try {
            if (GlobalLabelParameters.OLD_RUN_ENVIRONMENT_CONSTANTS.contains(this.runEnvironment.toUpperCase())) {
                throw new ConfigException("The value provided for this field `RunEnvironment` has been deprecated and will not be used anymore.\n\nPlease refer to the README file [ https://github.com/CyberSource/cybersource-rest-samples-java/blob/master/README.md ] for information about the new values that are accepted.");
            }
            this.requestHost = this.runEnvironment;
        }
        catch (Exception e) {
            logger.info("********* START *********");
            logger.error("Run Environment mandatory : NO Run Environment entered. ");
            this.setMerchantDetailsSet(false);
        }
        String retryEnabledValue = this.getProps().getProperty("retryEnabled");
        if (retryEnabledValue != null && !retryEnabledValue.isEmpty()) {
            this.setRetryEnabled(Boolean.valueOf(retryEnabledValue));
        } else {
            this.setRetryEnabled(false);
        }
        this.setUseMLEGlobally(Boolean.parseBoolean(this.getProps().getProperty("useMLEGlobally")));
        if (null != this.getProps().getProperty("mleKeyAlias") && !StringUtils.isEmpty((CharSequence)this.getProps().getProperty("mleKeyAlias").trim())) {
            this.setMleKeyAlias(this.getProps().getProperty("mleKeyAlias").trim());
        } else {
            this.setMleKeyAlias("CyberSource_SJC_US");
        }
        if (this.getProps().containsKey("mapToControlMLEonAPI")) {
            try {
                this.setMapToControlMLEonAPI((Map)this.getProps().get("mapToControlMLEonAPI"));
            }
            catch (ClassCastException e) {
                logger.warn("Unable to initialise MLE control Map from config");
            }
        }
        this.validateMLEConfiguration();
        this.setRetryDelay(Long.valueOf(this.getProps().getProperty("retryDelay", "0")));
        this.setMerchantDetailsSet(true);
    }

    private void checkAuthenticationType() throws ConfigException {
        if (this.getAuthenticationType() == null || this.getAuthenticationType().isEmpty()) {
            logger.info("********* START *********");
            logger.error("Authentication type is mandatory");
            throw new ConfigException("Authentication type is mandatory");
        }
        if (!(this.getAuthenticationType().equalsIgnoreCase("JWT") || this.getAuthenticationType().equalsIgnoreCase("HTTP_Signature") || this.getAuthenticationType().equalsIgnoreCase("OAuth") || this.getAuthenticationType().equalsIgnoreCase("MutualAuth"))) {
            logger.info("********* START *********");
            logger.error("Invalid Authentication Type in cybs.properties :: ");
            throw new ConfigException("Invalid Authentication Type in cybs.properties :: ");
        }
    }

    private void validateMLEConfiguration() throws ConfigException {
        boolean mleConfigured = this.useMLEGlobally;
        if (this.mapToControlMLEonAPI != null && !this.mapToControlMLEonAPI.isEmpty()) {
            for (boolean value : this.mapToControlMLEonAPI.values()) {
                if (!value) continue;
                mleConfigured = true;
                break;
            }
        }
        if (mleConfigured && !"JWT".equalsIgnoreCase(this.authenticationType)) {
            logger.error("MLE is only supported in JWT auth type");
            throw new ConfigException("MLE is only supported in JWT auth type");
        }
        this.checkKeyFile();
    }

    public boolean checkMerchantId() throws ConfigException {
        boolean check = true;
        if (this.getMerchantID() == null || this.getMerchantID().isEmpty()) {
            logger.info("********* START *********");
            logger.error("MerchantID mandatory : NO MerchantID entered. ");
            check = false;
            throw new ConfigException("MerchantID mandatory : NO MerchantID entered. ");
        }
        return check;
    }

    public boolean checkKeyFile() throws ConfigException {
        File newFile = null;
        this.setKeyFile(null);
        if (this.getKeyFilename() == null || this.getKeyFilename().isEmpty()) {
            logger.error("KeyFileName is empty, assigning merchantID value :: ");
            if (this.getMerchantID() != null) {
                this.setKeyFilename(this.getMerchantID());
            }
        }
        if (this.getKeysDirectory() == null || this.getKeysDirectory().isEmpty()) {
            this.setKeysDirectory("src/main/resources");
            logger.error("Key Directory is empty, assigning default path :: src/main/resources");
        }
        if (!(newFile = new File(this.keysDirectory)).isDirectory()) {
            logger.error("KeyDirectory not found, Entered directory ::  : " + this.keysDirectory);
            return false;
        }
        try {
            newFile = new File(this.getKeysDirectory(), this.getKeyFilename().concat(".p12"));
            if (!newFile.exists()) {
                logger.error("KeyFile not found, Entered path/file name ::  : " + this.keysDirectory.concat("/").concat(this.getKeyFilename()) + ".p12");
                return false;
            }
            logger.info("KeyFile, Entered path/file name ::  : " + this.keysDirectory.concat("/").concat(this.getKeyFilename()) + ".p12");
        }
        catch (Exception e) {
            return false;
        }
        boolean isRead = newFile.canRead();
        if (isRead) {
            this.setKeyFile(newFile);
            return true;
        }
        logger.info("File cannot be read permission denied ::  : " + this.keysDirectory.concat(this.getKeyFilename()));
        return false;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public String getMerchantID() {
        return this.merchantID;
    }

    public void setMerchantID(String merchantID) {
        this.merchantID = merchantID;
    }

    public String getRequestTarget() {
        return this.requestTarget;
    }

    public void setRequestTarget(String requestTarget) {
        this.requestTarget = requestTarget;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    public String getRequestHost() {
        return this.requestHost;
    }

    public void setRequestHost(String requestHost) {
        this.requestHost = requestHost;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public boolean isRetryEnabled() {
        return this.retryEnabled;
    }

    public void setRetryEnabled(boolean retryEnabled) {
        this.retryEnabled = retryEnabled;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }

    public boolean isUseMetaKey() {
        return this.useMetaKey;
    }

    public void setUseMetaKey(boolean useMetaKey) {
        this.useMetaKey = useMetaKey;
    }

    public String getPortfolioID() {
        return this.portfolioID;
    }

    public void setPortfolioID(String portfolioID) {
        this.portfolioID = portfolioID;
    }

    public String getKeysDirectory() {
        return this.keysDirectory;
    }

    public void setKeysDirectory(String keysDirectory) {
        this.keysDirectory = keysDirectory;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public String getKeyPass() {
        return this.keyPass;
    }

    public void setKeyPass(String keyPass) {
        this.keyPass = keyPass;
    }

    public String getKeyFilename() {
        return this.keyFilename;
    }

    public void setKeyFilename(String keyFilename) {
        this.keyFilename = keyFilename;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public boolean isUseProxyEnabled() {
        return this.useProxy;
    }

    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    public String getProxyAddress() {
        return this.proxyAddress;
    }

    public void setProxyAddress(String proxyAddress) {
        this.proxyAddress = proxyAddress;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword != null ? this.proxyPassword : "";
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getRequestData() {
        return this.requestData;
    }

    public void setRequestData(String requestData) {
        this.requestData = requestData;
    }

    public String getRunEnvironment() {
        return this.runEnvironment;
    }

    public void setRunEnvironment(String runEnvironment) {
        this.runEnvironment = runEnvironment;
    }

    public String getIntermediateHost() {
        return this.intermediateHost;
    }

    public void setIntermediateHost(String intermediateHost) {
        this.intermediateHost = intermediateHost;
    }

    public String getDefaultDeveloperId() {
        return this.defaultDeveloperId;
    }

    public void setDefaultDeveloperId(String defaultDeveloperId) {
        this.defaultDeveloperId = defaultDeveloperId;
    }

    public File getKeyFile() {
        return this.keyFile;
    }

    public void setKeyFile(File keyFile) {
        this.keyFile = keyFile;
    }

    public boolean isEnableClientCert() {
        return this.enableClientCert;
    }

    public void setEnableClientCert(boolean enableClientCert) {
        this.enableClientCert = enableClientCert;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getClientCertFile() {
        return this.clientCertFile;
    }

    public void setClientCertFile(String clientCertFile) {
        this.clientCertFile = clientCertFile;
    }

    public String getClientCertDirectory() {
        return this.clientCertDirectory;
    }

    public void setClientCertDirectory(String clientCertDirectory) {
        this.clientCertDirectory = clientCertDirectory;
    }

    public String getClientCertPassword() {
        return this.clientCertPassword;
    }

    public void setClientCertPassword(String clientCertPassword) {
        this.clientCertPassword = clientCertPassword;
    }

    public boolean isMerchantDetailsSet() {
        return this.merchantDetailsSet;
    }

    public void setMerchantDetailsSet(boolean merchantDetailsSet) {
        this.merchantDetailsSet = merchantDetailsSet;
    }

    public String getMerchantKeyId() {
        return this.merchantKeyId;
    }

    public void setMerchantKeyId(String merchantKeyId) {
        this.merchantKeyId = merchantKeyId;
    }

    public String getMerchantSecretKey() {
        return this.merchantSecretKey;
    }

    public void setMerchantSecretKey(String merchantsecretKey) {
        this.merchantSecretKey = merchantsecretKey;
    }

    public String getSolutionId() {
        return this.solutionId;
    }

    public void setSolutionId(String solutionId) {
        this.solutionId = solutionId;
    }

    public int getUserDefinedConnectionTimeout() {
        return this.userDefinedConnectionTimeout;
    }

    public void setUserDefinedConnectionTimeout(int timeout) {
        this.userDefinedConnectionTimeout = timeout;
    }

    public int getUserDefinedReadTimeout() {
        return this.userDefinedReadTimeout;
    }

    public void setUserDefinedReadTimeout(int timeout) {
        this.userDefinedReadTimeout = timeout;
    }

    public int getUserDefinedWriteTimeout() {
        return this.userDefinedWriteTimeout;
    }

    public void setUserDefinedWriteTimeout(int timeout) {
        this.userDefinedWriteTimeout = timeout;
    }

    public int getUserDefinedKeepAliveDuration() {
        return this.userDefinedKeepAliveDuration;
    }

    public void setUserDefinedKeepAliveDuration(int duration) {
        this.userDefinedKeepAliveDuration = duration;
    }

    public Map<String, String> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public void setDefaultHeaders(Map<String, String> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    public String getPemFileDirectory() {
        return this.pemFileDirectory;
    }

    public void setPemFileDirectory(String pemFileDirectory) {
        this.pemFileDirectory = pemFileDirectory;
    }

    public boolean isUseMLEGlobally() {
        return this.useMLEGlobally;
    }

    public void setUseMLEGlobally(boolean useMLEGlobally) {
        this.useMLEGlobally = useMLEGlobally;
    }

    public Map<String, Boolean> getMapToControlMLEonAPI() {
        return this.mapToControlMLEonAPI;
    }

    public void setMapToControlMLEonAPI(Map<String, Boolean> mapToControlMLEonAPI) {
        this.mapToControlMLEonAPI = mapToControlMLEonAPI;
    }

    public String getMleKeyAlias() {
        return this.mleKeyAlias;
    }

    public void setMleKeyAlias(String mleKeyAlias) {
        this.mleKeyAlias = mleKeyAlias;
    }
}

