/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.authsdk.http;

import com.cybersource.authsdk.core.ConfigException;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.core.TokenGenerator;
import com.cybersource.authsdk.http.SignatureGenerator;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpSignatureToken
implements TokenGenerator {
    private static Logger logger = LogManager.getLogger(HttpSignatureToken.class);
    private MerchantConfig merchantConfigSigHead = null;
    private StringBuilder signatureHeader;
    private String merchantkeyId = null;
    private String httpMethod = null;

    public HttpSignatureToken(MerchantConfig merchantConfig) {
        this.merchantConfigSigHead = merchantConfig;
        this.merchantkeyId = merchantConfig.getMerchantKeyId();
        this.httpMethod = merchantConfig.getRequestType();
        merchantConfig.getMerchantSecretKey();
        merchantConfig.getMerchantID();
    }

    @Override
    public String getToken() {
        String signature = null;
        try {
            signature = this.signatureHeader();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e);
        }
        catch (InvalidKeyException e) {
            logger.error((Object)e);
        }
        catch (ConfigException e) {
            logger.error((Object)e);
        }
        return signature;
    }

    private String signatureHeader() throws InvalidKeyException, NoSuchAlgorithmException, ConfigException {
        this.signatureHeader = new StringBuilder();
        this.signatureHeader.append("keyid=\"" + this.merchantkeyId + "\"");
        this.signatureHeader.append(", algorithm=\"HmacSHA256\"");
        if (this.httpMethod.equalsIgnoreCase("GET")) {
            this.signatureHeader.append(", headers=\"" + this.getRequestHeaders("GET") + "\"");
        } else if (this.httpMethod.equalsIgnoreCase("DELETE")) {
            this.signatureHeader.append(", headers=\"" + this.getRequestHeaders("DELETE") + "\"");
        } else if (this.httpMethod.equalsIgnoreCase("POST")) {
            this.signatureHeader.append(", headers=\"" + this.getRequestHeaders("POST") + "\"");
        } else if (this.httpMethod.equalsIgnoreCase("PATCH")) {
            this.signatureHeader.append(", headers=\"" + this.getRequestHeaders("PATCH") + "\"");
        } else if (this.httpMethod.equalsIgnoreCase("PUT")) {
            this.signatureHeader.append(", headers=\"" + this.getRequestHeaders("PUT") + "\"");
        }
        String signatureValue = new SignatureGenerator(this.merchantConfigSigHead).signatureGeneration();
        this.signatureHeader.append(", signature=\"" + signatureValue + "\"");
        return this.signatureHeader.toString();
    }

    private String getRequestHeaders(String requestType) {
        String requestHeader = null;
        switch (requestType) {
            case "GET": {
                requestHeader = "host date request-target v-c-merchant-id";
                break;
            }
            case "DELETE": {
                requestHeader = "host date request-target v-c-merchant-id";
                break;
            }
            case "POST": {
                requestHeader = "host date request-target digest v-c-merchant-id";
                break;
            }
            case "PUT": {
                requestHeader = "host date request-target digest v-c-merchant-id";
                break;
            }
            case "PATCH": {
                requestHeader = "host date request-target digest v-c-merchant-id";
                break;
            }
            default: {
                return requestHeader;
            }
        }
        return requestHeader;
    }
}

