/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.authsdk.cache;

import com.cybersource.authsdk.cache.CachedJWEPrivateKey;
import com.cybersource.authsdk.cache.Identity;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.jwt.KeyCertificateGenerator;
import com.cybersource.authsdk.util.JWEUtility;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Cache {
    private static Logger logger = LogManager.getLogger(Cache.class);
    public static boolean isCache = false;
    public static ConcurrentHashMap<String, Identity> cacheP12 = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, CachedJWEPrivateKey> cachePEM = new ConcurrentHashMap();
    private boolean isTimeStamp;
    private MerchantConfig merchantConfig;
    private Identity identity = new Identity();
    private CachedJWEPrivateKey cachedJWEPrivateKey = new CachedJWEPrivateKey();
    private String accessToken;
    private String refreshToken;

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setMerchantConfig(MerchantConfig merchantConfig) {
        this.merchantConfig = merchantConfig;
    }

    public Cache(MerchantConfig merchantConfig) {
        this.merchantConfig = merchantConfig;
        logger = LogManager.getLogger(this.getClass());
        isCache = cacheP12.isEmpty();
    }

    public Cache() {
    }

    private void setUpP12Cache() throws Exception {
        KeyCertificateGenerator newKeyCertGen = new KeyCertificateGenerator();
        X509Certificate jwtX509Certificate = newKeyCertGen.initializeCertificateOfMerchantForJWT(this.merchantConfig);
        RSAPrivateKey jwtRsaPrivateKey = newKeyCertGen.initializePrivateKey(this.merchantConfig);
        X509Certificate mleX509Certificate = newKeyCertGen.initializeMLECertificate(this.merchantConfig);
        this.identity.setLastModifiedDate(this.getLastModifiedFileTime(this.merchantConfig.getKeyFile().getAbsolutePath()));
        this.identity.setX509(jwtX509Certificate);
        this.identity.setRsaPrivateKey(jwtRsaPrivateKey);
        this.identity.setMleCert(mleX509Certificate);
        String tempMerchantID = this.merchantConfig.getMerchantID();
        cacheP12.put(tempMerchantID, this.identity);
    }

    public Identity getMerchantP12KeysFromCache() throws Exception {
        Identity p12Keys;
        if (cacheP12.isEmpty()) {
            logger.info(" Empty Cache :: Adding Data");
            this.setUpP12Cache();
        } else {
            p12Keys = cacheP12.get(this.merchantConfig.getMerchantID());
            if (p12Keys.getLastModifiedDate() != this.getLastModifiedFileTime(this.merchantConfig.getKeyFile().getAbsolutePath())) {
                logger.info(" New Data present:: Inserting Data in Cache");
                this.setUpP12Cache();
            } else {
                logger.info(" Data present in Cache :: Extracting Data");
            }
        }
        p12Keys = cacheP12.get(this.merchantConfig.getMerchantID());
        return p12Keys;
    }

    public PrivateKey getJWECachedPrivateKey() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        CachedJWEPrivateKey cachedJWEPrivateKey;
        if (cachePEM.isEmpty()) {
            this.setUpPEMCache();
        } else {
            cachedJWEPrivateKey = cachePEM.get("privateKeyFromPEMFile");
            if (cachedJWEPrivateKey.getLastModifiedTimeStamp() != this.getLastModifiedFileTime(this.merchantConfig.getPemFileDirectory())) {
                this.setUpPEMCache();
            }
        }
        cachedJWEPrivateKey = cachePEM.get("privateKeyFromPEMFile");
        return cachedJWEPrivateKey.getPrivateKey();
    }

    private void setUpPEMCache() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        PrivateKey privateKey = JWEUtility.readPemFileToGetPrivateKey(this.merchantConfig.getPemFileDirectory());
        long lastModifiedTime = this.getLastModifiedFileTime(this.merchantConfig.getPemFileDirectory());
        this.cachedJWEPrivateKey.setLastModifiedTimeStamp(lastModifiedTime);
        this.cachedJWEPrivateKey.setPrivateKey(privateKey);
        cachePEM.put("privateKeyFromPEMFile", this.cachedJWEPrivateKey);
    }

    public long getLastModifiedFileTime(String path) {
        try {
            File f = new File(path);
            return f.lastModified();
        }
        catch (Exception e) {
            logger.error((Object)e);
            return (Long)null;
        }
    }
}

