/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.authsdk.jwt;

import com.cybersource.authsdk.cache.Cache;
import com.cybersource.authsdk.cache.Identity;
import com.cybersource.authsdk.core.ConfigException;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.core.TokenGenerator;
import com.cybersource.authsdk.jwtsecurity.JWTCryptoProcessorImpl;
import com.cybersource.authsdk.util.GlobalLabelParameters;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JwtSignatureToken
implements TokenGenerator {
    private static Logger logger = LogManager.getLogger(JwtSignatureToken.class);
    private MerchantConfig merchantConfig;
    private String requestBody;
    private String jwtMethod;
    private Cache cache;
    private RSAPrivateKey rsaPrivateKey = null;
    private X509Certificate x509Certificate = null;
    private String signature;

    public JwtSignatureToken(MerchantConfig merchantConfig, String requestBody, String reqVerb) {
        this.merchantConfig = merchantConfig;
        this.requestBody = requestBody;
        this.jwtMethod = reqVerb;
        this.cache = new Cache(this.merchantConfig);
    }

    @Override
    public String getToken() {
        try {
            this.signature = this.generateSignature();
        }
        catch (Exception e) {
            this.signature = null;
        }
        return this.signature;
    }

    public String generateSignature() throws Exception {
        block9: {
            try {
                if (this.merchantConfig != null) {
                    this.getKeysForJWTFromCache();
                    String encryptedSigMessage = "";
                    if (this.requestBody != null && !this.requestBody.isEmpty()) {
                        MessageDigest jwtBody = MessageDigest.getInstance(GlobalLabelParameters.SHA_256);
                        byte[] jwtClaimSetBody = jwtBody.digest(this.requestBody.getBytes());
                        encryptedSigMessage = Base64.getEncoder().encodeToString(jwtClaimSetBody);
                    }
                    String claimSet = null;
                    String method = this.jwtMethod;
                    if (method.equalsIgnoreCase("GET") || method.equalsIgnoreCase("DELETE")) {
                        claimSet = "{\n            \"iat\":\"" + ZonedDateTime.now().format(DateTimeFormatter.ISO_INSTANT) + "\"\n} \n\n";
                    } else if (method.equalsIgnoreCase("POST") || method.equalsIgnoreCase("PUT") || method.equalsIgnoreCase("PATCH")) {
                        claimSet = "{\n            \"digest\":\"" + encryptedSigMessage + "\",\n            \"digestAlgorithm\":\"SHA-256\",\n            \"iat\":\"" + ZonedDateTime.now().format(DateTimeFormatter.ISO_INSTANT) + "\"\n} \n\n";
                    }
                    HashMap<String, Object> customHeaders = new HashMap<String, Object>();
                    if (this.merchantConfig.getMerchantID() != null) {
                        customHeaders.put(JWTCryptoProcessorImpl.MERCHANT_ID, this.merchantConfig.getMerchantID());
                    }
                    String authType = this.merchantConfig.getAuthenticationType().trim();
                    JWTCryptoProcessorImpl jwtCryptoProcessor = new JWTCryptoProcessorImpl();
                    if ("JWT".equalsIgnoreCase(authType)) {
                        this.signature = jwtCryptoProcessor.sign(claimSet, this.rsaPrivateKey, this.x509Certificate, customHeaders);
                    }
                    break block9;
                }
                throw new ConfigException("merchant config fields missing: keyType, key type");
            }
            catch (Exception e) {
                logger.fatal("JWT Signature production failed.");
                logger.error((Object)e);
                this.signature = null;
            }
        }
        return this.signature;
    }

    private void getKeysForJWTFromCache() throws ConfigException, Exception {
        Identity p12Keys = this.cache.getMerchantP12KeysFromCache();
        this.rsaPrivateKey = p12Keys.getRsaPrivateKey();
        this.x509Certificate = p12Keys.getX509();
    }
}

