/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.authsdk.core;

import com.cybersource.authsdk.core.ConfigException;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.core.TokenGenerator;
import com.cybersource.authsdk.http.HttpSignatureToken;
import com.cybersource.authsdk.jwt.JwtSignatureToken;
import com.cybersource.authsdk.oauth.OAuthToken;

public class TokenGeneratorFactory {
    public static TokenGenerator getAuthToken(MerchantConfig merchantConfig, String requestBody, String reqVerb, String reqTarget, String date) throws ConfigException {
        String authType = merchantConfig.getAuthenticationType();
        if (authType.equalsIgnoreCase("HTTP_Signature")) {
            return new HttpSignatureToken(merchantConfig, requestBody, reqVerb, reqTarget, date);
        }
        if (authType.equalsIgnoreCase("JWT")) {
            return new JwtSignatureToken(merchantConfig, requestBody, reqVerb);
        }
        if (authType.equalsIgnoreCase("OAuth")) {
            return new OAuthToken(merchantConfig);
        }
        return null;
    }
}

