/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.authsdk.cache;

import com.cybersource.authsdk.cache.CachedJWEPrivateKey;
import com.cybersource.authsdk.cache.Identity;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.jwt.KeyCertificateGenerator;
import com.cybersource.authsdk.util.JWEUtility;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Cache {
    private static Logger logger = LogManager.getLogger(Cache.class);
    public static ConcurrentHashMap<String, Identity> cacheP12 = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, CachedJWEPrivateKey> cachePEM = new ConcurrentHashMap();

    private void setUpP12Cache(MerchantConfig merchantConfig) throws Exception {
        KeyCertificateGenerator newKeyCertGen = new KeyCertificateGenerator();
        X509Certificate jwtX509Certificate = newKeyCertGen.initializeCertificateOfMerchantForJWT(merchantConfig);
        RSAPrivateKey jwtRsaPrivateKey = newKeyCertGen.initializePrivateKey(merchantConfig);
        X509Certificate mleX509Certificate = newKeyCertGen.initializeMLECertificate(merchantConfig);
        Identity identity = new Identity();
        identity.setLastModifiedDate(this.getLastModifiedFileTime(merchantConfig.getKeyFile().getAbsolutePath()));
        identity.setX509(jwtX509Certificate);
        identity.setRsaPrivateKey(jwtRsaPrivateKey);
        identity.setMleCert(mleX509Certificate);
        String tempMerchantID = merchantConfig.getMerchantID();
        cacheP12.put(tempMerchantID, identity);
    }

    public Identity getMerchantP12KeysFromCache(MerchantConfig merchantConfig) throws Exception {
        Identity p12Keys;
        if (cacheP12.isEmpty() || !cacheP12.containsKey(merchantConfig.getMerchantID())) {
            logger.info(" Missing Key in Cache :: Adding Data");
            this.setUpP12Cache(merchantConfig);
        } else {
            p12Keys = cacheP12.get(merchantConfig.getMerchantID());
            if (p12Keys == null || p12Keys.getLastModifiedDate() != this.getLastModifiedFileTime(merchantConfig.getKeyFile().getAbsolutePath())) {
                logger.info(" New Data present:: Inserting Data in Cache");
                this.setUpP12Cache(merchantConfig);
            } else {
                logger.info(" Data present in Cache :: Extracting Data");
            }
        }
        p12Keys = cacheP12.get(merchantConfig.getMerchantID());
        return p12Keys;
    }

    public PrivateKey getJWECachedPrivateKey(MerchantConfig merchantConfig) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        CachedJWEPrivateKey cachedJWEPrivateKey;
        if (cachePEM.isEmpty()) {
            this.setUpPEMCache(merchantConfig);
        } else {
            cachedJWEPrivateKey = cachePEM.get("privateKeyFromPEMFile");
            if (cachedJWEPrivateKey.getLastModifiedTimeStamp() != this.getLastModifiedFileTime(merchantConfig.getPemFileDirectory())) {
                this.setUpPEMCache(merchantConfig);
            }
        }
        cachedJWEPrivateKey = cachePEM.get("privateKeyFromPEMFile");
        return cachedJWEPrivateKey.getPrivateKey();
    }

    private void setUpPEMCache(MerchantConfig merchantConfig) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        PrivateKey privateKey = JWEUtility.readPemFileToGetPrivateKey(merchantConfig.getPemFileDirectory());
        long lastModifiedTime = this.getLastModifiedFileTime(merchantConfig.getPemFileDirectory());
        CachedJWEPrivateKey cachedJWEPrivateKey = new CachedJWEPrivateKey();
        cachedJWEPrivateKey.setLastModifiedTimeStamp(lastModifiedTime);
        cachedJWEPrivateKey.setPrivateKey(privateKey);
        cachePEM.put("privateKeyFromPEMFile", cachedJWEPrivateKey);
    }

    public long getLastModifiedFileTime(String path) {
        try {
            File f = new File(path);
            return f.lastModified();
        }
        catch (Exception e) {
            logger.error((Object)e);
            return (Long)null;
        }
    }
}

