/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.authsdk.http;

import com.cybersource.authsdk.core.ConfigException;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.payloaddigest.PayloadDigest;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SignatureGenerator {
    private MerchantConfig merchantConfig;
    private String signatureParameterBase64Encoded;
    private String httpMethod;
    private String merchantSecretKey;
    private String merchantId;
    private String portfolioId;
    private boolean useMetaKey;

    public SignatureGenerator(MerchantConfig merchantConfig, String method) throws InvalidKeyException, NoSuchAlgorithmException, ConfigException {
        this.merchantConfig = merchantConfig;
        this.httpMethod = method;
        this.merchantSecretKey = merchantConfig.getMerchantSecretKey();
        this.merchantId = merchantConfig.getMerchantID();
        this.useMetaKey = merchantConfig.isUseMetaKey();
        if (this.useMetaKey) {
            this.portfolioId = merchantConfig.getPortfolioID();
        }
    }

    public String signatureGeneration(String requestData, String reqTarget, String date) throws NoSuchAlgorithmException, InvalidKeyException {
        StringBuilder signatureString = new StringBuilder();
        signatureString.append('\n');
        signatureString.append("Host".toLowerCase());
        signatureString.append(": ");
        signatureString.append(this.merchantConfig.getRequestHost());
        signatureString.append('\n');
        signatureString.append("Date".toLowerCase());
        signatureString.append(": ");
        signatureString.append(date);
        signatureString.append('\n');
        signatureString.append("request-target");
        signatureString.append(": ");
        String requestTarget = null;
        if (this.httpMethod.equalsIgnoreCase("GET")) {
            requestTarget = this.getRequestTarget("GET", reqTarget);
        } else if (this.httpMethod.equalsIgnoreCase("POST")) {
            requestTarget = this.getRequestTarget("POST", reqTarget);
        } else if (this.httpMethod.equalsIgnoreCase("PUT")) {
            requestTarget = this.getRequestTarget("PUT", reqTarget);
        } else if (this.httpMethod.equalsIgnoreCase("DELETE")) {
            requestTarget = this.getRequestTarget("DELETE", reqTarget);
        } else if (this.httpMethod.equalsIgnoreCase("PATCH")) {
            requestTarget = this.getRequestTarget("PATCH", reqTarget);
        }
        signatureString.append(requestTarget);
        signatureString.append('\n');
        if (this.httpMethod.equalsIgnoreCase("POST") || this.httpMethod.equalsIgnoreCase("PUT") || this.httpMethod.equalsIgnoreCase("PATCH")) {
            signatureString.append("Digest".toLowerCase());
            signatureString.append(": ");
            signatureString.append(new PayloadDigest(requestData).getDigest());
            signatureString.append('\n');
        }
        signatureString.append("v-c-merchant-id");
        signatureString.append(": ");
        if (this.useMetaKey) {
            signatureString.append(this.portfolioId);
        } else {
            signatureString.append(this.merchantId);
        }
        signatureString.delete(0, 1);
        String signatureStr = signatureString.toString();
        SecretKeySpec secretKey = new SecretKeySpec(Base64.getDecoder().decode(this.merchantSecretKey), "HmacSHA256");
        Mac aKeyId = Mac.getInstance("HmacSHA256");
        aKeyId.init(secretKey);
        aKeyId.update(signatureStr.getBytes());
        byte[] aHeaders = aKeyId.doFinal();
        this.signatureParameterBase64Encoded = Base64.getEncoder().encodeToString(aHeaders);
        secretKey = null;
        return this.signatureParameterBase64Encoded;
    }

    public String getRequestTarget(String requestType, String reqTarget) {
        String requestTarget;
        switch (requestType) {
            case "POST": {
                requestTarget = "POST".toLowerCase() + " " + reqTarget;
                break;
            }
            case "GET": {
                requestTarget = "GET".toLowerCase() + " " + reqTarget;
                break;
            }
            case "PUT": {
                requestTarget = "PUT".toLowerCase() + " " + reqTarget;
                break;
            }
            case "DELETE": {
                requestTarget = "DELETE".toLowerCase() + " " + reqTarget;
                break;
            }
            case "PATCH": {
                requestTarget = "PATCH".toLowerCase() + " " + reqTarget;
                break;
            }
            default: {
                requestTarget = null;
            }
        }
        return requestTarget;
    }
}

