/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.authsdk.util;

import java.security.cert.X509Certificate;
import java.util.StringTokenizer;

public class Utility {
    public static boolean checkAuthenticationValidation(String authenticationType) {
        boolean status = false;
        if (authenticationType.equalsIgnoreCase(validationType.HTTP_SIGNATURE.toString()) || authenticationType.equalsIgnoreCase(validationType.JWT.toString())) {
            status = true;
        }
        return status;
    }

    public static String retrieveGetIDFromRequestTarget(String requestTarget) {
        StringTokenizer str = new StringTokenizer(requestTarget, "/");
        String temp = null;
        while (str.hasMoreTokens()) {
            temp = str.nextToken();
            if (!temp.matches("^[0-9]+$")) continue;
            return temp;
        }
        return temp;
    }

    public static String extractSerialNumber(X509Certificate x509Certificate) {
        String serialNumber = null;
        String serialNumberPrefix = "SERIALNUMBER=";
        String principal = x509Certificate.getSubjectDN().getName().toUpperCase();
        int beg = principal.indexOf(serialNumberPrefix);
        if (beg >= 0) {
            int end = principal.indexOf(",", beg);
            if (end == -1) {
                end = principal.length();
            }
            serialNumber = principal.substring(beg + serialNumberPrefix.length(), end);
        } else {
            serialNumber = x509Certificate.getSerialNumber().toString();
        }
        return serialNumber;
    }

    private static enum validationType {
        HTTP_SIGNATURE,
        JWT;

    }
}

