/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.authsdk.cache;

import com.cybersource.authsdk.cache.CachedJWEPrivateKey;
import com.cybersource.authsdk.cache.Identity;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.jwt.KeyCertificateGenerator;
import com.cybersource.authsdk.util.JWEUtility;
import com.cybersource.authsdk.util.Utility;
import com.cybersource.authsdk.util.mle.MLEException;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Cache {
    private static Logger logger = LogManager.getLogger(Cache.class);
    public static ConcurrentHashMap<String, Identity> cacheP12 = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, CachedJWEPrivateKey> cachePEM = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Identity> cacheMLE = new ConcurrentHashMap();

    private void setUpP12Cache(MerchantConfig merchantConfig) throws Exception {
        KeyCertificateGenerator newKeyCertGen = new KeyCertificateGenerator();
        X509Certificate jwtX509Certificate = newKeyCertGen.initializeCertificateOfMerchantForJWT(merchantConfig);
        RSAPrivateKey jwtRsaPrivateKey = newKeyCertGen.initializePrivateKey(merchantConfig);
        Identity identity = new Identity();
        identity.setLastModifiedDate(this.getLastModifiedFileTime(merchantConfig.getKeyFile().getAbsolutePath()));
        identity.setX509(jwtX509Certificate);
        identity.setRsaPrivateKey(jwtRsaPrivateKey);
        String tempMerchantID = merchantConfig.getMerchantID();
        cacheP12.put(tempMerchantID, identity);
    }

    public Identity getMerchantP12KeysFromCache(MerchantConfig merchantConfig) throws Exception {
        Identity p12Keys;
        if (cacheP12.isEmpty() || !cacheP12.containsKey(merchantConfig.getMerchantID())) {
            logger.info(" Missing Key in Cache :: Adding Data");
            this.setUpP12Cache(merchantConfig);
        } else {
            p12Keys = cacheP12.get(merchantConfig.getMerchantID());
            if (p12Keys == null || p12Keys.getLastModifiedDate() != this.getLastModifiedFileTime(merchantConfig.getKeyFile().getAbsolutePath())) {
                logger.info(" New Data present:: Inserting Data in Cache");
                this.setUpP12Cache(merchantConfig);
            } else {
                logger.info(" Data present in Cache :: Extracting Data");
            }
        }
        p12Keys = cacheP12.get(merchantConfig.getMerchantID());
        return p12Keys;
    }

    public X509Certificate getRequestMLECertFromCache(MerchantConfig merchantConfig) throws MLEException {
        String merchantId = merchantConfig.getMerchantID();
        String identifier = "";
        String cacheKey = "";
        String filePath = "";
        if (!StringUtils.isEmpty((CharSequence)merchantConfig.getMleForRequestPublicCertPath())) {
            identifier = "mleCertFromMerchantConfig";
            cacheKey = merchantId + "_" + identifier;
            filePath = merchantConfig.getMleForRequestPublicCertPath();
        } else if ("JWT".equalsIgnoreCase(merchantConfig.getAuthenticationType()) && merchantConfig.getKeyFile() != null) {
            identifier = "mleCertFromP12";
            cacheKey = merchantId + "_" + identifier;
            filePath = merchantConfig.getKeyFile().getAbsolutePath();
        } else {
            logger.debug("The certificate to use for MLE for requests is not provided in the merchant configuration. Please ensure that the certificate path is provided.");
            return null;
        }
        X509Certificate mleCert = this.getMLECertBasedOnCacheKey(merchantConfig, cacheKey, filePath);
        Utility.validateCertificateExpiry(mleCert, merchantConfig.getMleKeyAlias(), identifier);
        return mleCert;
    }

    private X509Certificate getMLECertBasedOnCacheKey(MerchantConfig merchantConfig, String cacheKey, String filePath) throws MLEException {
        if (!cacheMLE.containsKey(cacheKey)) {
            this.setUpMLECache(merchantConfig, cacheKey, filePath);
        } else {
            Identity mleIdentity = cacheMLE.get(cacheKey);
            if (mleIdentity == null || mleIdentity.getLastModifiedDate() != this.getLastModifiedFileTime(filePath)) {
                this.setUpMLECache(merchantConfig, cacheKey, filePath);
            }
        }
        return cacheMLE.get(cacheKey).getMleCert();
    }

    private void setUpMLECache(MerchantConfig merchantConfig, String cacheKey, String filePath) throws MLEException {
        X509Certificate mleCert = null;
        if (cacheKey.endsWith("mleCertFromMerchantConfig")) {
            try {
                Collection<X509Certificate> certs = Utility.loadCertificatesFromPemFile(filePath);
                mleCert = Utility.searchCertificateByAlias(certs, merchantConfig.getMleKeyAlias());
                if (mleCert == null) {
                    String fileName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
                    logger.warn("No certificate found for the specified mleKeyAlias '{}'. Using the first certificate from file {} as the MLE request certificate.", (Object)merchantConfig.getMleKeyAlias(), (Object)fileName);
                    mleCert = certs.iterator().next();
                }
            }
            catch (Exception e) {
                throw new MLEException("Error occurred while loading MLE certificate for Request from requestPublicCertPath in Merchant Config: " + e.getMessage(), e);
            }
        }
        if (cacheKey.endsWith("mleCertFromP12")) {
            try {
                KeyCertificateGenerator newKeyCertGen = new KeyCertificateGenerator();
                mleCert = newKeyCertGen.initializeMLECertificate(merchantConfig);
            }
            catch (Exception e) {
                throw new MLEException("Error occurred while loading MLE certificate for Request from MerchantP12 in Merchant Config: " + e.getMessage(), e);
            }
        }
        Identity mleIdentity = new Identity();
        mleIdentity.setLastModifiedDate(this.getLastModifiedFileTime(filePath));
        mleIdentity.setMleCert(mleCert);
        cacheMLE.put(cacheKey, mleIdentity);
    }

    public PrivateKey getJWECachedPrivateKey(MerchantConfig merchantConfig) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        CachedJWEPrivateKey cachedJWEPrivateKey;
        if (cachePEM.isEmpty()) {
            this.setUpPEMCache(merchantConfig);
        } else {
            cachedJWEPrivateKey = cachePEM.get("privateKeyFromPEMFile");
            if (cachedJWEPrivateKey.getLastModifiedTimeStamp() != this.getLastModifiedFileTime(merchantConfig.getPemFileDirectory())) {
                this.setUpPEMCache(merchantConfig);
            }
        }
        cachedJWEPrivateKey = cachePEM.get("privateKeyFromPEMFile");
        return cachedJWEPrivateKey.getPrivateKey();
    }

    private void setUpPEMCache(MerchantConfig merchantConfig) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        PrivateKey privateKey = JWEUtility.readPemFileToGetPrivateKey(merchantConfig.getPemFileDirectory());
        long lastModifiedTime = this.getLastModifiedFileTime(merchantConfig.getPemFileDirectory());
        CachedJWEPrivateKey cachedJWEPrivateKey = new CachedJWEPrivateKey();
        cachedJWEPrivateKey.setLastModifiedTimeStamp(lastModifiedTime);
        cachedJWEPrivateKey.setPrivateKey(privateKey);
        cachePEM.put("privateKeyFromPEMFile", cachedJWEPrivateKey);
    }

    public long getLastModifiedFileTime(String path) {
        try {
            File f = new File(path);
            return f.lastModified();
        }
        catch (Exception e) {
            logger.error((Object)e);
            return (Long)null;
        }
    }
}

