/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.authsdk.util;

import com.cybersource.authsdk.util.GlobalLabelParameters;
import com.cybersource.authsdk.util.mle.MLEException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Utility {
    private static final Logger logger = LogManager.getLogger(Utility.class);

    public static boolean checkAuthenticationValidation(String authenticationType) {
        boolean status = false;
        if (authenticationType.equalsIgnoreCase(validationType.HTTP_SIGNATURE.toString()) || authenticationType.equalsIgnoreCase(validationType.JWT.toString())) {
            status = true;
        }
        return status;
    }

    public static String retrieveGetIDFromRequestTarget(String requestTarget) {
        StringTokenizer str = new StringTokenizer(requestTarget, "/");
        String temp = null;
        while (str.hasMoreTokens()) {
            temp = str.nextToken();
            if (!temp.matches("^[0-9]+$")) continue;
            return temp;
        }
        return temp;
    }

    public static String extractSerialNumber(X509Certificate x509Certificate) {
        String serialNumber = null;
        String serialNumberPrefix = "SERIALNUMBER=";
        String principal = x509Certificate.getSubjectDN().getName().toUpperCase();
        int beg = principal.indexOf(serialNumberPrefix);
        if (beg >= 0) {
            int end = principal.indexOf(",", beg);
            if (end == -1) {
                end = principal.length();
            }
            serialNumber = principal.substring(beg + serialNumberPrefix.length(), end);
        } else {
            serialNumber = x509Certificate.getSerialNumber().toString();
        }
        return serialNumber;
    }

    public static void validatePathAndFile(String filePath, String pathType) throws IOException {
        Path path;
        if (filePath == null || filePath.trim().isEmpty()) {
            logger.error(pathType + " path cannot be null or empty");
            throw new IllegalArgumentException(pathType + " path cannot be null or empty");
        }
        String normalizedPath = filePath;
        if (File.separatorChar == '\\' && normalizedPath.matches("^/[A-Za-z]:.*")) {
            normalizedPath = normalizedPath.substring(1);
        }
        if (!Files.exists(path = Paths.get(normalizedPath, new String[0]), new LinkOption[0])) {
            logger.error(pathType + " does not exist: " + path);
            throw new IOException(pathType + " does not exist: " + path);
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            logger.error(pathType + " does not have valid file: " + path);
            throw new IOException(pathType + " does not have valid file: " + path);
        }
        if (!Files.isReadable(path)) {
            logger.error(pathType + " is not readable: " + path);
            throw new IOException(pathType + " is not readable: " + path);
        }
    }

    public static Collection<X509Certificate> loadCertificatesFromPemFile(String certFilePath) throws CertificateException, IOException {
        try (FileInputStream inStream = new FileInputStream(certFilePath);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certs = cf.generateCertificates(inStream);
            ArrayList<X509Certificate> x509Certs = new ArrayList<X509Certificate>();
            for (Certificate certificate : certs) {
                x509Certs.add((X509Certificate)certificate);
            }
            ArrayList<X509Certificate> arrayList = x509Certs;
            return arrayList;
        }
    }

    public static X509Certificate searchCertificateByAlias(Collection<X509Certificate> certs, String keyAlias) {
        if (certs == null || keyAlias == null || keyAlias.isEmpty()) {
            return null;
        }
        for (X509Certificate cert : certs) {
            try {
                String[] dnParts;
                String subjectDN = cert.getSubjectDN().getName();
                for (String part : dnParts = subjectDN.split(",")) {
                    String commonName;
                    if (!(part = part.trim()).toUpperCase().startsWith("CN=") || !keyAlias.equalsIgnoreCase(commonName = part.substring(3))) continue;
                    return cert;
                }
            }
            catch (Exception e) {
                logger.warn("Error parsing certificate subject DN: " + e.getMessage());
            }
        }
        return null;
    }

    public static void validateCertificateExpiry(X509Certificate certificate, String keyAlias, String mleCacheKeyIdentifier) throws MLEException {
        String warnMessageForNotHaveExpiryDate = "Certificate don't have expiry date.";
        String warnMessageForBeingExpiredCert = "Certificate with alias {} is going to expired on {} . Please update cert before that.";
        String warnMessageForExpiredCert = "Certificate with alias {} is expired as of {} . Please update cert before that.";
        if ("mleCertFromMerchantConfig".equals(mleCacheKeyIdentifier)) {
            warnMessageForNotHaveExpiryDate = "Certificate for Request MLE don't have expiry date from mleForRequestPublicCertPath in merchant config.";
            warnMessageForBeingExpiredCert = "Certificate for Request MLE with alias {} is going to expired on {} . Please update cert file in mleForRequestPublicCertPath in merchant config before that.";
            warnMessageForExpiredCert = "Certificate for Request MLE with alias {} is expired as of {} . Please update cert file in mleForRequestPublicCertPath in merchant config.";
        }
        if ("mleCertFromP12".equals(mleCacheKeyIdentifier)) {
            warnMessageForNotHaveExpiryDate = "Certificate for Request MLE don't have expiry date in p12 file.";
            warnMessageForBeingExpiredCert = "Certificate for Request MLE with alias {} is going to expired on {} . Please update p12 file before that.";
            warnMessageForExpiredCert = "Certificate for Request MLE with alias {} is expired as of {} . Please update p12 file.";
        }
        if (certificate.getNotAfter() == null) {
            logger.warn(warnMessageForNotHaveExpiryDate);
        } else if (certificate.getNotAfter().before(new Date())) {
            logger.warn(warnMessageForExpiredCert, (Object)keyAlias, (Object)certificate.getNotAfter());
        } else {
            long timeToExpire = certificate.getNotAfter().getTime() - new Date().getTime();
            if (timeToExpire < GlobalLabelParameters.CERTIFICATE_EXPIRY_DATE_WARNING_DAYS * 24L * 60L * 60L) {
                logger.warn(warnMessageForBeingExpiredCert, (Object)keyAlias, (Object)certificate.getNotAfter());
            }
        }
    }

    private static enum validationType {
        HTTP_SIGNATURE,
        JWT;

    }
}

