/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.authsdk.util.mle;

import com.cybersource.authsdk.cache.Cache;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.util.Utility;
import com.cybersource.authsdk.util.mle.MLEException;
import com.google.gson.Gson;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.RSAEncrypter;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minidev.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MLEUtility {
    private static final Logger logger = LogManager.getLogger(MLEUtility.class);
    private static Cache cache = new Cache();

    public static boolean checkIsMLEForAPI(MerchantConfig merchantConfig, String inboundMLEStatus, String operationIds) {
        boolean isMLEForAPI = false;
        if ("optional".equalsIgnoreCase(inboundMLEStatus) && merchantConfig.isEnableRequestMLEForOptionalApisGlobally()) {
            isMLEForAPI = true;
        }
        if ("mandatory".equalsIgnoreCase(inboundMLEStatus)) {
            isMLEForAPI = !merchantConfig.isDisableRequestMLEForMandatoryApisGlobally();
        }
        String[] operationArray = (String[])Arrays.stream(operationIds.split(",")).map(String::trim).toArray(String[]::new);
        if (merchantConfig.getMapToControlMLEonAPI() != null && !merchantConfig.getMapToControlMLEonAPI().isEmpty()) {
            for (String operationId : operationArray) {
                if (!merchantConfig.getMapToControlMLEonAPI().containsKey(operationId)) continue;
                isMLEForAPI = merchantConfig.getMapToControlMLEonAPI().get(operationId);
                break;
            }
        }
        return isMLEForAPI;
    }

    public static Object encryptRequestPayload(MerchantConfig merchantConfig, Object localVarPostBody) throws MLEException {
        if (localVarPostBody == null) {
            return null;
        }
        X509Certificate mleCertificate = MLEUtility.getCertificate(merchantConfig);
        if (mleCertificate == null && "HTTP_Signature".equalsIgnoreCase(merchantConfig.getAuthenticationType())) {
            logger.debug("The certificate to use for MLE for requests is not provided in the merchant configuration. Please ensure that the certificate path is provided.");
            logger.warn("Currently, MLE for requests using HTTP Signature as authentication is not supported by Cybersource. By default, the SDK will fall back to non-encrypted requests.");
            return localVarPostBody;
        }
        String payload = new Gson().toJson(localVarPostBody);
        logger.debug("LOG_REQUEST_BEFORE_MLE: " + payload);
        HashMap<String, Object> customHeaders = new HashMap<String, Object>();
        customHeaders.put("iat", ZonedDateTime.now().toInstant().getEpochSecond());
        String encryptedPayload = MLEUtility.encryptAttributeWithAlgo(payload, mleCertificate, customHeaders);
        JSONObject mleRequest = MLEUtility.createJsonObject(encryptedPayload);
        logger.debug("LOG_REQUEST_AFTER_MLE: " + new Gson().toJson((Object)mleRequest));
        return mleRequest;
    }

    private static X509Certificate getCertificate(MerchantConfig merchantConfig) throws MLEException {
        X509Certificate mleCert = null;
        mleCert = cache.getRequestMLECertFromCache(merchantConfig);
        if (null != mleCert) {
            return mleCert;
        }
        if ("HTTP_Signature".equalsIgnoreCase(merchantConfig.getAuthenticationType())) {
            return null;
        }
        throw new MLEException("No certificate found for MLE Request");
    }

    private static String encryptAttributeWithAlgo(String content, X509Certificate x509Certificate, Map<String, Object> customHeaders) throws MLEException {
        String serialNumber = Utility.extractSerialNumber(x509Certificate);
        if (serialNumber == null) {
            throw new MLEException("No serial number found in certificate for MLE");
        }
        JWEObject jweObject = new JWEObject(new JWEHeader.Builder(JWEAlgorithm.RSA_OAEP_256, EncryptionMethod.A256GCM).contentType("JWT").keyID(Utility.extractSerialNumber(x509Certificate)).customParams(customHeaders).build(), new Payload(content));
        try {
            jweObject.encrypt((JWEEncrypter)new RSAEncrypter((RSAPublicKey)x509Certificate.getPublicKey()));
            return jweObject.serialize();
        }
        catch (JOSEException e) {
            throw new MLEException("Failed to encrypt payload for MLE", e);
        }
    }

    private static JSONObject createJsonObject(String jweToken) {
        JSONObject json = new JSONObject();
        json.put((Object)"encryptedRequest", (Object)jweToken);
        return json;
    }
}

