/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.TssV2TransactionsGet200Response;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class TransactionDetailsApi {
    private ApiClient apiClient;

    public TransactionDetailsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TransactionDetailsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getTransactionCall(String id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tss/v2/transactions/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTransactionValidateBeforeCall(String id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getTransaction(Async)");
        }
        Call call = this.getTransactionCall(id, progressListener, progressRequestListener);
        return call;
    }

    public TssV2TransactionsGet200Response getTransaction(String id) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<TssV2TransactionsGet200Response> resp = this.getTransactionWithHttpInfo(id);
        return resp.getData();
    }

    public ApiResponse<TssV2TransactionsGet200Response> getTransactionWithHttpInfo(String id) throws ApiException {
        Call call = this.getTransactionValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<TssV2TransactionsGet200Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTransactionAsync(String id, final ApiCallback<TssV2TransactionsGet200Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTransactionValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TssV2TransactionsGet200Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

