/*
 * Decompiled with CFR 0.152.
 */
package utilities.flex.tokenverification;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Map;
import utilities.flex.exception.FlexEncodingException;
import utilities.flex.exception.FlexException;
import utilities.flex.exception.FlexSDKInternalException;
import utilities.flex.exception.FlexSecurityException;
import utilities.flex.security.Base64;

public class TokenVerificationUtility {
    public boolean verifyToken(PublicKey publicKey, Map<?, ?> postParams) throws FlexException {
        if (postParams == null) {
            throw new FlexSecurityException("A valid Map must be supplied");
        }
        String signature = (String)postParams.get("signature");
        if (signature == null) {
            throw new FlexSecurityException("Missing required field: signature");
        }
        String signedFields = (String)postParams.get("signedFields");
        if (signedFields == null) {
            throw new FlexSecurityException("Missing required field: signedFields");
        }
        StringBuilder sb = new StringBuilder();
        for (String k : signedFields.split(",")) {
            sb.append(',');
            sb.append(postParams.get("" + k));
        }
        String signedValues = sb.substring(1);
        return TokenVerificationUtility.validateTokenSignature(publicKey, signedValues, signature);
    }

    private static boolean validateTokenSignature(PublicKey publicKey, String signedFields, String signature) throws FlexException {
        boolean success = false;
        if (publicKey == null) {
            throw new FlexSecurityException("Must supply a valid PublicKey instance");
        }
        if (signature == null) {
            throw new FlexSecurityException("Missing required field: signature");
        }
        if (signedFields == null) {
            throw new FlexSecurityException("Missing required field: signedFields");
        }
        try {
            Signature signInstance = Signature.getInstance("SHA512withRSA");
            signInstance.initVerify(publicKey);
            signInstance.update(signedFields.getBytes());
            success = signInstance.verify(Base64.decode(signature));
            System.out.println(success);
        }
        catch (IOException e) {
            throw new FlexEncodingException("Unable to decode signature" + e);
        }
        catch (GeneralSecurityException e) {
            throw new FlexSDKInternalException(e);
        }
        return success;
    }
}

