/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.AddNegativeListRequest;
import Model.CreateBundledDecisionManagerCaseRequest;
import Model.FraudMarkingActionRequest;
import Model.RiskV1DecisionsPost201Response;
import Model.RiskV1UpdatePost201Response;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DecisionManagerApi {
    private static Logger logger = LogManager.getLogger(DecisionManagerApi.class);
    private ApiClient apiClient;

    public DecisionManagerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DecisionManagerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addNegativeCall(String type, AddNegativeListRequest addNegativeListRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AddNegativeListRequest localVarPostBody = addNegativeListRequest;
        String localVarPath = "/risk/v1/lists/{type}/entries".replaceAll("\\{type\\}", this.apiClient.escapeString(type.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addNegativeValidateBeforeCall(String type, AddNegativeListRequest addNegativeListRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (type == null) {
            logger.error("Missing the required parameter 'type' when calling addNegative(Async)");
            throw new ApiException("Missing the required parameter 'type' when calling addNegative(Async)");
        }
        if (addNegativeListRequest == null) {
            logger.error("Missing the required parameter 'addNegativeListRequest' when calling addNegative(Async)");
            throw new ApiException("Missing the required parameter 'addNegativeListRequest' when calling addNegative(Async)");
        }
        Call call = this.addNegativeCall(type, addNegativeListRequest, progressListener, progressRequestListener);
        return call;
    }

    public RiskV1UpdatePost201Response addNegative(String type, AddNegativeListRequest addNegativeListRequest) throws ApiException {
        logger.info("CALL TO METHOD 'addNegative' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<RiskV1UpdatePost201Response> resp = this.addNegativeWithHttpInfo(type, addNegativeListRequest);
        logger.info("CALL TO METHOD 'addNegative' ENDED");
        return resp.getData();
    }

    public ApiResponse<RiskV1UpdatePost201Response> addNegativeWithHttpInfo(String type, AddNegativeListRequest addNegativeListRequest) throws ApiException {
        Call call = this.addNegativeValidateBeforeCall(type, addNegativeListRequest, null, null);
        Type localVarReturnType = new TypeToken<RiskV1UpdatePost201Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addNegativeAsync(String type, AddNegativeListRequest addNegativeListRequest, final ApiCallback<RiskV1UpdatePost201Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.addNegativeValidateBeforeCall(type, addNegativeListRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RiskV1UpdatePost201Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createBundledDecisionManagerCaseCall(CreateBundledDecisionManagerCaseRequest createBundledDecisionManagerCaseRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateBundledDecisionManagerCaseRequest localVarPostBody = createBundledDecisionManagerCaseRequest;
        String localVarPath = "/risk/v1/decisions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createBundledDecisionManagerCaseValidateBeforeCall(CreateBundledDecisionManagerCaseRequest createBundledDecisionManagerCaseRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (createBundledDecisionManagerCaseRequest == null) {
            logger.error("Missing the required parameter 'createBundledDecisionManagerCaseRequest' when calling createBundledDecisionManagerCase(Async)");
            throw new ApiException("Missing the required parameter 'createBundledDecisionManagerCaseRequest' when calling createBundledDecisionManagerCase(Async)");
        }
        Call call = this.createBundledDecisionManagerCaseCall(createBundledDecisionManagerCaseRequest, progressListener, progressRequestListener);
        return call;
    }

    public RiskV1DecisionsPost201Response createBundledDecisionManagerCase(CreateBundledDecisionManagerCaseRequest createBundledDecisionManagerCaseRequest) throws ApiException {
        logger.info("CALL TO METHOD 'createBundledDecisionManagerCase' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<RiskV1DecisionsPost201Response> resp = this.createBundledDecisionManagerCaseWithHttpInfo(createBundledDecisionManagerCaseRequest);
        logger.info("CALL TO METHOD 'createBundledDecisionManagerCase' ENDED");
        return resp.getData();
    }

    public ApiResponse<RiskV1DecisionsPost201Response> createBundledDecisionManagerCaseWithHttpInfo(CreateBundledDecisionManagerCaseRequest createBundledDecisionManagerCaseRequest) throws ApiException {
        Call call = this.createBundledDecisionManagerCaseValidateBeforeCall(createBundledDecisionManagerCaseRequest, null, null);
        Type localVarReturnType = new TypeToken<RiskV1DecisionsPost201Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createBundledDecisionManagerCaseAsync(CreateBundledDecisionManagerCaseRequest createBundledDecisionManagerCaseRequest, final ApiCallback<RiskV1DecisionsPost201Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createBundledDecisionManagerCaseValidateBeforeCall(createBundledDecisionManagerCaseRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RiskV1DecisionsPost201Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call fraudUpdateCall(String id, FraudMarkingActionRequest fraudMarkingActionRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        FraudMarkingActionRequest localVarPostBody = fraudMarkingActionRequest;
        String localVarPath = "/risk/v1/decisions/{id}/marking".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call fraudUpdateValidateBeforeCall(String id, FraudMarkingActionRequest fraudMarkingActionRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            logger.error("Missing the required parameter 'id' when calling fraudUpdate(Async)");
            throw new ApiException("Missing the required parameter 'id' when calling fraudUpdate(Async)");
        }
        if (fraudMarkingActionRequest == null) {
            logger.error("Missing the required parameter 'fraudMarkingActionRequest' when calling fraudUpdate(Async)");
            throw new ApiException("Missing the required parameter 'fraudMarkingActionRequest' when calling fraudUpdate(Async)");
        }
        Call call = this.fraudUpdateCall(id, fraudMarkingActionRequest, progressListener, progressRequestListener);
        return call;
    }

    public RiskV1UpdatePost201Response fraudUpdate(String id, FraudMarkingActionRequest fraudMarkingActionRequest) throws ApiException {
        logger.info("CALL TO METHOD 'fraudUpdate' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<RiskV1UpdatePost201Response> resp = this.fraudUpdateWithHttpInfo(id, fraudMarkingActionRequest);
        logger.info("CALL TO METHOD 'fraudUpdate' ENDED");
        return resp.getData();
    }

    public ApiResponse<RiskV1UpdatePost201Response> fraudUpdateWithHttpInfo(String id, FraudMarkingActionRequest fraudMarkingActionRequest) throws ApiException {
        Call call = this.fraudUpdateValidateBeforeCall(id, fraudMarkingActionRequest, null, null);
        Type localVarReturnType = new TypeToken<RiskV1UpdatePost201Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call fraudUpdateAsync(String id, FraudMarkingActionRequest fraudMarkingActionRequest, final ApiCallback<RiskV1UpdatePost201Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.fraudUpdateValidateBeforeCall(id, fraudMarkingActionRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RiskV1UpdatePost201Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

