/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.PatchPaymentInstrumentRequest;
import Model.PostPaymentInstrumentRequest;
import Model.Tmsv2customersEmbeddedDefaultPaymentInstrument;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PaymentInstrumentApi {
    private static Logger logger = LogManager.getLogger(PaymentInstrumentApi.class);
    private ApiClient apiClient;

    public PaymentInstrumentApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PaymentInstrumentApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deletePaymentInstrumentCall(String paymentInstrumentTokenId, String profileId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tms/v1/paymentinstruments/{paymentInstrumentTokenId}".replaceAll("\\{paymentInstrumentTokenId\\}", this.apiClient.escapeString(paymentInstrumentTokenId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deletePaymentInstrumentValidateBeforeCall(String paymentInstrumentTokenId, String profileId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (paymentInstrumentTokenId == null) {
            logger.error("Missing the required parameter 'paymentInstrumentTokenId' when calling deletePaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'paymentInstrumentTokenId' when calling deletePaymentInstrument(Async)");
        }
        Call call = this.deletePaymentInstrumentCall(paymentInstrumentTokenId, profileId, progressListener, progressRequestListener);
        return call;
    }

    public void deletePaymentInstrument(String paymentInstrumentTokenId, String profileId) throws ApiException {
        logger.info("CALL TO METHOD 'deletePaymentInstrument' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        this.deletePaymentInstrumentWithHttpInfo(paymentInstrumentTokenId, profileId);
    }

    public ApiResponse<Void> deletePaymentInstrumentWithHttpInfo(String paymentInstrumentTokenId, String profileId) throws ApiException {
        Call call = this.deletePaymentInstrumentValidateBeforeCall(paymentInstrumentTokenId, profileId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deletePaymentInstrumentAsync(String paymentInstrumentTokenId, String profileId, final ApiCallback<Void> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deletePaymentInstrumentValidateBeforeCall(paymentInstrumentTokenId, profileId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getPaymentInstrumentCall(String paymentInstrumentTokenId, String profileId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tms/v1/paymentinstruments/{paymentInstrumentTokenId}".replaceAll("\\{paymentInstrumentTokenId\\}", this.apiClient.escapeString(paymentInstrumentTokenId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getPaymentInstrumentValidateBeforeCall(String paymentInstrumentTokenId, String profileId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (paymentInstrumentTokenId == null) {
            logger.error("Missing the required parameter 'paymentInstrumentTokenId' when calling getPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'paymentInstrumentTokenId' when calling getPaymentInstrument(Async)");
        }
        Call call = this.getPaymentInstrumentCall(paymentInstrumentTokenId, profileId, progressListener, progressRequestListener);
        return call;
    }

    public Tmsv2customersEmbeddedDefaultPaymentInstrument getPaymentInstrument(String paymentInstrumentTokenId, String profileId) throws ApiException {
        logger.info("CALL TO METHOD 'getPaymentInstrument' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<Tmsv2customersEmbeddedDefaultPaymentInstrument> resp = this.getPaymentInstrumentWithHttpInfo(paymentInstrumentTokenId, profileId);
        logger.info("CALL TO METHOD 'getPaymentInstrument' ENDED");
        return resp.getData();
    }

    public ApiResponse<Tmsv2customersEmbeddedDefaultPaymentInstrument> getPaymentInstrumentWithHttpInfo(String paymentInstrumentTokenId, String profileId) throws ApiException {
        Call call = this.getPaymentInstrumentValidateBeforeCall(paymentInstrumentTokenId, profileId, null, null);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultPaymentInstrument>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getPaymentInstrumentAsync(String paymentInstrumentTokenId, String profileId, final ApiCallback<Tmsv2customersEmbeddedDefaultPaymentInstrument> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPaymentInstrumentValidateBeforeCall(paymentInstrumentTokenId, profileId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultPaymentInstrument>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchPaymentInstrumentCall(String paymentInstrumentTokenId, PatchPaymentInstrumentRequest patchPaymentInstrumentRequest, String profileId, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        PatchPaymentInstrumentRequest localVarPostBody = patchPaymentInstrumentRequest;
        String localVarPath = "/tms/v1/paymentinstruments/{paymentInstrumentTokenId}".replaceAll("\\{paymentInstrumentTokenId\\}", this.apiClient.escapeString(paymentInstrumentTokenId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        if (ifMatch != null) {
            localVarHeaderParams.put("if-match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchPaymentInstrumentValidateBeforeCall(String paymentInstrumentTokenId, PatchPaymentInstrumentRequest patchPaymentInstrumentRequest, String profileId, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (paymentInstrumentTokenId == null) {
            logger.error("Missing the required parameter 'paymentInstrumentTokenId' when calling patchPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'paymentInstrumentTokenId' when calling patchPaymentInstrument(Async)");
        }
        if (patchPaymentInstrumentRequest == null) {
            logger.error("Missing the required parameter 'patchPaymentInstrumentRequest' when calling patchPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'patchPaymentInstrumentRequest' when calling patchPaymentInstrument(Async)");
        }
        Call call = this.patchPaymentInstrumentCall(paymentInstrumentTokenId, patchPaymentInstrumentRequest, profileId, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public Tmsv2customersEmbeddedDefaultPaymentInstrument patchPaymentInstrument(String paymentInstrumentTokenId, PatchPaymentInstrumentRequest patchPaymentInstrumentRequest, String profileId, String ifMatch) throws ApiException {
        logger.info("CALL TO METHOD 'patchPaymentInstrument' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<Tmsv2customersEmbeddedDefaultPaymentInstrument> resp = this.patchPaymentInstrumentWithHttpInfo(paymentInstrumentTokenId, patchPaymentInstrumentRequest, profileId, ifMatch);
        logger.info("CALL TO METHOD 'patchPaymentInstrument' ENDED");
        return resp.getData();
    }

    public ApiResponse<Tmsv2customersEmbeddedDefaultPaymentInstrument> patchPaymentInstrumentWithHttpInfo(String paymentInstrumentTokenId, PatchPaymentInstrumentRequest patchPaymentInstrumentRequest, String profileId, String ifMatch) throws ApiException {
        Call call = this.patchPaymentInstrumentValidateBeforeCall(paymentInstrumentTokenId, patchPaymentInstrumentRequest, profileId, ifMatch, null, null);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultPaymentInstrument>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchPaymentInstrumentAsync(String paymentInstrumentTokenId, PatchPaymentInstrumentRequest patchPaymentInstrumentRequest, String profileId, String ifMatch, final ApiCallback<Tmsv2customersEmbeddedDefaultPaymentInstrument> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchPaymentInstrumentValidateBeforeCall(paymentInstrumentTokenId, patchPaymentInstrumentRequest, profileId, ifMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultPaymentInstrument>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postPaymentInstrumentCall(PostPaymentInstrumentRequest postPaymentInstrumentRequest, String profileId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        PostPaymentInstrumentRequest localVarPostBody = postPaymentInstrumentRequest;
        String localVarPath = "/tms/v1/paymentinstruments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postPaymentInstrumentValidateBeforeCall(PostPaymentInstrumentRequest postPaymentInstrumentRequest, String profileId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (postPaymentInstrumentRequest == null) {
            logger.error("Missing the required parameter 'postPaymentInstrumentRequest' when calling postPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'postPaymentInstrumentRequest' when calling postPaymentInstrument(Async)");
        }
        Call call = this.postPaymentInstrumentCall(postPaymentInstrumentRequest, profileId, progressListener, progressRequestListener);
        return call;
    }

    public Tmsv2customersEmbeddedDefaultPaymentInstrument postPaymentInstrument(PostPaymentInstrumentRequest postPaymentInstrumentRequest, String profileId) throws ApiException {
        logger.info("CALL TO METHOD 'postPaymentInstrument' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<Tmsv2customersEmbeddedDefaultPaymentInstrument> resp = this.postPaymentInstrumentWithHttpInfo(postPaymentInstrumentRequest, profileId);
        logger.info("CALL TO METHOD 'postPaymentInstrument' ENDED");
        return resp.getData();
    }

    public ApiResponse<Tmsv2customersEmbeddedDefaultPaymentInstrument> postPaymentInstrumentWithHttpInfo(PostPaymentInstrumentRequest postPaymentInstrumentRequest, String profileId) throws ApiException {
        Call call = this.postPaymentInstrumentValidateBeforeCall(postPaymentInstrumentRequest, profileId, null, null);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultPaymentInstrument>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postPaymentInstrumentAsync(PostPaymentInstrumentRequest postPaymentInstrumentRequest, String profileId, final ApiCallback<Tmsv2customersEmbeddedDefaultPaymentInstrument> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postPaymentInstrumentValidateBeforeCall(postPaymentInstrumentRequest, profileId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultPaymentInstrument>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

