/*
 * Decompiled with CFR 0.152.
 */
package Invokers;

import Invokers.ApiCallback;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.JSON;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.StringUtil;
import Invokers.auth.ApiKeyAuth;
import Invokers.auth.Authentication;
import Invokers.auth.HttpBasicAuth;
import Invokers.auth.OAuth;
import Model.AccessTokenResponse;
import com.cybersource.authsdk.core.Authorization;
import com.cybersource.authsdk.core.ConfigException;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.payloaddigest.PayloadDigest;
import com.cybersource.authsdk.util.PrettyPrintingMap;
import com.cybersource.authsdk.util.PropertiesUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.EventListener;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal.http.HttpMethod;
import okhttp3.logging.HttpLoggingInterceptor;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import utilities.interceptors.RetryInterceptor;
import utilities.listeners.NetworkEventListener;
import utilities.telemetry.RequestTransactionMetrics;

public class ApiClient {
    public static final double JAVA_VERSION;
    public static final boolean IS_ANDROID;
    public static final int ANDROID_SDK_VERSION;
    private String basePath = "";
    private boolean lenientOnJson = false;
    private boolean debugging = false;
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private String tempFolderPath = null;
    private Map<String, Authentication> authentications;
    private DateFormat dateFormat;
    private DateFormat datetimeFormat;
    private boolean lenientDatetimeFormat;
    private int dateLength;
    private InputStream sslCaCert;
    private boolean verifyingSsl;
    private KeyManager[] keyManagers;
    private String acceptHeader = "";
    private static OkHttpClient httpClient;
    private final OkHttpClient classHttpClient = ApiClient.initializeFinalVariables();
    private JSON json;
    private String versionInfo;
    private static ConnectionPool connectionPool;
    private HttpLoggingInterceptor loggingInterceptor;
    private long computationStartTime;
    private static Logger logger;
    public static final String LENIENT_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public String responseCode;
    public String status;
    public InputStream responseBody;
    public String respBody;
    public MerchantConfig merchantConfig;
    public RequestTransactionMetrics apiRequestMetrics = new RequestTransactionMetrics();

    public static OkHttpClient initializeFinalVariables() {
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
        logging.setLevel(HttpLoggingInterceptor.Level.NONE);
        try {
            return new OkHttpClient.Builder().connectTimeout(1L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).connectionPool(connectionPool).addInterceptor((Interceptor)logging).build();
        }
        catch (Exception ex) {
            logger.error("Error in creating HTTP Client");
            return null;
        }
    }

    public ApiClient() {
        this.versionInfo = this.getClientID();
        try {
            httpClient = this.classHttpClient.newBuilder().retryOnConnectionFailure(true).addInterceptor((Interceptor)new RetryInterceptor(this.apiRequestMetrics)).eventListener((EventListener)new NetworkEventListener(this.getNewRandomId(), System.nanoTime())).build();
        }
        catch (Exception ex) {
            logger.error("Error in creating HTTP Client");
        }
        this.verifyingSsl = true;
        this.json = new JSON(this);
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.initDatetimeFormat();
        this.lenientDatetimeFormat = true;
        this.setUserAgent("Swagger-Codegen/1.0.0/java");
        this.authentications = new HashMap<String, Authentication>();
        this.authentications = Collections.unmodifiableMap(this.authentications);
    }

    private String getClientID() {
        String propertyVersionInfo = null;
        Properties properties = new Properties();
        try {
            properties.load(this.getClass().getClassLoader().getResourceAsStream("cybersource-rest-client-java.properties"));
            propertyVersionInfo = properties.getProperty("sdk.version");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return propertyVersionInfo;
    }

    public ApiClient(MerchantConfig merchantConfig) {
        this();
        boolean useProxy = merchantConfig.isUseProxyEnabled();
        final String username = merchantConfig.getProxyUser();
        final String password = merchantConfig.getProxyPassword();
        int proxyPort = merchantConfig.getProxyPort();
        String proxyHost = merchantConfig.getProxyAddress();
        int connectionTimeout = Math.max(merchantConfig.getUserDefinedConnectionTimeout(), 1);
        int readTimeout = Math.max(merchantConfig.getUserDefinedReadTimeout(), 60);
        int writeTimeout = Math.max(merchantConfig.getUserDefinedWriteTimeout(), 60);
        int keepAliveDuration = Math.max(merchantConfig.getUserDefinedKeepAliveDuration(), 10);
        connectionPool = new ConnectionPool(5, (long)keepAliveDuration, TimeUnit.SECONDS);
        if (useProxy && proxyHost != null && !proxyHost.isEmpty()) {
            Object proxyAuthenticator = username != null && !username.isEmpty() && password != null && !password.isEmpty() ? new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    String credential = Credentials.basic((String)username, (String)password);
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                }
            } : new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    return response.request().newBuilder().build();
                }
            };
            try {
                httpClient = this.classHttpClient.newBuilder().proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort))).proxyAuthenticator(proxyAuthenticator).connectTimeout((long)connectionTimeout, TimeUnit.SECONDS).writeTimeout((long)writeTimeout, TimeUnit.SECONDS).readTimeout((long)readTimeout, TimeUnit.SECONDS).retryOnConnectionFailure(true).addInterceptor((Interceptor)new RetryInterceptor(this.apiRequestMetrics)).connectionPool(connectionPool).eventListener((EventListener)new NetworkEventListener(this.getNewRandomId(), System.nanoTime())).build();
            }
            catch (Exception ex) {
                logger.error("Error in creating HTTP Client");
            }
            this.setHttpClient(httpClient);
        } else {
            try {
                httpClient = this.classHttpClient.newBuilder().connectTimeout((long)connectionTimeout, TimeUnit.SECONDS).writeTimeout((long)writeTimeout, TimeUnit.SECONDS).readTimeout((long)readTimeout, TimeUnit.SECONDS).connectionPool(connectionPool).retryOnConnectionFailure(true).addInterceptor((Interceptor)new RetryInterceptor(this.apiRequestMetrics)).eventListener((EventListener)new NetworkEventListener(this.getNewRandomId(), System.nanoTime())).build();
            }
            catch (Exception ex) {
                logger.error("Error in creating HTTP Client");
            }
            this.setHttpClient(httpClient);
        }
        this.merchantConfig = merchantConfig;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setAcceptHeader(String acceptHeader) {
        this.acceptHeader = acceptHeader;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = this.basePath.concat(this.merchantConfig.getRequestHost().trim());
        return this;
    }

    public OkHttpClient getHttpClient() {
        return httpClient;
    }

    public ApiClient setHttpClient(OkHttpClient httpClient) {
        ApiClient.httpClient = httpClient;
        return this;
    }

    public JSON getJSON() {
        return this.json;
    }

    public ApiClient setJSON(JSON json) {
        this.json = json;
        return this;
    }

    public boolean isVerifyingSsl() {
        return this.verifyingSsl;
    }

    public ApiClient setVerifyingSsl(boolean verifyingSsl) {
        this.verifyingSsl = verifyingSsl;
        this.applySslSettings();
        return this;
    }

    public InputStream getSslCaCert() {
        return this.sslCaCert;
    }

    public ApiClient setSslCaCert(InputStream sslCaCert) {
        this.sslCaCert = sslCaCert;
        this.applySslSettings();
        return this;
    }

    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    public ApiClient setKeyManagers(KeyManager[] managers) {
        this.keyManagers = managers;
        this.applySslSettings();
        return this;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.dateLength = this.dateFormat.format(new Date()).length();
        return this;
    }

    public DateFormat getDatetimeFormat() {
        return this.datetimeFormat;
    }

    public ApiClient setDatetimeFormat(DateFormat datetimeFormat) {
        this.datetimeFormat = datetimeFormat;
        return this;
    }

    public boolean isLenientDatetimeFormat() {
        return this.lenientDatetimeFormat;
    }

    public ApiClient setLenientDatetimeFormat(boolean lenientDatetimeFormat) {
        this.lenientDatetimeFormat = lenientDatetimeFormat;
        return this;
    }

    public Date parseDate(String str) {
        if (str == null) {
            return null;
        }
        try {
            return this.dateFormat.parse(str);
        }
        catch (ParseException e) {
            logger.error("RuntimeException : " + e);
            throw new RuntimeException(e);
        }
    }

    public Date parseDatetime(String str) {
        DateFormat format;
        if (str == null) {
            return null;
        }
        if (this.lenientDatetimeFormat) {
            str = str.replaceAll("[zZ]\\z", "+0000");
            str = str.replaceAll("([+-]\\d{2}):(\\d{2})\\z", "$1$2");
            str = str.replaceAll("([+-]\\d{2})\\z", "$100");
            str = str.replaceAll("(:\\d{1,2})([+-]\\d{4})\\z", "$1.000$2");
            format = new SimpleDateFormat(LENIENT_DATETIME_FORMAT);
        } else {
            format = this.datetimeFormat;
        }
        try {
            return format.parse(str);
        }
        catch (ParseException e) {
            logger.error("RuntimeException : " + e);
            throw new RuntimeException(e);
        }
    }

    public Date parseDateOrDatetime(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() <= this.dateLength) {
            return this.parseDate(str);
        }
        return this.parseDatetime(str);
    }

    public String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    public String formatDatetime(Date date) {
        return this.datetimeFormat.format(date);
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public Authentication getAuthentication(String authName) {
        return this.authentications.get(authName);
    }

    public void setUsername(String username) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setUsername(username);
            return;
        }
        logger.error("RuntimeException : No HTTP basic authentication configured");
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setPassword(String password) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setPassword(password);
            return;
        }
        logger.error("RuntimeException : No HTTP basic authentication configured");
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setApiKey(String apiKey) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKey(apiKey);
            return;
        }
        logger.error("RuntimeException : No API key authentication configured");
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setApiKeyPrefix(String apiKeyPrefix) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKeyPrefix(apiKeyPrefix);
            return;
        }
        logger.error("RuntimeException : No API key authentication configured");
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setAccessToken(String accessToken) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            ((OAuth)auth).setAccessToken(accessToken);
            return;
        }
        logger.error("RuntimeException : No OAuth2 authentication configured");
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    public ApiClient setUserAgent(String userAgent) {
        this.addDefaultHeader("User-Agent", userAgent);
        return this;
    }

    public ApiClient addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
        return this;
    }

    public boolean isLenientOnJson() {
        return this.lenientOnJson;
    }

    public ApiClient setLenientOnJson(boolean lenient) {
        this.lenientOnJson = lenient;
        return this;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public ApiClient setDebugging(boolean debugging) {
        if (debugging != this.debugging) {
            if (debugging) {
                this.loggingInterceptor = new HttpLoggingInterceptor();
                this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
                httpClient.interceptors().add(this.loggingInterceptor);
            } else {
                httpClient.interceptors().remove(this.loggingInterceptor);
                this.loggingInterceptor = null;
            }
        }
        this.debugging = debugging;
        return this;
    }

    public String getTempFolderPath() {
        return this.tempFolderPath;
    }

    public ApiClient setTempFolderPath(String tempFolderPath) {
        this.tempFolderPath = tempFolderPath;
        return this;
    }

    public long getComputationStartTime() {
        return this.computationStartTime;
    }

    public void setComputationStartTime(long computationStartTime) {
        this.computationStartTime = computationStartTime;
    }

    public void resetInstance() {
        this.defaultHeaderMap.clear();
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date) {
            return this.formatDatetime((Date)param);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public List<Pair> parameterToPairs(String collectionFormat, String name, Object value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null) {
            return params;
        }
        Collection valueCollection = null;
        if (!(value instanceof Collection)) {
            params.add(new Pair(name, this.parameterToString(value)));
            return params;
        }
        valueCollection = (Collection)value;
        if (valueCollection.isEmpty()) {
            return params;
        }
        String string = collectionFormat = collectionFormat == null || collectionFormat.isEmpty() ? "csv" : collectionFormat;
        if (collectionFormat.equals("multi")) {
            for (Object item : valueCollection) {
                params.add(new Pair(name, this.parameterToString(item)));
            }
            return params;
        }
        String delimiter = ",";
        if (collectionFormat.equals("csv")) {
            delimiter = ",";
        } else if (collectionFormat.equals("ssv")) {
            delimiter = " ";
        } else if (collectionFormat.equals("tsv")) {
            delimiter = "\t";
        } else if (collectionFormat.equals("pipes")) {
            delimiter = "|";
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : valueCollection) {
            sb.append(delimiter);
            sb.append(this.parameterToString(item));
        }
        params.add(new Pair(name, sb.substring(1)));
        return params;
    }

    public String sanitizeFilename(String filename) {
        return filename.replaceAll(".*[/\\\\]", "");
    }

    public boolean isJsonMime(String mime) {
        String jsonMime = "(?i)^(application/json|[^;/ \t]+/[^;/ \t]+[+]json)[ \t]*(;.*)?$";
        return mime != null && (mime.matches(jsonMime) || mime.equalsIgnoreCase("application/json-patch+json"));
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            if (!this.isJsonMime(accept)) continue;
            return accept;
        }
        return StringUtil.join(accepts, ",");
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0) {
            return "application/json";
        }
        for (String contentType : contentTypes) {
            if (!this.isJsonMime(contentType)) continue;
            return contentType;
        }
        return contentTypes[0];
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public <T> T deserialize(Response response, Type returnType) throws ApiException {
        if (response == null) {
            return null;
        }
        if (returnType == null && response != null || "byte[]".equals(returnType.toString())) {
            InputStream respBody = response.body().byteStream();
            return (T)respBody;
        }
        if (returnType.equals(File.class)) {
            return (T)this.downloadFileFromResponse(response);
        }
        try {
            this.respBody = response.body() != null ? response.body().string() : null;
        }
        catch (IOException e) {
            logger.error("ApiException : " + e);
            throw new ApiException(e);
        }
        if (this.respBody == null || "".equals(this.respBody)) {
            return null;
        }
        String contentType = response.headers().get("Content-Type");
        if (contentType == null) {
            contentType = "application/json";
        }
        if (this.isJsonMime(contentType)) {
            return this.json.deserialize(this.respBody, returnType);
        }
        if (returnType.equals(String.class)) {
            return (T)this.respBody;
        }
        logger.error("ApiException : Content type \"" + contentType + "\" is not supported for type: " + returnType);
        throw new ApiException("Content type \"" + contentType + "\" is not supported for type: " + returnType, response.code(), (Map<String, List<String>>)response.headers().toMultimap(), this.respBody);
    }

    public RequestBody serialize(Object obj, String contentType) throws ApiException {
        if (obj instanceof byte[]) {
            return RequestBody.create((MediaType)MediaType.parse((String)contentType), (byte[])((byte[])obj));
        }
        if (obj instanceof File) {
            return RequestBody.create((MediaType)MediaType.parse((String)contentType), (File)((File)obj));
        }
        if (this.isJsonMime(contentType)) {
            String content = obj != null ? this.json.serialize(obj) : null;
            return RequestBody.create((MediaType)MediaType.parse((String)contentType), (String)content);
        }
        logger.error("ApiException : Content type \"" + contentType + "\" is not supported");
        throw new ApiException("Content type \"" + contentType + "\" is not supported");
    }

    public File downloadFileFromResponse(Response response) throws ApiException {
        try {
            File file = this.prepareDownloadFile(response);
            BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)file));
            sink.writeAll((Source)response.body().source());
            sink.close();
            return file;
        }
        catch (IOException e) {
            logger.error("ApiException : " + e);
            throw new ApiException(e);
        }
    }

    public File prepareDownloadFile(Response response) throws IOException {
        Pattern pattern;
        Matcher matcher;
        String filename = null;
        String contentDisposition = response.header("Content-Disposition");
        if (contentDisposition != null && !"".equals(contentDisposition) && (matcher = (pattern = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition)).find()) {
            filename = this.sanitizeFilename(matcher.group(1));
        }
        String prefix = null;
        String suffix = null;
        if (filename == null) {
            prefix = "download-";
            suffix = "";
        } else {
            int pos = filename.lastIndexOf(".");
            if (pos == -1) {
                prefix = filename + "-";
            } else {
                prefix = filename.substring(0, pos) + "-";
                suffix = filename.substring(pos);
            }
            if (prefix.length() < 3) {
                prefix = "download-";
            }
        }
        if (this.tempFolderPath == null) {
            return File.createTempFile(prefix, suffix);
        }
        return File.createTempFile(prefix, suffix, new File(this.tempFolderPath));
    }

    public <T> ApiResponse<T> execute(Call call) throws ApiException {
        return this.execute(call, null);
    }

    public <T> ApiResponse<T> execute(Call call, Type returnType) throws ApiException {
        try {
            this.apiRequestMetrics.setComputeTime((System.nanoTime() - this.getComputationStartTime()) / 1000000L);
            Response response = call.execute();
            this.responseCode = String.valueOf(response.code());
            this.status = response.message();
            logger.debug("Network Response :\n" + this.json.serialize(response.body()));
            if (returnType == new TypeToken<AccessTokenResponse>(){}.getType()) {
                logger.debug("Response :\n" + response.peekBody(Long.MAX_VALUE).string());
            }
            T data = this.handleResponse(response, returnType);
            if (returnType != null || call.request().method().equalsIgnoreCase("DELETE") || this.responseCode.equalsIgnoreCase("202")) {
                response.body().close();
            }
            logger.info("HTTP Response Body :\n{}", data);
            return new ApiResponse<T>(response.code(), response.headers().toMultimap(), data);
        }
        catch (IOException e) {
            logger.error("ApiException : " + e.getMessage());
            throw new ApiException(e);
        }
        catch (NullPointerException e) {
            logger.error("ApiException : " + e.getMessage());
            throw new ApiException(e);
        }
    }

    public <T> void executeAsync(Call call, ApiCallback<T> callback) {
        this.executeAsync(call, null, callback);
    }

    public <T> void executeAsync(Call call, final Type returnType, final ApiCallback<T> callback) {
        call.enqueue(new Callback(){

            public void onFailure(Call call0, IOException e) {
                callback.onFailure(new ApiException(e), 0, null);
            }

            public void onResponse(Call call0, Response response) throws IOException {
                Object result;
                try {
                    result = ApiClient.this.handleResponse(response, returnType);
                }
                catch (ApiException e) {
                    callback.onFailure(e, response.code(), response.headers().toMultimap());
                    return;
                }
                callback.onSuccess(result, response.code(), response.headers().toMultimap());
            }
        });
    }

    public <T> T handleResponse(Response response, Type returnType) throws ApiException {
        if (response.isSuccessful()) {
            if (response.code() == 204) {
                if (response.body() != null) {
                    response.body().close();
                }
                return null;
            }
            return this.deserialize(response, returnType);
        }
        String respBody = null;
        if (response.body() != null) {
            try {
                respBody = response.body().string();
                logger.info(respBody);
            }
            catch (IOException e) {
                logger.error("ApiException : " + e + " " + response.code() + " " + response.message());
                throw new ApiException(response.message(), (Throwable)e, response.code(), response.headers().toMultimap());
            }
        }
        logger.error("ApiException : " + response.code() + " " + response.message());
        throw new ApiException(response.message(), response.code(), (Map<String, List<String>>)response.headers().toMultimap(), respBody);
    }

    public Call buildCall(String path, String method, List<Pair> queryParams, Object body, Map<String, String> headerParams, Map<String, Object> formParams, String[] authNames, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        this.callAuthenticationHeader(method, path, body, queryParams);
        if (this.merchantConfig.isEnableClientCert()) {
            this.addClientCertToKeyStore();
        }
        if (this.acceptHeader != null && !this.acceptHeader.isEmpty()) {
            String defaultAcceptHeader = "," + headerParams.get("Accept");
            defaultAcceptHeader = this.acceptHeader + defaultAcceptHeader.replace("," + this.acceptHeader, "");
            headerParams.remove("Accept");
            headerParams.put("Accept", defaultAcceptHeader);
        }
        headerParams.putAll(this.defaultHeaderMap);
        logger.info("Request Header Parameters:\n{}", (Object)new PrettyPrintingMap(headerParams));
        Request request = this.buildRequest(path, method, queryParams, body, headerParams, formParams, authNames, progressRequestListener);
        return httpClient.newCall(request);
    }

    public void callAuthenticationHeader(String method, String path, Object body, List<Pair> queryParams) {
        try {
            this.merchantConfig.setRequestType(method);
            if (queryParams != null && !queryParams.isEmpty()) {
                StringBuilder url = new StringBuilder();
                url.append(path);
                if (this.merchantConfig.getAuthenticationType().equalsIgnoreCase("HTTP_Signature")) {
                    String prefix = path.contains("?") ? "&" : "?";
                    for (Pair param : queryParams) {
                        if (param.getValue() == null) continue;
                        if (prefix != null) {
                            url.append(prefix);
                            prefix = null;
                        } else {
                            url.append("&");
                        }
                        String value = this.parameterToString(param.getValue());
                        url.append(this.escapeString(param.getName())).append("=").append(this.escapeString(value));
                    }
                    this.merchantConfig.setRequestTarget(url.toString());
                }
            } else {
                this.merchantConfig.setRequestTarget(path);
            }
            Authorization authorization = new Authorization();
            String requestBody = this.json.serialize(body);
            logger.debug("HTTP Request Body:\n" + requestBody);
            this.merchantConfig.setRequestData(requestBody);
            authorization.setJWTRequestBody(requestBody);
            boolean isMerchantDetails = this.merchantConfig.validateMerchantDetails();
            this.merchantConfig.setRequestHost(this.merchantConfig.getRequestHost().trim());
            if (isMerchantDetails && !this.merchantConfig.getAuthenticationType().equalsIgnoreCase("MutualAuth")) {
                String token = authorization.getToken(this.merchantConfig);
                if (this.merchantConfig.getAuthenticationType().equalsIgnoreCase("HTTP_Signature")) {
                    this.addDefaultHeader("Date", PropertiesUtil.date);
                    this.addDefaultHeader("Host", this.merchantConfig.getRequestHost().trim());
                    this.addDefaultHeader("v-c-merchant-id", this.merchantConfig.getMerchantID());
                    this.addDefaultHeader("Signature", token);
                    this.addDefaultHeader("User-Agent", "Mozilla/5.0");
                    if (method.equalsIgnoreCase("POST") || method.equalsIgnoreCase("PUT") || method.equalsIgnoreCase("PATCH")) {
                        PayloadDigest payloadDigest = new PayloadDigest(this.merchantConfig);
                        String digest = payloadDigest.getDigest();
                        this.addDefaultHeader("Digest", digest);
                    }
                } else if (this.merchantConfig.getAuthenticationType().equalsIgnoreCase("JWT")) {
                    token = "Bearer " + token;
                    this.addDefaultHeader("Authorization", token);
                } else if (this.merchantConfig.getAuthenticationType().equalsIgnoreCase("OAuth")) {
                    token = "Bearer " + token;
                    this.addDefaultHeader("Authorization", token);
                }
            }
            if (this.versionInfo != null && !this.versionInfo.isEmpty()) {
                this.addDefaultHeader("v-c-client-id", "cybs-rest-sdk-java-" + this.versionInfo);
            }
        }
        catch (ConfigException e) {
            logger.error(e.getMessage());
        }
    }

    public Request buildRequest(String path, String method, List<Pair> queryParams, Object body, Map<String, String> headerParams, Map<String, Object> formParams, String[] authNames, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object reqBody;
        this.updateParamsForAuth(authNames, queryParams, headerParams);
        String url = this.buildUrl(path, queryParams);
        Request.Builder reqBuilder = new Request.Builder().url(url);
        this.processHeaderParams(headerParams, reqBuilder);
        String contentType = headerParams.get("Content-Type");
        if (contentType == null) {
            contentType = "application/json";
        }
        if (!HttpMethod.permitsRequestBody((String)method)) {
            reqBody = null;
        } else if ("application/x-www-form-urlencoded".equals(contentType)) {
            Gson gson = new Gson();
            String jsonString = this.json.serialize(body);
            formParams = (Map)gson.fromJson(jsonString, HashMap.class);
            reqBody = this.buildRequestBodyFormEncoding(formParams);
        } else {
            reqBody = "multipart/form-data".equals(contentType) ? this.buildRequestBodyMultipart(formParams) : (body == null ? ("DELETE".equals(method) ? null : RequestBody.create((MediaType)MediaType.parse((String)contentType), (String)"")) : this.serialize(body, contentType));
        }
        Request request = null;
        if (progressRequestListener != null && reqBody != null) {
            ProgressRequestBody progressRequestBody = new ProgressRequestBody((RequestBody)reqBody, progressRequestListener);
            request = reqBuilder.method(method, (RequestBody)progressRequestBody).build();
        } else {
            request = reqBuilder.method(method, reqBody).build();
        }
        return request;
    }

    public String buildUrl(String path, List<Pair> queryParams) {
        StringBuilder url = new StringBuilder();
        url.append("https://").append(this.merchantConfig.getRequestHost().trim()).append(path);
        if (queryParams != null && !queryParams.isEmpty()) {
            String prefix = path.contains("?") ? "&" : "?";
            for (Pair param : queryParams) {
                if (param.getValue() == null) continue;
                if (prefix != null) {
                    url.append(prefix);
                    prefix = null;
                } else {
                    url.append("&");
                }
                String value = this.parameterToString(param.getValue());
                url.append(this.escapeString(param.getName())).append("=").append(this.escapeString(value));
            }
        }
        return url.toString();
    }

    public void processHeaderParams(Map<String, String> headerParams, Request.Builder reqBuilder) {
        for (Map.Entry<String, String> param : headerParams.entrySet()) {
            reqBuilder.header(param.getKey(), this.parameterToString(param.getValue()));
        }
        for (Map.Entry<String, String> header : this.defaultHeaderMap.entrySet()) {
            if (headerParams.containsKey(header.getKey())) continue;
            reqBuilder.header(header.getKey(), this.parameterToString(header.getValue()));
        }
        reqBuilder.header("Connection", "keep-alive");
    }

    public void updateParamsForAuth(String[] authNames, List<Pair> queryParams, Map<String, String> headerParams) {
        for (String authName : authNames) {
            Authentication auth = this.authentications.get(authName);
            if (auth == null) {
                logger.error("RuntimeException : Authentication undefined for " + authName);
                throw new RuntimeException("Authentication undefined: " + authName);
            }
            auth.applyToParams(queryParams, headerParams);
        }
    }

    public RequestBody buildRequestBodyFormEncoding(Map<String, Object> formParams) {
        FormBody.Builder formBuilder = new FormBody.Builder();
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            formBuilder.addEncoded(param.getKey(), this.parameterToString(param.getValue()));
        }
        return formBuilder.build();
    }

    public RequestBody buildRequestBodyMultipart(Map<String, Object> formParams) {
        MultipartBody.Builder mpBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            if (param.getValue() instanceof File) {
                File file = (File)param.getValue();
                Headers partHeaders = Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + param.getKey() + "\"; filename=\"" + file.getName() + "\""});
                MediaType mediaType = MediaType.parse((String)this.guessContentTypeFromFile(file));
                mpBuilder.addPart(partHeaders, RequestBody.create((MediaType)mediaType, (File)file));
                continue;
            }
            Headers partHeaders = Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + param.getKey() + "\""});
            mpBuilder.addPart(partHeaders, RequestBody.create(null, (String)this.parameterToString(param.getValue())));
        }
        return mpBuilder.build();
    }

    public String guessContentTypeFromFile(File file) {
        String contentType = URLConnection.guessContentTypeFromName(file.getName());
        if (contentType == null) {
            return "application/octet-stream";
        }
        return contentType;
    }

    private void initDatetimeFormat() {
        String formatWithTimeZone = null;
        if (IS_ANDROID) {
            if (ANDROID_SDK_VERSION >= 18) {
                formatWithTimeZone = "yyyy-MM-dd'T'HH:mm:ss.SSSZZZZZ";
            }
        } else if (JAVA_VERSION >= 1.7) {
            formatWithTimeZone = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
        }
        if (formatWithTimeZone != null) {
            this.datetimeFormat = new SimpleDateFormat(formatWithTimeZone);
        } else {
            this.datetimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            this.datetimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    }

    private void addClientCertToKeyStore() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            KeyStore merchantKeyStore = KeyStore.getInstance("PKCS12", (Provider)new BouncyCastleProvider());
            FileInputStream file = new FileInputStream(new File(this.merchantConfig.getClientCertDirectory(), this.merchantConfig.getClientCertFile()));
            merchantKeyStore.load(file, this.merchantConfig.getClientCertPassword().toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(merchantKeyStore, new char[0]);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagerFactory.getKeyManagers(), trustAllCerts, new SecureRandom());
            httpClient = httpClient.newBuilder().sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustAllCerts[0]).build();
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException exception) {
            // empty catch block
        }
    }

    private void applySslSettings() {
        try {
            TrustManager[] trustManagers = null;
            HostnameVerifier hostnameVerifier = null;
            if (!this.verifyingSsl) {
                X509TrustManager trustAll = new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                };
                trustManagers = new TrustManager[]{trustAll};
                hostnameVerifier = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };
            } else if (this.sslCaCert != null) {
                char[] password = null;
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(this.sslCaCert);
                if (certificates.isEmpty()) {
                    logger.error("IllegalArgumentException : Expected non-empty set of trusted certificates");
                    throw new IllegalArgumentException("expected non-empty set of trusted certificates");
                }
                KeyStore caKeyStore = this.newEmptyKeyStore(password);
                int index = 0;
                for (Certificate certificate : certificates) {
                    String certificateAlias = "ca" + Integer.toString(index++);
                    caKeyStore.setCertificateEntry(certificateAlias, certificate);
                }
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(caKeyStore);
                trustManagers = trustManagerFactory.getTrustManagers();
            }
            if (this.keyManagers != null || trustManagers != null) {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(this.keyManagers, trustManagers, new SecureRandom());
                httpClient = httpClient.newBuilder().sslSocketFactory(sslContext.getSocketFactory()).build();
            } else {
                httpClient = httpClient.newBuilder().sslSocketFactory(null).build();
            }
            httpClient = httpClient.newBuilder().hostnameVerifier(hostnameVerifier).build();
        }
        catch (GeneralSecurityException e) {
            logger.error("RuntimeException : " + e);
            throw new RuntimeException(e);
        }
    }

    private KeyStore newEmptyKeyStore(char[] password) throws GeneralSecurityException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, password);
            return keyStore;
        }
        catch (IOException e) {
            logger.error("AssertionError : " + e);
            throw new AssertionError((Object)e);
        }
    }

    private long getNewRandomId() {
        SecureRandom random = new SecureRandom();
        byte[] sessBytes = new byte[32];
        random.nextBytes(sessBytes);
        long randomId = 0L;
        for (int i = 0; i < sessBytes.length; ++i) {
            randomId += ((long)sessBytes[i] & 0xFFL) << 8 * i;
        }
        return randomId;
    }

    static {
        boolean isAndroid;
        JAVA_VERSION = Double.parseDouble(System.getProperty("java.specification.version"));
        try {
            Class.forName("android.app.Activity");
            isAndroid = true;
        }
        catch (ClassNotFoundException e) {
            isAndroid = false;
        }
        IS_ANDROID = isAndroid;
        int sdkVersion = 0;
        if (IS_ANDROID) {
            try {
                sdkVersion = Class.forName("android.os.Build$VERSION").getField("SDK_INT").getInt(null);
            }
            catch (Exception e) {
                try {
                    sdkVersion = Integer.parseInt((String)Class.forName("android.os.Build$VERSION").getField("SDK").get(null));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        ANDROID_SDK_VERSION = sdkVersion;
        connectionPool = new ConnectionPool(5, 10L, TimeUnit.SECONDS);
        logger = LogManager.getLogger(ApiClient.class);
    }
}

