/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.PatchCustomerPaymentInstrumentRequest;
import Model.PaymentInstrumentList;
import Model.PostCustomerPaymentInstrumentRequest;
import Model.Tmsv2customersEmbeddedDefaultPaymentInstrument;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomerPaymentInstrumentApi {
    private static Logger logger = LogManager.getLogger(CustomerPaymentInstrumentApi.class);
    private ApiClient apiClient;

    public CustomerPaymentInstrumentApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomerPaymentInstrumentApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteCustomerPaymentInstrumentCall(String customerTokenId, String paymentInstrumentTokenId, String profileId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String localVarPostBody = null;
        if ("DELETE".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        String localVarPath = "/tms/v2/customers/{customerTokenId}/payment-instruments/{paymentInstrumentTokenId}".replaceAll("\\{customerTokenId\\}", this.apiClient.escapeString(customerTokenId.toString())).replaceAll("\\{paymentInstrumentTokenId\\}", this.apiClient.escapeString(paymentInstrumentTokenId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteCustomerPaymentInstrumentValidateBeforeCall(String customerTokenId, String paymentInstrumentTokenId, String profileId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerTokenId == null) {
            logger.error("Missing the required parameter 'customerTokenId' when calling deleteCustomerPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'customerTokenId' when calling deleteCustomerPaymentInstrument(Async)");
        }
        if (paymentInstrumentTokenId == null) {
            logger.error("Missing the required parameter 'paymentInstrumentTokenId' when calling deleteCustomerPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'paymentInstrumentTokenId' when calling deleteCustomerPaymentInstrument(Async)");
        }
        Call call = this.deleteCustomerPaymentInstrumentCall(customerTokenId, paymentInstrumentTokenId, profileId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteCustomerPaymentInstrument(String customerTokenId, String paymentInstrumentTokenId, String profileId) throws ApiException {
        logger.info("CALL TO METHOD 'deleteCustomerPaymentInstrument' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        this.deleteCustomerPaymentInstrumentWithHttpInfo(customerTokenId, paymentInstrumentTokenId, profileId);
    }

    public ApiResponse<Void> deleteCustomerPaymentInstrumentWithHttpInfo(String customerTokenId, String paymentInstrumentTokenId, String profileId) throws ApiException {
        Call call = this.deleteCustomerPaymentInstrumentValidateBeforeCall(customerTokenId, paymentInstrumentTokenId, profileId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteCustomerPaymentInstrumentAsync(String customerTokenId, String paymentInstrumentTokenId, String profileId, final ApiCallback<Void> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteCustomerPaymentInstrumentValidateBeforeCall(customerTokenId, paymentInstrumentTokenId, profileId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getCustomerPaymentInstrumentCall(String customerTokenId, String paymentInstrumentTokenId, String profileId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        String localVarPath = "/tms/v2/customers/{customerTokenId}/payment-instruments/{paymentInstrumentTokenId}".replaceAll("\\{customerTokenId\\}", this.apiClient.escapeString(customerTokenId.toString())).replaceAll("\\{paymentInstrumentTokenId\\}", this.apiClient.escapeString(paymentInstrumentTokenId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCustomerPaymentInstrumentValidateBeforeCall(String customerTokenId, String paymentInstrumentTokenId, String profileId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerTokenId == null) {
            logger.error("Missing the required parameter 'customerTokenId' when calling getCustomerPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'customerTokenId' when calling getCustomerPaymentInstrument(Async)");
        }
        if (paymentInstrumentTokenId == null) {
            logger.error("Missing the required parameter 'paymentInstrumentTokenId' when calling getCustomerPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'paymentInstrumentTokenId' when calling getCustomerPaymentInstrument(Async)");
        }
        Call call = this.getCustomerPaymentInstrumentCall(customerTokenId, paymentInstrumentTokenId, profileId, progressListener, progressRequestListener);
        return call;
    }

    public Tmsv2customersEmbeddedDefaultPaymentInstrument getCustomerPaymentInstrument(String customerTokenId, String paymentInstrumentTokenId, String profileId) throws ApiException {
        logger.info("CALL TO METHOD 'getCustomerPaymentInstrument' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<Tmsv2customersEmbeddedDefaultPaymentInstrument> resp = this.getCustomerPaymentInstrumentWithHttpInfo(customerTokenId, paymentInstrumentTokenId, profileId);
        logger.info("CALL TO METHOD 'getCustomerPaymentInstrument' ENDED");
        return resp.getData();
    }

    public ApiResponse<Tmsv2customersEmbeddedDefaultPaymentInstrument> getCustomerPaymentInstrumentWithHttpInfo(String customerTokenId, String paymentInstrumentTokenId, String profileId) throws ApiException {
        Call call = this.getCustomerPaymentInstrumentValidateBeforeCall(customerTokenId, paymentInstrumentTokenId, profileId, null, null);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultPaymentInstrument>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCustomerPaymentInstrumentAsync(String customerTokenId, String paymentInstrumentTokenId, String profileId, final ApiCallback<Tmsv2customersEmbeddedDefaultPaymentInstrument> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCustomerPaymentInstrumentValidateBeforeCall(customerTokenId, paymentInstrumentTokenId, profileId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultPaymentInstrument>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCustomerPaymentInstrumentsListCall(String customerTokenId, String profileId, Long offset, Long limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        String localVarPath = "/tms/v2/customers/{customerTokenId}/payment-instruments".replaceAll("\\{customerTokenId\\}", this.apiClient.escapeString(customerTokenId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCustomerPaymentInstrumentsListValidateBeforeCall(String customerTokenId, String profileId, Long offset, Long limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerTokenId == null) {
            logger.error("Missing the required parameter 'customerTokenId' when calling getCustomerPaymentInstrumentsList(Async)");
            throw new ApiException("Missing the required parameter 'customerTokenId' when calling getCustomerPaymentInstrumentsList(Async)");
        }
        Call call = this.getCustomerPaymentInstrumentsListCall(customerTokenId, profileId, offset, limit, progressListener, progressRequestListener);
        return call;
    }

    public PaymentInstrumentList getCustomerPaymentInstrumentsList(String customerTokenId, String profileId, Long offset, Long limit) throws ApiException {
        logger.info("CALL TO METHOD 'getCustomerPaymentInstrumentsList' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<PaymentInstrumentList> resp = this.getCustomerPaymentInstrumentsListWithHttpInfo(customerTokenId, profileId, offset, limit);
        logger.info("CALL TO METHOD 'getCustomerPaymentInstrumentsList' ENDED");
        return resp.getData();
    }

    public ApiResponse<PaymentInstrumentList> getCustomerPaymentInstrumentsListWithHttpInfo(String customerTokenId, String profileId, Long offset, Long limit) throws ApiException {
        Call call = this.getCustomerPaymentInstrumentsListValidateBeforeCall(customerTokenId, profileId, offset, limit, null, null);
        Type localVarReturnType = new TypeToken<PaymentInstrumentList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCustomerPaymentInstrumentsListAsync(String customerTokenId, String profileId, Long offset, Long limit, final ApiCallback<PaymentInstrumentList> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCustomerPaymentInstrumentsListValidateBeforeCall(customerTokenId, profileId, offset, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PaymentInstrumentList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchCustomersPaymentInstrumentCall(String customerTokenId, String paymentInstrumentTokenId, PatchCustomerPaymentInstrumentRequest patchCustomerPaymentInstrumentRequest, String profileId, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        PatchCustomerPaymentInstrumentRequest localVarPostBody = patchCustomerPaymentInstrumentRequest;
        String localVarPath = "/tms/v2/customers/{customerTokenId}/payment-instruments/{paymentInstrumentTokenId}".replaceAll("\\{customerTokenId\\}", this.apiClient.escapeString(customerTokenId.toString())).replaceAll("\\{paymentInstrumentTokenId\\}", this.apiClient.escapeString(paymentInstrumentTokenId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        if (ifMatch != null) {
            localVarHeaderParams.put("if-match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchCustomersPaymentInstrumentValidateBeforeCall(String customerTokenId, String paymentInstrumentTokenId, PatchCustomerPaymentInstrumentRequest patchCustomerPaymentInstrumentRequest, String profileId, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerTokenId == null) {
            logger.error("Missing the required parameter 'customerTokenId' when calling patchCustomersPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'customerTokenId' when calling patchCustomersPaymentInstrument(Async)");
        }
        if (paymentInstrumentTokenId == null) {
            logger.error("Missing the required parameter 'paymentInstrumentTokenId' when calling patchCustomersPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'paymentInstrumentTokenId' when calling patchCustomersPaymentInstrument(Async)");
        }
        if (patchCustomerPaymentInstrumentRequest == null) {
            logger.error("Missing the required parameter 'patchCustomerPaymentInstrumentRequest' when calling patchCustomersPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'patchCustomerPaymentInstrumentRequest' when calling patchCustomersPaymentInstrument(Async)");
        }
        Call call = this.patchCustomersPaymentInstrumentCall(customerTokenId, paymentInstrumentTokenId, patchCustomerPaymentInstrumentRequest, profileId, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public Tmsv2customersEmbeddedDefaultPaymentInstrument patchCustomersPaymentInstrument(String customerTokenId, String paymentInstrumentTokenId, PatchCustomerPaymentInstrumentRequest patchCustomerPaymentInstrumentRequest, String profileId, String ifMatch) throws ApiException {
        logger.info("CALL TO METHOD 'patchCustomersPaymentInstrument' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<Tmsv2customersEmbeddedDefaultPaymentInstrument> resp = this.patchCustomersPaymentInstrumentWithHttpInfo(customerTokenId, paymentInstrumentTokenId, patchCustomerPaymentInstrumentRequest, profileId, ifMatch);
        logger.info("CALL TO METHOD 'patchCustomersPaymentInstrument' ENDED");
        return resp.getData();
    }

    public ApiResponse<Tmsv2customersEmbeddedDefaultPaymentInstrument> patchCustomersPaymentInstrumentWithHttpInfo(String customerTokenId, String paymentInstrumentTokenId, PatchCustomerPaymentInstrumentRequest patchCustomerPaymentInstrumentRequest, String profileId, String ifMatch) throws ApiException {
        Call call = this.patchCustomersPaymentInstrumentValidateBeforeCall(customerTokenId, paymentInstrumentTokenId, patchCustomerPaymentInstrumentRequest, profileId, ifMatch, null, null);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultPaymentInstrument>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchCustomersPaymentInstrumentAsync(String customerTokenId, String paymentInstrumentTokenId, PatchCustomerPaymentInstrumentRequest patchCustomerPaymentInstrumentRequest, String profileId, String ifMatch, final ApiCallback<Tmsv2customersEmbeddedDefaultPaymentInstrument> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchCustomersPaymentInstrumentValidateBeforeCall(customerTokenId, paymentInstrumentTokenId, patchCustomerPaymentInstrumentRequest, profileId, ifMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultPaymentInstrument>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postCustomerPaymentInstrumentCall(String customerTokenId, PostCustomerPaymentInstrumentRequest postCustomerPaymentInstrumentRequest, String profileId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        PostCustomerPaymentInstrumentRequest localVarPostBody = postCustomerPaymentInstrumentRequest;
        String localVarPath = "/tms/v2/customers/{customerTokenId}/payment-instruments".replaceAll("\\{customerTokenId\\}", this.apiClient.escapeString(customerTokenId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postCustomerPaymentInstrumentValidateBeforeCall(String customerTokenId, PostCustomerPaymentInstrumentRequest postCustomerPaymentInstrumentRequest, String profileId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerTokenId == null) {
            logger.error("Missing the required parameter 'customerTokenId' when calling postCustomerPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'customerTokenId' when calling postCustomerPaymentInstrument(Async)");
        }
        if (postCustomerPaymentInstrumentRequest == null) {
            logger.error("Missing the required parameter 'postCustomerPaymentInstrumentRequest' when calling postCustomerPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'postCustomerPaymentInstrumentRequest' when calling postCustomerPaymentInstrument(Async)");
        }
        Call call = this.postCustomerPaymentInstrumentCall(customerTokenId, postCustomerPaymentInstrumentRequest, profileId, progressListener, progressRequestListener);
        return call;
    }

    public Tmsv2customersEmbeddedDefaultPaymentInstrument postCustomerPaymentInstrument(String customerTokenId, PostCustomerPaymentInstrumentRequest postCustomerPaymentInstrumentRequest, String profileId) throws ApiException {
        logger.info("CALL TO METHOD 'postCustomerPaymentInstrument' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<Tmsv2customersEmbeddedDefaultPaymentInstrument> resp = this.postCustomerPaymentInstrumentWithHttpInfo(customerTokenId, postCustomerPaymentInstrumentRequest, profileId);
        logger.info("CALL TO METHOD 'postCustomerPaymentInstrument' ENDED");
        return resp.getData();
    }

    public ApiResponse<Tmsv2customersEmbeddedDefaultPaymentInstrument> postCustomerPaymentInstrumentWithHttpInfo(String customerTokenId, PostCustomerPaymentInstrumentRequest postCustomerPaymentInstrumentRequest, String profileId) throws ApiException {
        Call call = this.postCustomerPaymentInstrumentValidateBeforeCall(customerTokenId, postCustomerPaymentInstrumentRequest, profileId, null, null);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultPaymentInstrument>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postCustomerPaymentInstrumentAsync(String customerTokenId, PostCustomerPaymentInstrumentRequest postCustomerPaymentInstrumentRequest, String profileId, final ApiCallback<Tmsv2customersEmbeddedDefaultPaymentInstrument> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postCustomerPaymentInstrumentValidateBeforeCall(customerTokenId, postCustomerPaymentInstrumentRequest, profileId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tmsv2customersEmbeddedDefaultPaymentInstrument>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

