/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.FlexV1KeysPost200Response;
import Model.GeneratePublicKeyRequest;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeyGenerationApi {
    private static Logger logger = LogManager.getLogger(KeyGenerationApi.class);
    private ApiClient apiClient;

    public KeyGenerationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public KeyGenerationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call generatePublicKeyCall(String format, GeneratePublicKeyRequest generatePublicKeyRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        GeneratePublicKeyRequest localVarPostBody = generatePublicKeyRequest;
        String localVarPath = "/flex/v1/keys";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (format != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "format", format));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call generatePublicKeyValidateBeforeCall(String format, GeneratePublicKeyRequest generatePublicKeyRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            logger.error("Missing the required parameter 'format' when calling generatePublicKey(Async)");
            throw new ApiException("Missing the required parameter 'format' when calling generatePublicKey(Async)");
        }
        if (generatePublicKeyRequest == null) {
            logger.error("Missing the required parameter 'generatePublicKeyRequest' when calling generatePublicKey(Async)");
            throw new ApiException("Missing the required parameter 'generatePublicKeyRequest' when calling generatePublicKey(Async)");
        }
        Call call = this.generatePublicKeyCall(format, generatePublicKeyRequest, progressListener, progressRequestListener);
        return call;
    }

    public FlexV1KeysPost200Response generatePublicKey(String format, GeneratePublicKeyRequest generatePublicKeyRequest) throws ApiException {
        logger.info("CALL TO METHOD 'generatePublicKey' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<FlexV1KeysPost200Response> resp = this.generatePublicKeyWithHttpInfo(format, generatePublicKeyRequest);
        logger.info("CALL TO METHOD 'generatePublicKey' ENDED");
        return resp.getData();
    }

    public ApiResponse<FlexV1KeysPost200Response> generatePublicKeyWithHttpInfo(String format, GeneratePublicKeyRequest generatePublicKeyRequest) throws ApiException {
        Call call = this.generatePublicKeyValidateBeforeCall(format, generatePublicKeyRequest, null, null);
        Type localVarReturnType = new TypeToken<FlexV1KeysPost200Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call generatePublicKeyAsync(String format, GeneratePublicKeyRequest generatePublicKeyRequest, final ApiCallback<FlexV1KeysPost200Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.generatePublicKeyValidateBeforeCall(format, generatePublicKeyRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FlexV1KeysPost200Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

