/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.FlexV1TokensPost200Response;
import Model.TokenizeRequest;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TokenizationApi {
    private static Logger logger = LogManager.getLogger(TokenizationApi.class);
    private ApiClient apiClient;

    public TokenizationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TokenizationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call tokenizeCall(TokenizeRequest tokenizeRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TokenizeRequest localVarPostBody = tokenizeRequest;
        String localVarPath = "/flex/v1/tokens";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call tokenizeValidateBeforeCall(TokenizeRequest tokenizeRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tokenizeRequest == null) {
            logger.error("Missing the required parameter 'tokenizeRequest' when calling tokenize(Async)");
            throw new ApiException("Missing the required parameter 'tokenizeRequest' when calling tokenize(Async)");
        }
        Call call = this.tokenizeCall(tokenizeRequest, progressListener, progressRequestListener);
        return call;
    }

    public FlexV1TokensPost200Response tokenize(TokenizeRequest tokenizeRequest) throws ApiException {
        logger.info("CALL TO METHOD 'tokenize' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<FlexV1TokensPost200Response> resp = this.tokenizeWithHttpInfo(tokenizeRequest);
        logger.info("CALL TO METHOD 'tokenize' ENDED");
        return resp.getData();
    }

    public ApiResponse<FlexV1TokensPost200Response> tokenizeWithHttpInfo(TokenizeRequest tokenizeRequest) throws ApiException {
        Call call = this.tokenizeValidateBeforeCall(tokenizeRequest, null, null);
        Type localVarReturnType = new TypeToken<FlexV1TokensPost200Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call tokenizeAsync(TokenizeRequest tokenizeRequest, final ApiCallback<FlexV1TokensPost200Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.tokenizeValidateBeforeCall(tokenizeRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FlexV1TokensPost200Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

